// measureRailStopPlate 1

$fn = 32;

plateWidth = 44;
plateHeight = 22;
plateThick = 3.0;

topextensionWidth = 34;
topExtensionHeight = 2.0;

topExtensionXPos = (plateWidth - topextensionWidth) / 2;

holeBlockWidth = 5;
holeBlockHeight = 14;
holeBlockThick = 5;

holeDiameter = 2.5;
holeLength = 5.2;
holeYPos1 = holeBlockWidth / 2;
holeYPos2 = 11;
holeZPos = holeBlockWidth / 2; // + plateThick;

module hole() {
    rotate([0, 90, 0]) {
        cylinder(h = holeLength, d = holeDiameter);
    }
}

translate() {
    cube([plateWidth, plateHeight, plateThick]);
}

translate([topExtensionXPos, plateHeight, 0]) {
    cube([topextensionWidth, topExtensionHeight, plateThick]);
}

translate([0, 0, plateThick]) {
  difference() {
    cube([holeBlockWidth, holeBlockHeight, holeBlockThick]);
    translate([-0.1, holeYPos1, holeZPos]) {
        hole();
    }
    translate([-0.1, holeYPos2, holeZPos]) {
        hole();
    }
  }
}

translate([plateWidth - holeBlockWidth, 0, plateThick]) {
  difference() {
    cube([holeBlockWidth, holeBlockHeight, holeBlockThick]);
    translate([-0.1, holeYPos1, holeZPos]) {
        hole();
    }
    translate([-0.1, holeYPos2, holeZPos]) {
        hole();
    }
  }
}

module nonPrinting() {
    translate([-3, 0, 0]) {
        cube([3, 5, 3 + 1.25]);
    }
     translate([-3, 0, 3 + 2.5 + 1.25]) {
        cube([3, 5, 2]);
    }
   
}

//color("red") nonPrinting();