// laserCage 2

$fn = 36;

d110Length = 120;
d110Width = 37;
d110Depth = 20;
d110FrontDepth = 23;

cageWallThick = 2.5;

basePlateWidth = 30;
baseplateLength = 120;

fwHeight = 18;
fwWidth = 22;

fwYoffset = 8;
fwZoffset = 2;

midHolesXoffset1 = 42;
midHolesXoffset2 = 82;
midHolesYoffset1 = 4 + cageWallThick + (d110Width - basePlateWidth) / 2;
midHolesYoffset2 = d110Width + cageWallThick * 2 - midHolesYoffset1;
holeDiameter = 3;
holeTopDiam  = 6;
holeTaperHeight = 2;

reliefHeight = d110Depth - 6;
reliefXoffset = 4;
reliefYoffset = 3.7;
reliefZoffset = 2.5;
reliefDiam = 4;
reliefDepth = 1.25;

topRounding = cageWallThick / 2;

module frontWindow() {
    cube([cageWallThick + 0.2, fwWidth, fwHeight]);
}

module reliefX() {
    $fn = 6;
    for (i = [0:5:115]) {
        translate([i, 0, 0]) {
            translate([0, 0, 0]) sphere(d = reliefDiam);
            translate([0, 0, 0]) cylinder(h = reliefHeight, d = reliefDiam);
            translate([0, 0, reliefHeight]) sphere(d = reliefDiam);
        }
    }
}

module reliefY() {
    $fn = 6;
    for (i = [0:5:35]) {
        translate([0, i, 0]) {
            rotate([0, 0, 90]) {
                translate([0, 0, 0]) sphere(d = reliefDiam);
                translate([0, 0, 0]) cylinder(h = reliefHeight, d = reliefDiam);
                translate([0, 0, reliefHeight]) sphere(d = reliefDiam);
            }
        }
    }    
}

module hole() {
    union() {
        // cylindrical part
        cylinder(d = holeDiameter, h = cageWallThick);
        // conical part
        translate([0, 0, 0.5]) cylinder(h = holeTaperHeight, d1 = holeDiameter, d2 = holeTopDiam);
    }
}

module quartCurve(rounding) {
    translate([rounding, 0, 0]) sphere(r = rounding);
    translate([d110Length + cageWallThick - rounding, 0, 0]) sphere(r = rounding);
    translate([0, 0, -rounding]) cube([d110Length, rounding, rounding]);
}
    

module cage() {
    difference() {
        cube([d110Length + cageWallThick, d110Width + cageWallThick * 2, d110Depth]);
        // the Disto D100
        translate([0, cageWallThick, cageWallThick]) d110();
        // front side cut out
        translate([d110Length- 0.1, fwYoffset + cageWallThick, fwZoffset + cageWallThick]) frontWindow();
        // bottom holes
        translate([midHolesXoffset1, midHolesYoffset1, 0]) hole();
        translate([midHolesXoffset2, midHolesYoffset1, 0]) hole();
        translate([midHolesXoffset1, midHolesYoffset2, 0]) hole();
        translate([midHolesXoffset2, midHolesYoffset2, 0]) hole();
        // relief long sides
        translate([reliefXoffset, - reliefDepth, reliefZoffset]) reliefX();
        translate([reliefXoffset, d110Width + cageWallThick * 2 + reliefDepth, reliefZoffset]) reliefX();
        translate([d110Length + cageWallThick * 2 - reliefDepth, reliefYoffset, reliefZoffset]) reliefY();
        translate([-cageWallThick, 1.5, d110Depth + 0.5]) 
            rotate([0, 45, -90]) 
                cube([cageWallThick, d110Length + cageWallThick * 3, cageWallThick]);
        translate([- cageWallThick, d110Width + cageWallThick * 2 + 2 , d110Depth + 0.5]) 
            rotate([0, 45, -90]) 
                cube([cageWallThick, d110Length + cageWallThick * 3, cageWallThick]);
        translate([d110Length + cageWallThick * 2, d110Width + cageWallThick * 2  , d110Depth]) 
            rotate([0, 45, 180]) 
                cube([cageWallThick, d110Width + cageWallThick * 3, cageWallThick]);
    }
    
}

module d110() {
    color("gray") //cube([d110Length, d110Width, d110Depth]);
    hull () {
    // bottom
        translate([0, 0, 0]) cube([1, 1, 1]);
        translate([d110Length - 1, 0, 0]) cube([1, 1, 1]);
        translate([0, d110Width - 1, 0]) cube([1, 1, 1]);
        translate([d110Length - 1, d110Width - 1, 0]) cube([1, 1, 1]);
        // top
        translate([0, 0, d110Depth - 1]) cube([1, 1, 1]);
        translate([d110Length - 1, 0, d110FrontDepth - 1]) cube([1, 1, 1]);
        translate([0, d110Width - 1, d110Depth - 1]) cube([1, 1, 1]);
        translate([d110Length - 1, d110Width - 1, d110FrontDepth - 1]) cube([1, 1, 1]);
    }
}

//translate([0, cageWallThick, cageWallThick]) d110();

translate([0, 0, 0]) cage();