// highTwoWheels 5

$fn = 36;

basePlateWidth = 20;
basePlateLength = 30;
basePlateThick = 3;

standPlateWidth = 12.5;
standPlateHeight = 11;
standPlateThick = 4;

standPlateOffset = 25; // - standPlateWidth/2;

hAxisDiam = 5.0;
hAxisLength = 10;
vAxisDiam = 5.1;
vAxisLength = 5;

bearingDiam = 16;
bearingWidth = 5;
bearingAxis = 5;
bearingWasherDiam = 7.5;
bearingWasherHeight = 0.2;

plateHole      = 3.5;
holeEdgeDistance = 3.5;
holeOvalOffset = 1;

module ovalHole() {
    translate([-holeOvalOffset/2, 0, - 0.1])
        cylinder(d = plateHole, h = basePlateThick + 0.2);
    translate([holeOvalOffset/2, 0, - 0.1])
        cylinder(d = plateHole, h = basePlateThick + 0.2);    
}

module basePlate() {
    // axis
    translate([vAxisDiam/2, standPlateOffset, basePlateThick]) 
        cylinder(h=vAxisLength, d=vAxisDiam);
    // washer
    difference() {
        translate([vAxisDiam/2, standPlateOffset, basePlateThick]) 
            cylinder(h = bearingWasherHeight, d = bearingWasherDiam);
        translate([-bearingWasherDiam + bearingAxis, standPlateOffset - bearingWasherDiam/2, 0]) 
            cube([bearingWasherDiam - bearingAxis, bearingWasherDiam, basePlateThick * 2]);
    }
    difference() {    
      translate([0,0,0])
        cube([basePlateWidth, basePlateLength, basePlateThick]);
//      translate([holeEdgeDistance, holeEdgeDistance, 0]) ovalHole(); 
      translate([basePlateWidth - holeEdgeDistance, holeEdgeDistance, 0]) ovalHole(); 
//      translate([holeEdgeDistance, basePlateLength - holeEdgeDistance, 0]) ovalHole();
      translate([basePlateWidth - holeEdgeDistance, basePlateLength - holeEdgeDistance, 0]) ovalHole();
      // bearing cutout  
//      translate([basePlateWidth - standPlateThick *2, basePlateLength / 4, basePlateThick])
//        translate([standPlateThick,standPlateWidth/2, standPlateHeight - hAxisDiam]) 
      translate([-0.2, standPlateWidth / 2, basePlateThick + standPlateHeight - hAxisDiam])  
          rotate([0, 90, 0]) 
            cylinder(h = bearingWidth + bearingWasherHeight + 0.2, d = bearingDiam + 1); 
    }
}

module standPlate() {
//    translate([basePlateWidth - standPlateThick *2, basePlateLength / 2 - standPlateWidth / 2, basePlateThick]) {
    translate([0, 0, 0]) {
        cube([standPlateThick, standPlateWidth, standPlateHeight]);
        // washer
        translate([0, standPlateWidth / 2, standPlateHeight - hAxisDiam]) 
            rotate([0, -90, 0])
                cylinder(h = bearingWasherHeight, d = bearingWasherDiam);
    }
}

module hAxis() {
    rotate([0, -90, 0]) {
        translate([0, 0, 0]) {    
            cylinder(h = hAxisLength, d = hAxisDiam);
       }
   }
}

module bearing() {
    difference() {
        color("red") cylinder(h = bearingWidth, d = bearingDiam);
        translate([0.1, 0, 0]) cylinder(h = bearingWidth + 0.2, d = bearingAxis);
    }
}

basePlate();
translate([bearingWidth + bearingWasherHeight, 0, basePlateThick]) {
    difference() {
        standPlate();
        translate([hAxisLength / 2 - 0.3, standPlateWidth / 2, standPlateHeight - hAxisDiam]) hAxis();
    }
} 
//color("green") translate([bearingWidth + bearingWasherHeight + hAxisLength / 2 - 0.3, standPlateWidth / 2, standPlateHeight - hAxisDiam + basePlateThick]) hAxis();

/*
// bearing h
translate([vAxisDiam/2, standPlateOffset, basePlateThick + bearingWasherHeight])
    rotate([0, 0, 0])
        bearing();

//bearing v
translate([0, 0, basePlateThick])
  translate([0, standPlateWidth/2, standPlateHeight - hAxisDiam])
    rotate([0, 90, 0])
        bearing();
*/