// BackWheelPlate 2

$fn = 36;
// all in mm
backPlateLength = 25.0;
backPlateHeight = 45.0;
backPlateThick  = 5.0;
bottomExtensionLength = backPlateLength;
bottomExtensionHeight = 5.0;
bottomExtensionThick = backPlateThick;

axisDiameter = 5.5;

axisHLocation = 12.5;
axisVLocationLow = 15.0;
axisVLocationHigh = 15.0 + 17.5;

connectPlateLength = 10.0;
connectPlateHeight = 45.0;
connectPlateThick  = 2.5;

connectHoleDiam = 3.0;
connectHoleLength = connectPlateThick + 0.2;
connectHoleVDist = 10.0;

module backWheelPlate() {
    difference() {
        translate([]) 
            cube([backPlateLength, backPlateHeight, backPlateThick]);
        translate([axisHLocation, axisVLocationLow, -0.1])
            cylinder(h = backPlateThick + 0.2, d = axisDiameter);
        translate([axisHLocation, axisVLocationHigh, -0.1])
            cylinder(h = backPlateThick + 0.2, d = axisDiameter);
    }
    translate([0, -bottomExtensionHeight, 0])
        cube([bottomExtensionLength, bottomExtensionHeight, bottomExtensionThick]);
}

module connectPlate() {
    difference() {
        translate([-connectPlateLength, 0, 0])
            cube([connectPlateLength, connectPlateHeight, connectPlateThick]);
        translate([-connectPlateLength / 2, connectHoleVDist, -0.1])
            cylinder(h = connectHoleLength, d = connectHoleDiam);
         translate([-connectPlateLength / 2, connectPlateHeight /2, -0.1])
            cylinder(h = connectHoleLength, d = connectHoleDiam);
         translate([-connectPlateLength / 2, connectPlateHeight - connectHoleVDist, -0.1])
            cylinder(h = connectHoleLength, d = connectHoleDiam);
   }
}

backWheelPlate();
connectPlate();