// weightBottom3

$fn = 72;

bigCylinderDiam = 38.2 + 0.2;
smallCylinderDiam = 25.0 + 0.2;
smallCylinderOffset = 25.5;

plateHeight = 4.0;
plateMargin = 2.0;
plateWidth = bigCylinderDiam * 2 + plateMargin;
plateDepth = 60.0 + plateMargin;
plateHoleConeBottom = 9.2;
plateHoleConeTop= 5.0;
plateHoleConeHeight = 2.5;

difference() {
    union() {
        translate([0, 0              , 0]) 
            cylinder(d = bigCylinderDiam + plateMargin, h = plateHeight);
        translate([0, bigCylinderDiam, 0]) 
            cylinder(d = bigCylinderDiam + plateMargin, h = plateHeight);
        translate([smallCylinderOffset, bigCylinderDiam / 2, 0]) 
            cylinder(d = smallCylinderDiam + plateMargin, h = plateHeight);
    }
    translate([0, 0, plateHeight / 2]) {
        translate([0, 0              , 0]) 
            cylinder(d = bigCylinderDiam, h = plateHeight);
        translate([0, bigCylinderDiam, 0]) 
            cylinder(d = bigCylinderDiam, h = plateHeight);
        translate([smallCylinderOffset, bigCylinderDiam / 2, 0]) 
            cylinder(d = smallCylinderDiam, h = plateHeight);
    }
    // weight holes
    translate([0, 0              , -0.1]) 
        cylinder(d1 = plateHoleConeBottom, d2 = plateHoleConeTop, h = plateHoleConeHeight + 0.2);
    translate([0, bigCylinderDiam, -0.1])
        cylinder(d1 = plateHoleConeBottom, d2 = plateHoleConeTop, h = plateHoleConeHeight + 0.2);
    translate([smallCylinderOffset, bigCylinderDiam / 2, -0.1]) 
        cylinder(d1 = plateHoleConeBottom, d2 = plateHoleConeTop, h = plateHoleConeHeight + 0.2);
    
    // attachPointHole
    translate([10.2, bigCylinderDiam / 2              , -0.1]) 
        color("red") cylinder(d = plateHoleConeTop, h = plateHeight + 0.2);
}