// targetPlateBlock2

$fn = 16;

targetPlateSize  = 80;
targetPlateThick = 2;
targetPinSize    = 3;
targetPinLength  = 6;

blockWidth  = 6.0;
blockLength = 42.0;
blockHeight  = 20.0;

clampScrewHoleXOffset = -blockWidth / 2;
clampScrewHoleYOffset = 3.5;
clampScrewHoleZ1Offset = 5.0;
clampScrewHoleZ2Offset = 15.0;
clampScrewHoleDiameter = 3.2;

clampToBlockHoleYOffset = clampScrewHoleYOffset + 30.0;
clampToBlockHoleDiameter = 2.5;


 
// target plate
translate([-targetPlateSize / 2, 0, 0]) 
    color("white") 
        cube([targetPlateSize, targetPlateSize, targetPlateThick]);
difference() {
    // back block
    color("white") 
        translate([-blockWidth / 2, 0, targetPlateThick]) 
            cube([blockWidth, blockLength, blockHeight]);
    
    // clampingScrewHoles
    color("red") translate([clampScrewHoleXOffset - 0.1, clampScrewHoleYOffset, targetPlateThick + clampScrewHoleZ1Offset])
        rotate([0, 90, 0]) cylinder(h = blockWidth + 0.2, d = clampScrewHoleDiameter);
    color("red") translate([clampScrewHoleXOffset - 0.1, clampScrewHoleYOffset, targetPlateThick + clampScrewHoleZ2Offset])
        rotate([0, 90, 0]) cylinder(h = blockWidth + 0.2, d = clampScrewHoleDiameter);
    
    // clampToBlock screws
    color("green") translate([clampScrewHoleXOffset - 0.1, clampToBlockHoleYOffset, targetPlateThick + clampScrewHoleZ1Offset])
        rotate([0, 90, 0]) cylinder(h = blockWidth + 0.2, d = clampToBlockHoleDiameter);
    color("green") translate([clampScrewHoleXOffset - 0.1, clampToBlockHoleYOffset, targetPlateThick + clampScrewHoleZ2Offset])
        rotate([0, 90, 0]) cylinder(h = blockWidth + 0.2, d = clampToBlockHoleDiameter);
}
