// riserRailPulleyPlate 3

$fn = 32;

profileThick = 3.0;

holeBlockWidth = 30;
holeBlockHeight = 22;
holeBlockThick = 5;

holeDiameter = 2.5;
holeLength = 5.2;
holeXPos = holeBlockWidth / 3; // + plateThick;
holeYPos1 = holeBlockHeight - 2.0;
holeYPos2 = holeBlockHeight - 11;
holeZPos = holeBlockWidth / 2; // + plateThick;

pulleyAxisDiameter = 6.0;
pulleyAxisXPos = holeBlockWidth - 6;
pulleyAxisYPos = 6.0;

bottomExtensionXPos = holeBlockWidth / 3 + 6.0;
bottomExtensionHeight = 3;
bottomExtensionLength = holeBlockWidth - bottomExtensionXPos;

module hole() {
        cylinder(h = holeLength, d = holeDiameter);
}


translate([0, 0, 0]) {
    difference() {
        union() {
          // main block
          cube([holeBlockWidth, holeBlockHeight, holeBlockThick]);
          // external extra thickness
          translate([bottomExtensionXPos, 0, holeBlockThick])
              cube([bottomExtensionLength, holeBlockHeight + profileThick, profileThick]);
        }
    translate([holeXPos, holeYPos1, -0.1]) {
        hole();
    }
    translate([holeXPos, holeYPos2, -0.1]) {
        hole();
    }
    translate([pulleyAxisXPos, pulleyAxisYPos, -0.1]) {
        cylinder(h = holeLength * 2, d = pulleyAxisDiameter);
    }
    
    }
}

translate([bottomExtensionXPos, holeBlockHeight, 0]) {
    cube([bottomExtensionLength, profileThick, holeBlockThick]);
}



module pulley() {
    translate([pulleyAxisXPos, pulleyAxisYPos, - 12])
    color("red") cylinder(h = 12, d = 20);
}

//pulley();