// laserTrolley 3

$fn = 64;

profileInnerWidth = 44;

ballBearingLength = 24.5;
ballBearingOutDiameter = 15;
ballBearingInDiameter = 8;
basePlateWidth  = 42;
basePlateLength = 120;
basePlateThick  = 4;

wheelLength = 4;
wheelOutDiameter = 10;
wheelInDiameter = 3;
wheelInDiameterThreadDiam = 2.5;
wheelWasherHeight = 0.3;
wheelWasherDiam = 5;

vWheelYOffset = 12;
vWheelXOffset = 1;
vWheelZOffset = 1;
reverseVWheelYOffset = basePlateLength - vWheelYOffset;
hWheelYOffset = 30;
reverseHWheelYOffset = basePlateLength - hWheelYOffset;
hWheelXOffset = wheelOutDiameter / 2 - (profileInnerWidth - basePlateWidth) / 2;
reverseHWheelXOffset = basePlateWidth - hWheelXOffset;

ballBearingSink = 3.2;

mountingHoleDiam = 3.3;
mountingHoleXEdgeDist = 10;
mountingHoleYEdgeDist = 5;

tieWrapHoleDiam = 2.5;
tieWrapHoleXOffset = 8.0;
tieWrapHoleYOffset = 10;

//profileInnerDepth = 27; // 30 - 3
profileInnerDepth = 22; // 25 - 3
widthAdjust = -0.97;


carriageStandWidth  = 10;
carriageStandLength = 15;
carriageStandHeight = profileInnerDepth - wheelOutDiameter - 5;  // 12;
carriageStandYOffset = 12;

carriageWheelSupportWidth = 4;
carriageWheelSupportHeight = 16;
carriageWheelSupportLength = 12;
carriageWheelSupportXOffset = 1 + wheelWasherHeight;
carriageWheelSupportAxisYOffset = 10;
carriageWheelSupportYOffset = (carriageStandLength - carriageWheelSupportLength) / 2;

module wheel() {
    difference() {
        cylinder(h = wheelLength, d = wheelOutDiameter);
        translate([0, 0, -0.1])
            cylinder(h = wheelLength + 0.2, d = wheelInDiameter);
    }
}

module basePlate() {
    difference() {
        union() {
        // basePlatePlate
        cube([basePlateWidth, basePlateLength, basePlateThick]);
            // horizontal wheel washer 1
        translate([hWheelXOffset, hWheelYOffset, basePlateThick])
            cylinder(h = wheelWasherHeight, d = wheelWasherDiam);
            // horizontal wheel washer 2
        translate([hWheelXOffset, reverseHWheelYOffset, basePlateThick])
            cylinder(h = wheelWasherHeight, d = wheelWasherDiam);
            
           // horizontal wheel washer 3 
        translate([reverseHWheelXOffset, hWheelYOffset, basePlateThick])
            cylinder(h = wheelWasherHeight, d = wheelWasherDiam);
           // horizontal wheel washer 4 
        translate([reverseHWheelXOffset, reverseHWheelYOffset, basePlateThick])
            cylinder(h = wheelWasherHeight, d = wheelWasherDiam);
        
        }
        // top wheel cutout 1
        translate([-0.1, vWheelYOffset, -0.1]) 
            cube([wheelLength * 3, wheelOutDiameter + 2, basePlateThick + 0.2]);
        // top wheel cutout 2
        translate([-0.1, reverseVWheelYOffset - wheelOutDiameter - 2, -0.1]) 
            cube([wheelLength * 3, wheelOutDiameter + 2, basePlateThick + 0.2]);
        // top wheel cutout 3
        translate([basePlateWidth - wheelLength * 3 + 0.1, vWheelYOffset, -0.1]) 
            cube([wheelLength * 3, wheelOutDiameter + 2, basePlateThick + 0.2]);
        // top wheel cutout 4
        translate([basePlateWidth - wheelLength * 3 + 0.1, reverseVWheelYOffset - wheelOutDiameter - 2, -0.1]) 
            cube([wheelLength * 3, wheelOutDiameter + 2, basePlateThick + 0.2]);
        
         // horizontal wheel axis tread hole1
        translate([hWheelXOffset, hWheelYOffset, -0.1])
        cylinder(h = wheelLength + wheelWasherHeight + 0.2, d = wheelInDiameterThreadDiam);
         // horizontal wheel axis tread hole2
        translate([hWheelXOffset, reverseHWheelYOffset, -0.1])
        cylinder(h = wheelLength + wheelWasherHeight + 0.2, d = wheelInDiameterThreadDiam);
        
        // horizontal wheel axis tread hole3
        translate([reverseHWheelXOffset, hWheelYOffset, -0.1])
        cylinder(h = wheelLength + wheelWasherHeight + 0.2, d = wheelInDiameterThreadDiam);
          // horizontal wheel axis tread hole4
        translate([reverseHWheelXOffset, reverseHWheelYOffset, -0.1])
        cylinder(h = wheelLength + wheelWasherHeight + 0.2, d = wheelInDiameterThreadDiam);
      
        // mounting hole 1
        translate([mountingHoleXEdgeDist, mountingHoleYEdgeDist, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
        // mounting hole 2
        translate([basePlateWidth - mountingHoleXEdgeDist, mountingHoleYEdgeDist, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
         // mounting hole 3
        translate([mountingHoleXEdgeDist, basePlateLength - mountingHoleYEdgeDist, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
        // mounting hole 4
        translate([basePlateWidth - mountingHoleXEdgeDist, basePlateLength - mountingHoleYEdgeDist, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);

       // mounting hole 5
        translate([mountingHoleXEdgeDist, basePlateLength / 3, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
       // mounting hole 6
        translate([basePlateWidth - mountingHoleXEdgeDist, basePlateLength / 3, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
       // mounting hole 7
        translate([mountingHoleXEdgeDist, basePlateLength / 3 * 2, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
       // mounting hole 8
        translate([basePlateWidth - mountingHoleXEdgeDist, basePlateLength / 3 * 2, -0.1]) 
            cylinder(h = basePlateThick + 0.2, d = mountingHoleDiam);
       
        } 
    // sizer - horizontal wheel distance, it has to fit in the profile
//    translate([-1, hWheelYOffset, basePlateThick])
//        color("green") cube([profileInnerWidth, wheelInDiameter, wheelInDiameter]);
}

module bottomWheelCarriage() {
    difference() {
        union() {
      carriageWheelSupportXPos12 =  wheelLength + carriageWheelSupportXOffset; 
    // carriage wheelSupport - support 1
      translate([carriageWheelSupportXPos12, vWheelYOffset, 0]) 
        cube([carriageWheelSupportWidth, carriageWheelSupportLength, carriageWheelSupportHeight + basePlateThick]);
            // support 2
      translate([carriageWheelSupportXPos12, reverseVWheelYOffset - carriageWheelSupportLength, 0]) 
        cube([carriageWheelSupportWidth, carriageWheelSupportLength, carriageWheelSupportHeight + basePlateThick]);
            
    carriageWheelSupportXPos34 = basePlateWidth - carriageWheelSupportXPos12;
    // carriage wheelSupport - support 3
      translate([carriageWheelSupportXPos34 - carriageWheelSupportWidth, vWheelYOffset, 0]) 
        cube([carriageWheelSupportWidth, carriageWheelSupportLength, carriageWheelSupportHeight + basePlateThick]);
            // support 4
      translate([carriageWheelSupportXPos34 - carriageWheelSupportWidth, reverseVWheelYOffset - carriageWheelSupportLength, 0]) 
        cube([carriageWheelSupportWidth, carriageWheelSupportLength, carriageWheelSupportHeight + basePlateThick]);

        // washer 1
      translate([vWheelXOffset + wheelLength, vWheelYOffset + wheelOutDiameter / 2 + 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
    // top wheel 1 washer
      translate([vWheelXOffset + wheelLength, vWheelYOffset + wheelOutDiameter / 2 + 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
        // washer 2
      translate([vWheelXOffset + wheelLength, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
    // top wheel 2 washer
      translate([vWheelXOffset + wheelLength, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
    // washer 3
      translate([basePlateWidth - vWheelXOffset - wheelLength - wheelWasherHeight, vWheelYOffset + wheelOutDiameter / 2 + 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);    
    // top wheel 3 washer
      translate([basePlateWidth - vWheelXOffset - wheelLength - wheelWasherHeight, vWheelYOffset + wheelOutDiameter / 2 + 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
        // washer 4
      translate([basePlateWidth - vWheelXOffset - wheelLength - wheelWasherHeight, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);
     // top wheel 4 washer
      translate([basePlateWidth - vWheelXOffset - wheelLength - wheelWasherHeight, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelWasherDiam, h = wheelWasherHeight);    
        }
      // bottom wheel axis hole 1
      translate([vWheelXOffset, vWheelYOffset + wheelOutDiameter / 2 + 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelInDiameterThreadDiam, h = basePlateWidth + 0.2);
      // top wheel axis hole 1
      translate([vWheelXOffset, vWheelYOffset + wheelOutDiameter / 2 + 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelInDiameterThreadDiam, h = basePlateWidth + 0.2);
      // bottom wheel axis hole 2
      translate([vWheelXOffset, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelInDiameterThreadDiam, h = basePlateWidth + 0.2);
      // top wheel axis hole 2
      translate([vWheelXOffset, reverseVWheelYOffset - wheelOutDiameter / 2 - 1, wheelOutDiameter / 2 - 1]) 
        rotate([0, 90, 0]) 
            cylinder(d = wheelInDiameterThreadDiam, h = basePlateWidth + 0.2);
     }
    
    
}


translate([vWheelXOffset, 0, vWheelZOffset]) {
    basePlate();
    bottomWheelCarriage();
}
    // depth spacer
//    translate([wheelLength, vWheelYOffset + wheelOutDiameter / 2, 0]) 
  //      color("green") cube([wheelInDiameter, wheelInDiameter, profileInnerDepth]);


module nonPrintingWheels() {
  color("red") {
      // side wheel 1
    translate([hWheelXOffset, hWheelYOffset, basePlateThick + wheelWasherHeight])
        wheel();
      // side wheel 2
    translate([hWheelXOffset, reverseHWheelYOffset, basePlateThick + wheelWasherHeight])
        wheel();
      // side wheel 3
    translate([reverseHWheelXOffset, hWheelYOffset, basePlateThick + wheelWasherHeight])
        wheel(); 
      // side wheel 4
    translate([reverseHWheelXOffset, reverseHWheelYOffset, basePlateThick + wheelWasherHeight])
        wheel(); 
      // bottom wheel 1
    translate([vWheelXOffset, vWheelYOffset + wheelOutDiameter / 2 + 1, profileInnerDepth - wheelOutDiameter / 2 - vWheelZOffset])
      rotate([0, 90, 0]) wheel();
/*      // bottom wheel 2
    translate([carriageWheelSupportXOffset - wheelWasherHeight, basePlateLength - ballBearingLength/2 -10, profileInnerDepth - wheelOutDiameter / 2])
      rotate([0, 90, 0]) wheel();
      
      // bottom wheel 3
    translate([basePlateWidth - wheelLength - carriageWheelSupportXOffset + wheelWasherHeight, ballBearingLength / 2 + 10, profileInnerDepth - wheelOutDiameter / 2])
      rotate([0, 90, 0]) wheel();
      // bottom wheel 4
    translate([basePlateWidth - wheelLength - carriageWheelSupportXOffset + wheelWasherHeight, basePlateLength - ballBearingLength/2 -10, profileInnerDepth - wheelOutDiameter / 2])
      rotate([0, 90, 0]) wheel(); */
    
      // top wheel 1
      translate([vWheelXOffset, vWheelYOffset + wheelOutDiameter / 2 + 1, wheelOutDiameter / 2 - 1])
          rotate([0, 90, 0]) wheel();
  }
}
//translate([vWheelXOffset, 0, vWheelZOffset]) nonPrintingWheels();

mainProfileWidth  = 50;
mainProfileHeigth = 25;
mainProfileLength = 120;
mainProfileThickness = 3;


module mainProfile() {
    translate([0, 0, mainProfileHeigth])
        cube([mainProfileWidth, mainProfileLength, mainProfileThickness]);
    translate([0, 0, mainProfileThickness])
        cube([mainProfileThickness, mainProfileLength, mainProfileHeigth]);
    translate([mainProfileWidth - mainProfileThickness, 0, mainProfileThickness])
        cube([mainProfileThickness, mainProfileLength, mainProfileHeigth]);
}

topProfileWidth = 10;
topProfileLength = 120;
topProfileThickness = 2;

module topProfile() {
    cube([topProfileWidth, topProfileLength, topProfileThickness]);
    cube([topProfileThickness, topProfileLength,topProfileWidth]);
}

//translate([-mainProfileThickness, 0, - mainProfileThickness]) color("gray") mainProfile();

//translate([-mainProfileThickness - topProfileThickness, 0, - topProfileThickness]) color("white") topProfile();