// brakelineHolder 3

$fn = 32;

lineDiam = 3.5;
cutoutWidth = 2.5;

cupDiam = 6.0;

holderDiam = 10.0;
holderHeight = 5.0;

backPlateLength = 25.0;
backPlateHeight = 3.0;

backplateHoleDiam = 3.2;
roundingRadius = 0.5;

module flatHeadM3(length = 10.0) {
    headMaxDiam = 5.7;
    headMinDiam = 3.2;
    headHight = 2.0;
    
    cylinder(d1 = headMaxDiam, d2 = headMinDiam, h = headHight);
    cylinder(d = headMinDiam, h = length);
    translate([0, 0, -9.9]) cylinder(d = headMaxDiam, h = length);
}

module breakLineCatch() {
//    difference() {
//        translate([0, 0, 0]) cylinder(d = holderDiam, h = holderHeight);
        translate([0, 0, 5-10]) color("blue") cylinder(d = lineDiam, h = holderHeight + 10.0);
        translate([0, 0, holderHeight]) sphere(d = cupDiam);
        translate([0, -cutoutWidth / 2, -2.1]) cube([holderHeight, cutoutWidth, holderHeight + 3]);
        translate([0, 0, 5]) color("red") cylinder(d = cupDiam, h = 10.0);
//    }
}

module baseBackPlate() {
//    cube([backPlateHeight, backPlateLength, holderHeight * 2]);
    hull() {
        // lower set Y
        translate([roundingRadius, roundingRadius, roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([backPlateHeight - roundingRadius, roundingRadius, roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([roundingRadius, roundingRadius, holderHeight * 2 - roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([backPlateHeight - roundingRadius, roundingRadius, holderHeight * 2 - roundingRadius]) 
            sphere(d = roundingRadius * 2);
        // upper set Y
        translate([roundingRadius, backPlateLength - roundingRadius, roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([backPlateHeight - roundingRadius, backPlateLength - roundingRadius, roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([roundingRadius, backPlateLength - roundingRadius, holderHeight * 2 - roundingRadius]) 
            sphere(d = roundingRadius * 2);
        translate([backPlateHeight - roundingRadius, backPlateLength - roundingRadius, holderHeight * 2 - roundingRadius]) 
            sphere(d = roundingRadius * 2);
        //
        translate([holderDiam + 0.5, backPlateLength / 2 + 3, holderHeight * 0.5 - roundingRadius ]) sphere(d = roundingRadius * 2);
        translate([holderDiam + 0.5, backPlateLength / 2 + 3, holderHeight * 1.5 - roundingRadius]) sphere(d = roundingRadius * 2);
        translate([holderDiam + 0.5, backPlateLength / 2 - 3, holderHeight * 0.5 - roundingRadius ]) sphere(d = roundingRadius * 2);
        translate([holderDiam + 0.5, backPlateLength / 2 - 3, holderHeight * 1.5 - roundingRadius]) sphere(d = roundingRadius * 2);
    }
}

module backPlate() {
    translate([-backPlateHeight * 2, -backPlateLength / 2, 0]) {
        difference() {
            baseBackPlate();
            
            translate([backPlateHeight+0.1, backPlateLength - backPlateHeight - 0.5, holderHeight * 1.1]) 
                rotate([0, -90, 0]) 
                    flatHeadM3();
        
            translate([backPlateHeight+0.1, backPlateHeight + 0.5 , holderHeight * 1.1]) 
                rotate([0, -90, 0]) 
                    flatHeadM3();
        }
    }
}


rotate([0, -90, 0]) {
    difference() {
        backPlate();
        translate([0, 0, holderHeight/2]) breakLineCatch();
    }

}
//baseBackPlate();


//flatHeadM3();

