// axisClip 3

$fn = 36;

axiaDiam = 5.0;

clipHeight = 3.0;
clipThick  = 3.0;
axisStretchMargin = 0.3;
clipTwist = 0;
clipCutStartAngle = 0;
clipCutEndAngle = 30;

clipEarLength = 3.0;

//http://forum.openscad.org/Creating-pie-pizza-slice-shape-need-a-dynamic-length-array-td3148.html
module point(x,y) translate([x,y]) circle(0.01);

module pie_slice(r, a0, a1) {
    $fa = 5;
    R = r * sqrt(2) + 1;
    intersection() {
        circle(r);
        hull() {
            point(0,0);
            for (i = [0:4])
//                assign(a = ((4 - i) * a0 + i * a1) / 4)
                for (a = ((4 - i) * a0 + i * a1) / 4)
                     point(R * cos(a), R * sin(a));
       }
    }
}

//pie_slice(axiaDiam + clipThick + 0.1, 0, 30);

module clipEar() {
    cube([clipEarLength, clipThick / 2, clipHeight]);
}

difference() {
    translate([0,0,0])
        cylinder(h = clipHeight, d = axiaDiam + clipThick);
    translate([0, 0, -0.1])
        cylinder(h = clipHeight + 0.2, d = axiaDiam - axisStretchMargin);
    translate([0, 0, -0.1])
      linear_extrude(height = clipHeight + 0.2, center = false, convexity = 10, twist = clipTwist, slices = 20, scale = 1.0)
        pie_slice(axiaDiam + clipThick, clipCutStartAngle, clipCutEndAngle);
}

rotate([0, 0, -clipCutStartAngle])
    translate([axiaDiam / 2, -clipThick / 2, 0])
        clipEar();

rotate([0, 0, clipCutEndAngle])
    translate([axiaDiam / 2, 0, 0])
        clipEar();
