// bookscanLongSideStrip5_3.2mm

$fn = 32;

base = 40.0;
campher = 2.0;
thickness = 2.0;
baseYoffset = 18.0;
m4ThreadDiam = 3.3;

length = 373.0 / 2; //100.0 + baseYoffset * 2;
lengthHoleCount = 4;

plexThickness = 3.0;
plexWidth = 15.0;

pcPlateCorrection = 5.0;
angledBase = base - plexWidth; // + pcPlateCorrection;

plexBaseAngle = 20.0;

x0Height = angledBase * tan(plexBaseAngle);

module strip() {
    // trapezium part
    hull() {
        translate([campher, 0, 0]) 
            cube([base-campher*2, length, 0.01]);
        translate([0, 0, thickness])
            cube([base, length, 0.01]);
    }
    // cubic middle part
    trimOffset1 = lHoleOffset + lHoleDist * 0.5;
    trimOffset2 = lHoleOffset + lHoleDist * 2.5;
    translate([0, 0, thickness])
      difference() {
        cube([angledBase - pcPlateCorrection, length, plexThickness + 0.2]);
        translate([-0.01, trimOffset1, 1.6]) rotate([0, 90, 0]) 
          cylinder(d = m4ThreadDiam, h = 20.02);
        translate([-0.01, trimOffset2 , 1.6]) rotate([0, 90, 0]) 
          cylinder(d = m4ThreadDiam, h = 20.02);
      }
    // tree-sided part
    difference() {
        translate([0, 0, thickness + plexThickness]) {
            hull() {
                translate([0, 0, 0]) sphere(r = 0.01);
                translate([0, length, 0]) sphere(r = 0.01);
                translate([0, 0, x0Height]) {
                    translate([0, 0, 0]) sphere(r = 0.01);
                    translate([0, length, 0]) sphere(r = 0.01);
                }
                translate([angledBase, 0, 0]) {
                    translate([0, 0, 0]) sphere(r = 0.01);
                    translate([0, length, 0]) sphere(r = 0.01);        
                }
            }
        }
        translate([angledBase - pcPlateCorrection, -0.01, thickness]) cube([10, length + 0.02, 5]);
    }
}

screwHole = 3.5;
screwHead = 6.5;
topHole = 7.5;
topHoleHeight = 10.0;
screwHeadHeight = 2.5;
screwHoleHeight = 10.0;

lHoleDist = length / lengthHoleCount;
lHoleOffset = lHoleDist / 2;

difference() {
    strip();
    for (i = [0:1:lengthHoleCount]) {
        translate([10, lHoleOffset + lHoleDist * i, -5]) rotate([0, plexBaseAngle, 0]) hole();
        echo(lHoleOffset + lHoleDist * i);
    }

}
//    translate([10, -5.0, -5]) rotate([0, plexBaseAngle, 0]) hole();

module hole() {
    cylinder(d1 = topHole, d2 = screwHead, h = topHoleHeight);
    translate([0, 0, topHoleHeight]) 
        cylinder(d1 = screwHead, d2 = screwHole,h = screwHeadHeight);
    translate([0, 0, topHoleHeight + screwHeadHeight])
        cylinder(d = screwHole, h = screwHoleHeight);
}