// piHolder1

$fn = 32;

include <screwShapes1.scad>

baseWidth = 80.0;
baseLen = 115.0;
baseThick = 3.0;

sideHeight = 10.0;
sideAngle = 90 - 79.0;

mountScrewOffset = 10.0;

module base() { 
    difference() {
        cube([baseWidth, baseLen, baseThick]);
        translate([baseWidth / 2 - mountScrewOffset, baseLen / 2 - mountScrewOffset, -0.01]) screwHole(baseThick * 2);
        translate([baseWidth / 2 + mountScrewOffset, baseLen / 2 + mountScrewOffset, -0.01]) screwHole(baseThick * 2);
    }
}

module side1() {
    cube([baseThick, baseLen, sideHeight]);
}

module side2() {
    cube([baseThick, baseLen, baseThick]);
    translate([0, 0, sin(sideAngle) * baseThick]) rotate([0, sideAngle, 0]) cube([baseThick, baseLen, sideHeight]);
}

module screwHole(len) {
    translate([0, 0, baseThick+0.02]) rotate([180, 0, 0]) flatHeadM4(len);
}

side1();
translate([baseThick, 0, 0]) base();
translate([baseThick + baseWidth, 0, 0]) side2();