// hexHandle4

$fn = 64;

hexHeadDiam = 12.6;
hexHeadHeight = 4.0;
knobDiam = 32.0;
knobHeight = hexHeadHeight * 1.5;
cornerRad = 1.0;

difference() {
    knobOutside();
    translate([0, 0, hexHeadHeight / 2]) cylinder(d = hexHeadDiam, h = knobHeight, $fn = 6);
    translate([0, 0, -0.01]) cylinder(d = 6.4, h = hexHeadHeight);
}

module knobOutside() {
//    cylinder(d = knobDiam, h = knobHeight/2, $fn = 6);
    hull() {
        for (i = [0: 1: 6]) {
            rotate([0, 0, i * 60]) translate([knobDiam / 2 - cornerRad, 0, 0]) node();
        }
    }

    rotate([0, 0, 30]) hull() {
        for (i = [0: 1: 6]) {
            rotate([0, 0, i * 60]) translate([knobDiam / 2 - cornerRad, 0, 0]) node();
        }
    }
}

module node() {
    hull() {
        translate([0, 0, cornerRad]) sphere(r = cornerRad);
        translate([0, 0, knobHeight - cornerRad]) sphere(r = cornerRad);
    }
}