// bookscanShortSideStrip5

$fn = 32;

base = 20.0;
holeOffset = 2.0;
campher = 2.0;
thickness = 2.0;
baseYoffset = 18.0;
length = 240.0 + 15.0;
angle = 110.0;

screwHole = 3.5;
screwHead = 6.5;
screwHeadHeight = 2.5;
screwHoleCount = 5;
screwHoleDist = length / screwHoleCount;
screwHoleOffset = screwHoleDist / 2 + 8;

module stripSide() {
    hull() {
        translate([campher, 0, 0]) 
            cube([base-campher, length, 0.01]);
        translate([0, 0, thickness])
            cube([base, length, 0.01]);
    }
}

difference() {
    union() {
       stripSide();
       translate([base, length, base]) rotate([0, 90, 180])
           stripSide(); 
    }
    for (i = [0:1:screwHoleCount]) {
        translate([base / 2 - holeOffset, screwHoleOffset + i * screwHoleDist -0.01]) hole();
    }
    topCutoutCubeSize = base * 1.41;
    topCutoutAngle = -(180-angle)/2;
    rotate([0, 0, 180]) // get rotating axis at correct spot
      translate([-base, 0, -0.05]) 
    rotate([0, 0, topCutoutAngle]) // rotate the right amount & direction
        cube([topCutoutCubeSize, topCutoutCubeSize, base + 0.1]);
    translate([base + 1, 236.0 + 6.0, 0]) longStripCutout();
}

//translate([base, 0, 0]) color("red") cube([1, 235.0, 1]);

module hole() {
    cylinder(d1 = screwHead, d2 = screwHole, h = screwHeadHeight);
}

module longStripCutout() {
 //   #cube([thickness + 0.2, base, base]);
    rotate([0, 0, 135]) translate([0, -10, thickness]) cube([thickness * 8, thickness * 8, base]);
}