// bookscanLongSideStrip3_3mm

$fn = 32;

base = 40.0;
campher = 2.0;
thickness = 2.0;
baseYoffset = 18.0;


length = 373.0 / 2; //100.0 + baseYoffset * 2;
lengthHoleCount = 4;

plexThickness = 3.0;
plexWidth = 15.0;

angledBase = base - plexWidth;

plexBaseAngle = 20.0;

x0Height = angledBase * tan(plexBaseAngle);

module strip() {
    hull() {
        translate([campher, 0, 0]) 
            cube([base-campher*2, length, 0.01]);
        translate([0, 0, thickness])
            cube([base, length, 0.01]);
    }

    translate([0, 0, thickness])
        cube([angledBase, length, plexThickness]);

    translate([0, 0, thickness + plexThickness]) {
        hull() {
            translate([0, 0, 0]) sphere(r = 0.01);
            translate([0, length, 0]) sphere(r = 0.01);
            translate([0, 0, x0Height]) {
                translate([0, 0, 0]) sphere(r = 0.01);
                translate([0, length, 0]) sphere(r = 0.01);
            }
            translate([angledBase, 0, 0]) {
                translate([0, 0, 0]) sphere(r = 0.01);
                translate([0, length, 0]) sphere(r = 0.01);        
            }
        }
    }
}

screwHole = 3.5;
screwHead = 6.5;
topHole = 7.5;
topHoleHeight = 10.0;
screwHeadHeight = 2.5;
screwHoleHeight = 10.0;

lHoleDist = length / lengthHoleCount;
lHoleOffset = lHoleDist / 2;

difference() {
    strip();
    for (i = [0:1:lengthHoleCount]) {
        translate([10, lHoleOffset + lHoleDist * i, -5]) rotate([0, plexBaseAngle, 0]) hole();
    }

}
//    translate([10, -5.0, -5]) rotate([0, plexBaseAngle, 0]) hole();

module hole() {
    cylinder(d1 = topHole, d2 = screwHead, h = topHoleHeight);
    translate([0, 0, topHoleHeight]) 
        cylinder(d1 = screwHead, d2 = screwHole,h = screwHeadHeight);
    translate([0, 0, topHoleHeight + screwHeadHeight])
        cylinder(d = screwHole, h = screwHoleHeight);
}