//bookScanPlateSupport4

$fn = 32;

angle = 160.0;

base = 18.0;
height = 10.0;
length = 336.0 / 2;
rad = 0.1;

topOffset = -height * tan(angle);
holeCount = 3;
holeDist = length / holeCount; //50.0;
holeOffset = holeDist / 2;
holeHeight = 14.0;
screwHole = 3.5;
screwHead = 6.5;
topHole = 7.5;
topHoleHeight = 10.0;
screwHeadHeight = 2.5;
screwHoleHeight = 10.0;


module support() {
    hull() {
        translate([0, 0, 0]) sphere(d = rad); 
        translate([base, 0, 0]) sphere(d = rad);  
        translate([topOffset, 0, height]) sphere(d = rad); 
        translate([0, length, 0]) sphere(d = rad); 
        translate([base, length, 0]) sphere(d = rad);  
        translate([topOffset, length, height]) sphere(d = rad); 
    }
}

module hole() {
    cylinder(d1 = topHole, d2 = screwHead, h = topHoleHeight);
    translate([0, 0, topHoleHeight-0.01]) 
        cylinder(d1 = screwHead, d2 = screwHole,h = screwHeadHeight + 0.02);
    translate([0, 0, topHoleHeight + screwHeadHeight])
        cylinder(d = screwHole, h = screwHoleHeight);
}

difference() {
    support();
    for (i = [0:1:holeCount-1]) {
        translate([base/2, holeOffset + i * holeDist, holeHeight]) mirror([0, 0, 1]) hole();
    }
}

//color("blue") cube([8, 2, base]);
//color("red") cube([8, 2, height]);