// platenFrame 1

glassThick = 3.2;
glassWidth = 210.0;
frameWall = 1.5;
frameThick = frameWall * 2 + glassThick;

widthFactor = 0.66;

screwHole = 3.5;
earDiameter = screwHole + 2 * frameWall;
earOffset = frameThick / 2 + glassThick;


module frameRuler () {
    translate([-frameThick / 2, -frameThick / 2, 0]) 
        cube([frameThick, glassWidth * widthFactor, frameThick - frameWall]);
}

module glassPlate() {
    translate([-glassThick / 2, -glassThick / 2, 0]) cube([glassThick, glassWidth * widthFactor, frameThick]);
}

difference() {
    union() {
        frameRuler();
        rotate([0, 0, -90]) frameRuler();
    }
    translate([0, 0, frameWall]) glassPlate();
    translate([0, 0, frameWall]) rotate([0, 0, -90]) glassPlate();
}

module fasteningEar() {
    $fn = 16;
    difference() {
        union() {
            cylinder(h = frameWall, d = earDiameter);
            translate([-earDiameter / 2, -earDiameter / 2, 0]) cube([earDiameter, earDiameter / 2, frameWall]);
        }
        translate([0, 0, -0.01]) cylinder(h = frameWall + 0.02, d = screwHole);
    }
}

translate([35, earOffset, 0]) fasteningEar();
translate([100, earOffset, 0]) fasteningEar();

rotate([0, 0, 90]) mirror([0, 1, 0]) {
    translate([25, earOffset, 0])   fasteningEar();
    translate([100, earOffset, 0])  fasteningEar();
}