// cameraPad5x3x1.5_2


length = 50.0;
width  = 28.0;
thick  = 1.0;

$fn = 16;
holeDiam = 6.5;
holeXEdgeDist = 16.0;
holeYEdgeDist = 7.5;

ribDiam = 1.5;

difference() {
    union() {
        cube([length, width, thick]);
        for (interval = [ribDiam * 1.4 :ribDiam * 2:width]) {
            rotate([0, 90, 0]) translate([-thick, interval, 0]) rib();
        }
    }
    translate([holeXEdgeDist, holeYEdgeDist, -0.01]) 
        cylinder(d = holeDiam, h = thick * 2);
}


module rib() {
    rotate([0, 0, 30]) cylinder(d = ribDiam, h = length, $fn = 6);
}