package test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class JobSupplicant {
	
	private static List<String> workList;
	private static int workListIndex;
	private static List<Processor> processors;
	public static Object sync;
	
	public static void main(String[] args) {
		  System.out.println("starting...");
		  sync = new Object();
		  
		  Path jobsPath = Paths.get("./jobs.txt");
		  List<String> jobs = null;
		  int processorCount = 4;
		  
	  	  try {
			  jobs = Files.readAllLines(jobsPath);
		  } catch (IOException e) {
			  // TODO Auto-generated catch block
			  e.printStackTrace();
		  }
		  workList = new ArrayList<String>();
		  workListIndex = 0;
		  for (String job : jobs) {
			  log("adding '" + job + "'");
			  workList.add(job);
		  }
		  
		  for (int i = 0; i < processorCount; i++) {
			  Runnable procR = new Processor(i);
			  Thread procT = new Thread(procR);
			  procT.start();
//			  processors.add(new Processor(i));
		  }
		  
	}
	  
	public static String getJob() {
		synchronized (workList) {
			if (workListIndex < workList.size()) {
				String job = workList.get(workListIndex);
				workListIndex++;
				return job;
			} else {
				return "";
			}
		}
	}
  
  
    public static void log(String logstr) {
	    System.out.println(logstr);
    }
}
