/***************************************************
  Based on L3G4200D Tripple Axis Gyroscope + Arduino
  Wednesday, June 15 th , 2011 from Adam Meyer
  http://bildr.org/2011/06/l3g4200d-arduino/

  Which in part is based on code by Jim Lindblom
  SparkFun Electronics (https://www.sparkfun.com/products/10612)
  date: 4/18/11
  license: CC-SA 3.0 - Use this code however you'd like, all we ask
  for is attribution. And let us know if you've improved anything! 
 ****************************************************/
 
/**************************************************************************
 Modifications were only made for integration and reducing firmware 
 footprint
 F.J. Kraan, fjkraan@xs4all.nl. 2013-12-28
 **************************************************************************/
 
 #include <Arduino.h>
 
 #include "L3G4200D.h"
 #include "I2C.h"
 
 
xyzInts_t       gm;
xyzInts_t*      gyrometer = &gm;
xyzBytes_xSB_t  gud;
xyzBytes_xSB_t* gUnsortedData = &gud; 

bool L3G4200D_init(int scale) {
  /* Check connection */
  byte deviceid = L3G4200D_getDeviceID();
  if (deviceid != L3G4200D_ID)
  {
    /* No ADXL345 detected ... return false */
//    Serial.println(deviceid, HEX);
    return false;
  }
  setupL3G4200D(scale);
  return true;
}

byte L3G4200D_getDeviceID(void) {
  // Check device ID register
  return readRegister(L3G4200D_Address, L3G4200D_WHO_AM_I);
}

xyzInts_t* readGyroXYZ() {
    read6Register(L3G4200D_Address, L3G4200D_DATA_XLSB, gUnsortedData);
    // L3G4200D registers are big endian oriented
    gyrometer->x = gUnsortedData->x1 << 8 | gUnsortedData->x0;
    gyrometer->y = gUnsortedData->y1 << 8 | gUnsortedData->y0;
    gyrometer->z = gUnsortedData->z1 << 8 | gUnsortedData->z0;
    return gyrometer;
}

int getGyroTemp() {
   return readRegister(L3G4200D_Address, L3G4200D_OUT_TEMP);  
}

int setupL3G4200D(int scale){
  //From  Jim Lindblom of Sparkfun's code

  // Enable x, y, z and turn off power down:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG1, 0b00001111); // 0x0F

  // If you'd like to adjust/use the HPF, you can edit the line below to configure L3G4200D_CTRL_REG2:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG2, 0b00000000);

  // Configure L3G4200D_CTRL_REG3 to generate data ready interrupt on INT2
  // No interrupts used on INT1, if you'd like to configure INT1
  // or INT2 otherwise, consult the datasheet:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG3, 0b00001000); // 0x08

  // L3G4200D_CTRL_REG4 controls the full-scale range, among other things:

  if(scale == 250){
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00000000); // 0x00
  }else if(scale == 500){
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00010000); // 0x10
  }else{
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00110000); // 0x30
  }

  // L3G4200D_CTRL_REG5 controls high-pass filtering of outputs, use it
  // if you'd like:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG5, 0b00000000);
}
