
/**************************************************************************
 Generic I2C routines for various sensors. The code is mostly copied from 
 the standard examples from http://arduino.cc/en/Reference/Wire.

 F.J. Kraan, fjkraan@xs4all.nl. 2013-12-28
**************************************************************************/

#include <Arduino.h> 
#include <Wire.h>

#include "I2C.h"
 
void writeRegister(int deviceAddress, byte address, byte val) {
    Wire.beginTransmission(deviceAddress); // start transmission to device 
    Wire.write(address);       // send register address
    Wire.write(val);         // send value to write
    Wire.endTransmission();     // end transmission
}

void selectRegister(int deviceAddress, byte address) {
    Wire.beginTransmission(deviceAddress);
    Wire.write(address); // register to read
    Wire.endTransmission();  
}

int readRegister(int deviceAddress, byte address) {
    int v;
    selectRegister(deviceAddress, address);

    Wire.requestFrom(deviceAddress, 1); // read a byte

    while(!Wire.available()) {
        // waiting
    }

    v = Wire.read();
    return v;
}

int read2RegisterBE(int deviceAddress, byte address) {
    byte lsb, msb;
    selectRegister(deviceAddress, address | 0x80); // Don't forget the auto-increment bit

    Wire.requestFrom(deviceAddress, 2);
    while(!Wire.available()) {
      //waiting
    }
    lsb = Wire.read();
    msb = Wire.read();
    return (msb << 8 | lsb);
}

int read2RegisterLE(int deviceAddress, byte address) {
    byte lsb, msb;
    selectRegister(deviceAddress, address | 0x80); // Don't forget the auto-increment bit

    Wire.requestFrom(deviceAddress, 2);
    while(!Wire.available()) {
      //waiting
    }
    msb = Wire.read();
    lsb = Wire.read();
    return (msb << 8 | lsb);  
}

void read6Register(int deviceAddress, byte address, xyzBytes_xSB_t* xyzBUnsort){
    selectRegister(deviceAddress, address | 0x80); // Don't forget the auto-increment bit
    
    Wire.requestFrom(deviceAddress, 6);
    while(!Wire.available()) {
      //waiting
    }
    xyzBUnsort->x0 = Wire.read();
    xyzBUnsort->x1 = Wire.read();
    xyzBUnsort->y0 = Wire.read();
    xyzBUnsort->y1 = Wire.read();
    xyzBUnsort->z0 = Wire.read();
    xyzBUnsort->z1 = Wire.read();
}
