/****************************************************************************
    Based on:
    HMC5883Ldefs.h from the ArduIMU_Glove project
    Author: Seb Madgwick

    Definitions for Honeywell HMC5883L register addresses and values.


 Datasheet:
 http://dlnmh9ip6v2uc.cloudfront.net/datasheets/Sensors/Magneto/HMC5883L-FDS.pdf
 ****************************************************************************/

#ifndef HMC5883L_h
#define HMC5883L_h


#define HMC5883L_ADDRESS         0x1E               // 7-bit address of HMC5883 compass

// Registers
#define HMC5883L_CONFIG_REG_A    0x00    // data rate and measurement mode
#define HMC5883L_CONFIG_REG_B    0x01    // device gain
#define HMC5883L_MODE_REG        0x02    // operating mode
#define HMC5883L_DOUT_X_MSB      0x03
#define HMC5883L_DOUT_X_LSB      0x04
#define HMC5883L_DOUT_Y_MSB      0x05
#define HMC5883L_DOUT_Y_LSB      0x06
#define HMC5883L_DOUT_Z_MSB      0x07
#define HMC5883L_DOUT_Z_LSB      0x08
#define HMC5883L_STAT_REG        0x09    // lock and ready flags
#define HMC5883L_ID_REG_A        0x0A    // identification value A
#define HMC5883L_ID_REG_B        0x0B    // identification value B
#define HMC5883L_ID_REG_C        0x0C    // identification value C

// Constants
// CONFIG_REG_A
//   Measurement mode              xxxxxx11                
#define HMC5883L_MEAS_NORM       0b00000000  // CONFIG_REG_A
#define HMC5883L_MEAS_POS_BIAS   0b00000001
#define HMC5883L_MEAS_NEG_BIAS   0b00000010
//   Data output rate              xxx111xx
#define HMC5883L_RATE_0P75HZ     0b00000000
#define HMC5883L_RATE_1P5HZ      0b00000100
#define HMC5883L_RATE_3HZ        0b00001000
#define HMC5883L_RATE_7P5HZ      0b00001100
#define HMC5883L_RATE_15HZ       0b00010000    // default
#define HMC5883L_RATE_30HZ       0b00010100
#define HMC5883L_RATE_75HZ       0b00011000
//   Data averaging                x11xxxxx
#define HMC5883L_AVG_1           0b00000000
#define HMC5883L_AVG_2           0b00100000
#define HMC5883L_AVG_4           0b01000000
#define HMC5883L_AVG_8           0b01100000

// CONFIG_REG_B
//   Gain factor                   111xxxxx
#define HMC5883L_GAIN_0P88G      0b00000000  
#define HMC5883L_GAIN_1P3G       0b00100000    // default
#define HMC5883L_GAIN_1P9G       0b01000000
#define HMC5883L_GAIN_2P5G       0b01100000
#define HMC5883L_GAIN_4G         0b10000000
#define HMC5883L_GAIN_4P7G       0b10100000
#define HMC5883L_GAIN_5P6G       0b11000000
#define HMC5883L_GAIN_8P1G       0b11100000

// MODE_REG
//   Mode select bits              xxxxxx11
#define HMC5883L_MODE_CONT       0b00000000  // MODE_REG
#define HMC5883L_MODE_SINGLE     0b00000001
#define HMC5883L_MODE_IDLE       0b00000010
//   I2C mode                      1xxxxxxx
#define HMC5883L_I2C_STANDARD    0b00000000
#define HMC5883L_I2C_HIGH        0b10000000

// ID_REG_A, B, C
#define HMC5883L_ID_A            0b01001000
#define HMC5883L_ID_B            0b00110100
#define HMC5883L_ID_C            0b00110011

#include "generic.h"

long HMC5883L_getDeviceID(void);
bool HMC5883L_init(byte gain);
xyzInts_t* readMagnetoXYZ();
bool HMC5883L_ready();

#endif // HMC5883L
