#include "m_pd.h"

static t_class *pan_tilde_class;

typedef struct _pan_tilde {
  t_object  x_obj; /* the object itself */
  t_sample f_pan;  /* the balance variable */
  t_sample f;  /* dummy variable, used in pan_tilde_setup */
} t_pan_tilde;

static t_int *pan_tilde_perform(t_int *w)
{
  t_pan_tilde *x = (t_pan_tilde *)(w[1]); 
  t_sample  *in1 =    (t_sample *)(w[2]); /* left, first inlet */
  t_sample  *in2 =    (t_sample *)(w[3]); /* right, second inlet */
  t_sample  *out =    (t_sample *)(w[4]); /* outlet */
  int          n =           (int)(w[5]); 
  t_sample f_pan = (x->f_pan < 0) ? 0.0 : (x->f_pan > 1) ? 1.0 : x->f_pan;

  while (n--) *out++ = (*in1++) * (1 - f_pan) + (*in2++) * f_pan;

  return (w+6);
}

static void pan_tilde_dsp(t_pan_tilde *x, t_signal **sp)
{
  /* register the perform method, the number of following parameters,
     a pointer to the object struct, pointer to three vectors/arrays
     (one inlet, two outlets) and the size of the vectors/arrays */
  dsp_add(pan_tilde_perform, 5, x,
          sp[0]->s_vec, sp[1]->s_vec, sp[2]->s_vec,
	  sp[0]->s_n);
}

static void *pan_tilde_new(t_floatarg f)
{
  t_pan_tilde *x = (t_pan_tilde *)pd_new(pan_tilde_class);

  x->f_pan = f;
  
  /* add a second signal inlet (first is done in pan_tilde_setup) */
  inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);

  /* add a message inlet for floats */
  floatinlet_new (&x->x_obj, &x->f_pan);

  /* add a signal outlet */
  outlet_new(&x->x_obj, &s_signal);

  return (void *)x;
}

void pan_tilde_setup(void) {
  /* register a 'pan~' object with 'pan_tilde_new' as initialization method */
  pan_tilde_class = class_new(gensym("pan~"),
        		      (t_newmethod)pan_tilde_new,
       			      0,
			      sizeof(t_pan_tilde),
       			      CLASS_DEFAULT, 
       			      A_DEFFLOAT,
			      0);

  /* Declare this a signal object and register the 'pan_tilde_dsp' method
     for signal processing */
  class_addmethod(pan_tilde_class,
        (t_method)pan_tilde_dsp, gensym("dsp"), 0);

  /* Enable the first inlet as signal processing inlet. */
  CLASS_MAINSIGNALIN(pan_tilde_class, t_pan_tilde, f);
}

