#include "m_pd.h"

/* declare helloworld_class as a t_class type */
static t_class *helloworld_class;

/* this struct is the 'handle' the Pd core will have to the instance. The
   helloworld_new method initializes it with a pointer to this instance */
typedef struct _helloworld {
  t_object  x_obj;
} t_helloworld;

/* the 'payload' or behaviour of this object */
static void helloworld_bang(t_helloworld *x)
{
  post("Hello world !!");
}

/* the 'constructor' method which defines the t_helloworld struct for this 
   instance and returns it to the caller which is the Pd core */
static void *helloworld_new(void)
{
  t_helloworld *x = (t_helloworld *)pd_new(helloworld_class);

  return (void *)x;
}

/* This method is the only one the Pd core expects to be present */
void helloworld_setup(void) {
  /* this registers the 'helloworld' class. The 'helloworld_new' method will 
     be executed at each instantiation. */
  helloworld_class = class_new(gensym("helloworld"),
        		       (t_newmethod)helloworld_new,
        			0, 
				sizeof(t_helloworld),
        			CLASS_DEFAULT, 
				0);

  /* this registers the helloworld_bang method as action when a bang is received */
  class_addbang(helloworld_class, helloworld_bang);
}

