#include "m_pd.h"

static t_class *counterFloat_class;

/* Both start value and increment are now float variables */
typedef struct _counterFloat {
  t_object  x_obj;
  t_float   f_count;
  t_float   f_rate;
} t_counterFloat;

/* payload, executed on each bang */
static void counterFloat_bang(t_counterFloat *x)
{
  t_float f  =  x->f_count;
  x->f_count += x->f_rate;
  outlet_float(x->x_obj.ob_outlet, f);
}

/* initializing the object/instance */
static void *counterFloat_new(t_floatarg f, t_floatarg r)
{
  t_counterFloat *x = (t_counterFloat *)pd_new(counterFloat_class);

  x->f_count = f;
  x->f_rate  = r;
  outlet_new(&x->x_obj, &s_float);

  return (void *)x;
}

/* initializing the class */
void counterFloat_setup(void) {
  counterFloat_class = class_new(gensym("counterFloat"),
        (t_newmethod)counterFloat_new,
        0, sizeof(t_counterFloat),
        CLASS_DEFAULT,
        A_DEFFLOAT, /* count start value argument */
        A_DEFFLOAT, /* count rate argument */
        0);	    /* argument terminator */

  class_addbang(counterFloat_class, counterFloat_bang);
}

