// part of objectEventExample (portions are copied from other openframeworks examples

#include "testApp.h"

//--------------------------------------------------------------
void testApp::setup() {
    objectList = new vector<EventObject*>();

    EventObject* button1 = new EventRectangle(100, 200, 50, 50);
    button1->setName("Button1");
    button1->setColor(0x007F73);
    button1->setSelectedColor(0x209F93);
    objectList->push_back(button1);

    EventObject* button2 = new EventCircle(175, 275, 25);
    button2->setName("Button2");
    button2->setColor(0x407F43);
    button2->setSelectedColor(0x508F53);
    objectList->push_back(button2);
    
    int triX = 200;
    int triY = 350;
 //   EventObject* button3 = new EventTriangle(triX, triY, triX+50, triY, triX+25, triY-50);
    EventObject* button3 = new EventTriangle(triX, triY, 35, 0);
    button3->setName("Button3");
    button3->setColor(0x204F83);
    button3->setSelectedColor(0x406FA3);
    objectList->push_back(button3);
    
    EventObject* button4 = new EventRectangle(300, 200, 75, 75);
    button4->setName("Button4");
    button4->setColor(0x405F53);
    button4->setSelectedColor(0x607F73);
    objectList->push_back(button4);

    EventObject* button5 = new EventCircle(375, 275, 20);
    button5->setName("Button5");
    button5->setColor(0x907F33);
    button5->setSelectedColor(0xB08F53);
    objectList->push_back(button5);
    
    triX = 400;
    triY = 300;
    EventObject* button6 = new EventTriangle(triX, triY, 50, PI);
    button6->setName("Button6");
    button6->setColor(0x804F23);
    button6->setSelectedColor(0x606F43);
    objectList->push_back(button6);
    
    ofBackground(50,50,50);
    ofSetFrameRate(60);
    windowSize = ofGetWindowSize();
    margin = 10;
}

//--------------------------------------------------------------
void testApp::update() {
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {
        (*it)->update();
    }
}

//--------------------------------------------------------------
void testApp::draw() {
    // Iterates backwards to get the first on top
    for (vector<EventObject*>::reverse_iterator it = objectList->rbegin(); it != objectList->rend(); it++) {
        (*it)->draw();
    }
}

//--------------------------------------------------------------
void testApp::keyPressed(int _key) {
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {
        (*it)->keyPressed(_key);
    }
}

//--------------------------------------------------------------
void testApp::keyReleased(int _key) {
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {
        (*it)->keyReleased(_key);
    }
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ) {}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button) {
//    cout << "mousePressed " << button << endl;
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {

        if ((*it)->mousePressed(x, y, button)) {
            EventObject* eo = (*it);
            if (button == 0) {
                objectList->erase(it);
                objectList->insert(objectList->begin(), (eo));
            } else if (button == 2) {
                objectList->erase(it);
                objectList->insert(objectList->end(), (eo));
            }
            break;
        }
    }
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button) {
//    cout << "mouseDragged " << button << endl;
    // prevents objects from leaving the canvas
    if (x <= margin || x > windowSize.x - margin|| y <= margin || y > windowSize.y - margin) {
        return;
    }
    
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {
        if ((*it)->isSelected() == TRUE) (*it)->mouseDragged(x, y, button);
    }
}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button) {
//    cout << "mouseReleased " << button << endl;
    for (vector<EventObject*>::iterator it = objectList->begin(); it != objectList->end(); it++) {
        (*it)->mouseReleased(x, y, button);
    }
}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h) {}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo) {}
