/* 
 * File:   EventTriangle.h
 * Author: fjkraan
 *
 * Created on June 7, 2012, 8:42 PM
 * 
 * part of objectEventExample
 */

#ifndef EVENTTRIANGLE_H
#define	EVENTTRIANGLE_H

#include <iostream>
#include "ofMain.h"
#include "EventObject.h"

#define ROUNDING 1e-03
#define SQRT2 1.41421356237


class EventTriangle : virtual public EventObject {
    
private:
    float x;
    float y;
    float radius;
    float orientation;
    float normalRadius;
    float selectedRadius;
    float x1;
    float y1;
    float x2;
    float y2;
    float x3;
    float y3;
    float xHandle1;
    float yHandle1;
    float xHandle2;
    float yHandle2;
    float xHandle3;
    float yHandle3;
    bool inside(float _x, float _y);
    void recalculate();
    void reHandle(float _x, float _y);
    void setHandles(float _x, float _y);

public:
//    EventTriangle(float _x1, float _y1, float _x2, float _y2, float _x3, float _y3);
    EventTriangle(float _x, float _y, float _radius, float _orientation);
    ~EventTriangle();
    
   
    // mirrorred testApp methods
    void update();
    void draw();
    void keyPressed(int key);
    void keyReleased(int key);
    bool mousePressed(float x, float y, int button);
    void mouseDragged(float x, float y, int button);
    void mouseReleased(float x, float y, int button);   
};

#endif	/* EVENTTRIANGLE_H */

