// part of objectEventExample

#include "EventTriangle.h"

EventTriangle::EventTriangle(float _x, float _y, float _radius, float _orientation) {
    selected = FALSE;
    x = _x;
    y = _y;
    radius = _radius;
    normalRadius   = _radius;
    selectedRadius = _radius * SELECTEDFACTOR;
    orientation    = _orientation;
    recalculate();
}

EventTriangle::~EventTriangle() {}

void EventTriangle::update() {
}

void EventTriangle::draw() {
    EventObject::draw();
    ofTriangle(x1, y1, x2, y2, x3, y3);
}

void EventTriangle::keyPressed(int _key) {}

void EventTriangle::keyReleased(int _key) {}

bool EventTriangle::mousePressed(float xPressed, float yPressed, int _button) {
    if (_button == 0 && inside(xPressed, yPressed)) {
        selected = TRUE;
        radius = selectedRadius;
        recalculate();
        setHandles(xPressed, yPressed);
        return TRUE;
    }
    if (_button == 2 && inside(xPressed, yPressed)) return TRUE;
    if (_button == 3 && inside(xPressed, yPressed)) {
        radius++;
        normalRadius = radius;
        selectedRadius = radius * SELECTEDFACTOR;
        recalculate();
        return TRUE;       
    }
    if (_button == 4 && inside(xPressed, yPressed)) {
        radius--;
        normalRadius = radius;
        selectedRadius = radius * SELECTEDFACTOR;
        radius  = (radius  < MINIMUMSIZE) ? MINIMUMSIZE : radius; 
        recalculate();
        return TRUE;       
    }
    return FALSE;
}

void EventTriangle::mouseDragged(float xDrag, float yDrag, int _button) {
    if (_button == 0 && inside(xDrag, yDrag)) {
        reHandle(xDrag, yDrag);
    }
}

void EventTriangle::mouseReleased(float xReleased, float yReleased, int _button) {
    if (_button == 0 && inside(xReleased, yReleased)) {
        radius = normalRadius;
        recalculate();
    }
    selected = FALSE;
}

// Private methods

bool EventTriangle::inside(float _x, float _y) {
    // Borrowed from http://compsci.ca/v3/viewtopic.php?t=6034 bugzpodder 
    float area = abs(x1*y2 + x2*y3 + x3*y1 - x1*y3 - x3*y2 - x2*y1) / 2;
    
    float subArea1 = abs(_x*y2 + x2*y3 + x3*_y - _x*y3 - x3*y2 - x2*_y) / 2;
    float subArea2 = abs(x1*_y + _x*y3 + x3*y1 - x1*y3 - x3*_y - _x*y1) / 2;
    float subArea3 = abs(x1*y2 + x2*_y + _x*y1 - x1*_y - _x*y2 - x2*y1) / 2;
    
//    cout << name << " area: " << area << " subAreas: " << subArea1 << ", "  
//         << subArea2 << ", " << subArea3 << " total: " 
//         << subArea1 + subArea2 + subArea3;
    
    if (abs(area - (subArea1 + subArea2 + subArea3)) < ROUNDING) {
//        cout << " match!" << endl;
        return true;
    }
//    cout << " no match" << endl;
    return false;
}

void EventTriangle::recalculate() {
    x1 = x + radius * sin(orientation);
    y1 = y + radius * cos(orientation);
    x2 = x + radius * sin(orientation + 2 * PI / 3);
    y2 = y + radius * cos(orientation + 2 * PI / 3);
    x3 = x + radius * sin(orientation + 4 * PI / 3);
    y3 = y + radius * cos(orientation + 4 * PI / 3);    
//    cout << "recalc r: " << radius << endl;
}

void EventTriangle::reHandle(float _x, float _y) {
        x  = _x - xHandle;
        y  = _y - yHandle;
        x1 = _x - xHandle1;
        y1 = _y - yHandle1;
        x2 = _x - xHandle2;
        y2 = _y - yHandle2;
        x3 = _x - xHandle3;
        y3 = _y - yHandle3;   
}

void EventTriangle::setHandles(float _x, float _y) {
        xHandle  = _x - x;
        yHandle  = _y - y;
        xHandle1 = _x - x1;
        yHandle1 = _y - y1;
        xHandle2 = _x - x2;
        yHandle2 = _y - y2;
        xHandle3 = _x - x3;
        yHandle3 = _y - y3;    
}