/* 
 * File:   EventRectangle.h
 * Author: fjkraan
 *
 * Created on June 3, 2012, 3:09 PM
 * 
 * part of objectEventExample
 */

#ifndef EVENTRECTANGLE_H
#define	EVENTRECTANGLE_H

#include <iostream>
#include "ofMain.h"
#include "EventObject.h"

class EventRectangle : virtual public EventObject {
    
private:
    ofRectangle* rectangle;
    float x;
    float y;
    float height;
    float width;
    float normalHeight;
    float selectedHeight;
    float normalWidth;
    float selectedWidth;

public:
    EventRectangle(float x, float y, float xSize, float ySize);
    ~EventRectangle();
    
    // mirrorred testApp methods
    void update();
    void draw();
    void keyPressed(int key);
    void keyReleased(int key);
    bool mousePressed(float x, float y, int button);
    void mouseDragged(float x, float y, int button);
    void mouseReleased(float x, float y, int button);
    bool inside(float x, float y);
};

#endif	/* EVENTRECTANGLE_H */

