// part of objectEventExample

#include "EventRectangle.h"

EventRectangle::EventRectangle(float xCreate, float yCreate, 
        float xCreateSize, float yCreateSize) {
    selected = FALSE;
    x = xCreate;
    y = yCreate;
    width = xCreateSize;
    height = yCreateSize;
    normalHeight = yCreateSize;
    selectedHeight = yCreateSize * SELECTEDFACTOR;
    normalWidth = xCreateSize;
    selectedWidth = xCreateSize * SELECTEDFACTOR;
}



EventRectangle::~EventRectangle() {}

void EventRectangle::update() {}

void EventRectangle::draw() {
    EventObject::draw();
    // This does not support a rotated rectangle (not PI/2, PI, 3PI/2 2PI)
    float topLeftX = x - width / 2;
    float topLeftY = y - height / 2;
    ofRect(topLeftX, topLeftY, width, height);
}

void EventRectangle::keyPressed(int _key) {}

void EventRectangle::keyReleased(int _key) {}

bool EventRectangle::mousePressed(float xPressed, float yPressed, int _button) {
    if (_button == 0 && inside(xPressed, yPressed)) {
        xHandle = xPressed - x;
        yHandle = yPressed - y;
        selected = TRUE;
        height = selectedHeight;
        width = selectedWidth;        
        return TRUE;
    }
    if (_button == 2 && inside(xPressed, yPressed)) return TRUE;
    if (_button == 3 && inside(xPressed, yPressed)) {
        width += 2;
        height += 2;
        normalHeight += 2;
        selectedHeight += 2 * SELECTEDFACTOR;
        normalWidth += 2;
        selectedWidth += 2 * SELECTEDFACTOR;
        return TRUE;
    }
    if (_button == 4 && inside(xPressed, yPressed)) {
        if (width + height > MINIMUMSIZE * 2) {
        width -= 2;
        height -= 2;
        normalHeight -= 2;
        selectedHeight -= 2 * SELECTEDFACTOR;
        normalWidth -= 2;
        selectedWidth -= 2 * SELECTEDFACTOR;            
        }
        return TRUE;
     }
    return FALSE;
}

void EventRectangle::mouseDragged(float xDrag, float yDrag, int _button) {
    if (_button == 0 && inside(xDrag, yDrag)) {
        x = xDrag - xHandle;
        y = yDrag - yHandle;
    }
}

void EventRectangle::mouseReleased(float xReleased, float yReleased, int _button) {
    if (_button == 0 && selected) {
        height = normalHeight;
        width  = normalWidth;
        selected = FALSE;
    }
}

// Private methods

bool EventRectangle::inside(float _x, float _y) {
    float halfWidth = width / 2;
    float halfHeight = height / 2;
    if ((x - halfWidth)  < _x && _x < (x + halfWidth)  && 
        (y - halfHeight) < _y && _y < (y + halfHeight)) {
        return TRUE;
    }
    return FALSE;
}