// part of objectEventExample

#include "EventCircle.h"

EventCircle::EventCircle(float xCreate, float yCreate, float createRadius) {
    selected = FALSE;
    x = xCreate;
    y = yCreate;
    radius = createRadius;
    normalRadius = createRadius;
    selectedRadius = createRadius * SELECTEDFACTOR;
}

EventCircle::~EventCircle() {}

void EventCircle::update() {}

void EventCircle::draw() {
    EventObject::draw();
    ofCircle(x, y, radius);
}

void EventCircle::keyPressed(int _key) {
}

void EventCircle::keyReleased(int _key) {
}

bool EventCircle::mousePressed(float xPressed, float yPressed, int _button) {
    if (_button == 0 && inside(xPressed, yPressed)) {
        xHandle = xPressed - x;
        yHandle = yPressed - y;
        selected = TRUE;
        radius = selectedRadius;
        return TRUE;
    }
    if (_button == 2 && inside(xPressed, yPressed)) return TRUE;
    if (_button == 3 && inside(xPressed, yPressed)) {
        radius++;
        normalRadius = radius;
        selectedRadius = radius * SELECTEDFACTOR;
        return TRUE;       
    }
    if (_button == 4 && inside(xPressed, yPressed)) {
        radius--;
        radius  = (radius  < MINIMUMSIZE) ? MINIMUMSIZE : radius; 
        normalRadius = radius;
        selectedRadius = radius * SELECTEDFACTOR;
        return TRUE;       
    }
   return FALSE;
}

void EventCircle::mouseDragged(float xDrag, float yDrag, int _button) {
    if (_button == 0 && inside(xDrag, yDrag)) {
        x = xDrag - xHandle;
        y = yDrag - yHandle;
    }
}

void EventCircle::mouseReleased(float xReleased, float yReleased, int _button) {
//    if (_button == 0 && inside(xReleased, yReleased)) {
        selected = FALSE;
        radius = normalRadius;
//    }
}

// Private methods

bool EventCircle::inside(float _x, float _y) {
    float horizontalDiff = x - _x;
    float verticalDiff   = y - _y;
    
    // comparing the squared distance to the squared radius is cheaper that 
    //  calculating a square root
    if ((horizontalDiff * horizontalDiff) + (verticalDiff * verticalDiff) < 
            (radius * radius)) {
        return true;
    }
    return false;
}