/*
 * Copyright 2004 Fred Jan Kraan
 *
 * This file is part of JSynthLib.
 *
 * JSynthLib is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * JSynthLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSynthLib; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * Rhythm Setup Driver for Roland MT32.
 *
 * @version $Id: RolandMT32SingleDriver.java,v 0.05 2004/07/24 16:46:00 fjkraan Exp $
 */

package synthdrivers.RolandMT32;
import core.Driver;
import core.JSLFrame;
import core.NameValue;
import core.Patch;
import core.SysexHandler;
import core.ErrorMsg;

/**
 * Single Voice Patch Driver for Roland MT32.
 *
 * @version $Id: RolandMT32RhythmSetupDriver.java,v 0.02 2004/07/10 21:11:39 fjkraan Exp $
 */
public class RolandMT32RhythmSetupDriver extends Driver {
    /** Header Size of the Data set DT1 message. */
    private static final int HSIZE = 8;
    /** Single Patch size */
    private static final int SSIZE = 3 + 1;
    private static final SysexHandler SYS_REQ = new SysexHandler(
        "F0 41 10 16 11 03 01 10 00 00 03 *checkSum* F7");

    public RolandMT32RhythmSetupDriver() {
	super("Rhythm Setup", "Fred Jan Kraan");
	sysexID = "F041**16";
	patchSize	= HSIZE + SSIZE + 1;
	patchNameStart	= 0;
	patchNameSize	= 0;
	deviceIDoffset	= 2;
        checksumStart=5;
        checksumEnd=10;
        checksumOffset=0;
//	checksumStart	= HSIZE;
//	checksumEnd	= HSIZE + SSIZE - 2;
//	checksumOffset	= HSIZE + SSIZE - 1;
        bankNumbers =new String[] {""};
        patchNumbers=new String[] {"-"};  
    }

    /* Send a patch (bulk dump system exclusive message) to MIDI device. 
     * Target should be Timbre Memory 1 - 64. TTA will do for now. 
     * The message format here is Data set DT1 */
    public void storePatch(Patch p, int bankNum, int patchNum) {
	setBankNum(bankNum);    // Control change
	setPatchNum(patchNum);  // Program change
	try {
	    Thread.sleep(100);
	} catch (Exception e) {
            ErrorMsg.reportStatus(e);
	}

//	int timbreAddr = patchNum * (SSIZE - 1);
	int patchAddr = patchNum * 0x10;
	int patAddrM = patchAddr / 0x80;
	int patAddrL = patchAddr & 0x7F;	

        p.sysex[0]   = (byte) 0xF0;
//	p.sysex[2]   = (byte) 0x10;
        p.sysex[5]   = (byte) 0x03;     // point to Patch Temp Area
	p.sysex[6]   = (byte) patAddrM;
	p.sysex[7]   = (byte) patAddrL;

        System.out.println ("store patchNum " + patchNum + " to patAddrM/L " + patAddrM + " / " + patAddrL);
//	sendPatchWorker(p);
//      send(p.sysex);
	try {
            sendPatchWorker(p);
	    Thread.sleep(100);
	} catch (Exception e) {
            ErrorMsg.reportStatus(e);
	}
	setPatchNum(patchNum);  // Program change
    }

    /*  Send a Patch (bulk dump system exclusive message) to an edit
     *  buffer of MIDI device. Target should be Timbre Temp Area 1 - 8. 
     *  The message format here is Data set DT1 */
    public void sendPatch(Patch p) {
//        int patchNum = (HSIZE + SSIZE + 1);
//	p.sysex[0] = (byte) 0xF0;
//	p.sysex[1] = (byte) 0x41;
//	p.sysex[2] = (byte) 0x10;
//	p.sysex[3] = (byte) 0x16;
// 	p.sysex[4] = (byte) 0x08;
//	p.sysex[5] = (byte) 0x00;
//	p.sysex[6] = (byte) 0x00;
// 	p.sysex[4] = (byte) 0x04;
//	p.sysex[5] = (byte) (byte)(patchNum / 0x80);
//	p.sysex[6] = (byte) (byte)(patchNum & 0x7F);

        //this.calculateChecksum(p, 4, 253, 0);
// 	p.sysex[255] = (byte) 0xF7;

//        System.out.println("sendPatch: Not implemented yet.");
	sendPatchWorker(p);
    }

    // not used
    public void calculateChecksum(Patch p, int start, int end, int ofs) {
	int sum = 0;
	for (int i = start; i <= end; i++) {
	    sum += p.sysex[i];
	}
	sum += 0xA5;
	p.sysex[ofs] = (byte) (sum % 128);
    }

    // not used
    public Patch createNewPatch() {
        byte[] sysex = new byte[HSIZE + SSIZE + 1];
	sysex[0] = (byte) 0xF0; sysex[1] = (byte) 0x41; sysex[2] = (byte) 0x10;
	sysex[3] = (byte) 0x16; sysex[4] = (byte) 0x12; 
        sysex[5] = (byte) 0x03; sysex[6] = (byte) 0x00; sysex[7] = 0x00; // address
        sysex[HSIZE + 0] = 0x41;   // Timbre Number: R1
        sysex[HSIZE + 1] = 0x50;   // Output Level:  80
        sysex[HSIZE + 2] = 0x07;   // Panpot:        middle
        sysex[HSIZE + 3] = 0x00;   // Reverb Switch: off
        sysex[HSIZE + SSIZE] = (byte) 0xF7;
	Patch p = new Patch(sysex, this);
//	setPatchName(p, "New Rhythm Setup");
	calculateChecksum(p);
	return p;
    }

    public JSLFrame editPatch(Patch p) {
	return new RolandMT32RhythmSetupEditor(p);
    }

    public void requestPatchDump(int bankNum, int patNum) {
        // The message format here is Request RQ1
        NameValue nv[]=new NameValue[1];
	
        nv[0]=new NameValue("checkSum",0x69);
        send(SYS_REQ.toSysexMessage(getChannel(),  nv));
    }
}
