/*
 * Copyright 2004 Fred Jan Kraan
 *
 * This file is part of JSynthLib.
 *
 * JSynthLib is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * JSynthLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSynthLib; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/*
 * MT32Model.java v.0.3
 * part of the Roland MT-32 driver
 */

package synthdrivers.RolandMT32;
import core.*;

class MT32Model extends ParamModel {
	    private int bitmask;
	    private int mult;

	    public MT32Model(Patch p, int o) {
		ofs = o + 8; patch = p;   // o + 8: offset in message vs. address
	    }

	    public MT32Model(Patch p, int o, int b) {
		ofs = o + 8; patch = p;   // o + 8: offset in message vs. address
	    }

	    public void set(int i) {
		patch.sysex[ofs] = (byte) i;
	    }

	    public int get() {
		return patch.sysex[ofs];
	    }
	}
