;**********************************************************************
;**                  Midi Exiter Definitions 0.35                    **
;**********************************************************************
; This file contains the definitions, constants and memory structures
;  for the midi exiter file.
;; Generic registers

;.def busych    = r00
.def sintabptr = r01       ; Sinus table pointer LSB
.def rxrbstat  = r02
.def txrbstat  = r03
.def wavemode  = r04
.def midichan  = r05
.def midistat  = r06
.def midictrn  = r07
.def savesreg  = r08
.def scanbut   = r09       ; value of the scanned buttons
.def msgrate   = r10       ; 
;.def nibstore  = r11       ; storage of the other nibble
.def dutycycl  = r12
.def tempscan  = r13
.def Tim0Ext   = r14       ; 
.def tempWavVal = r15       ; most significant nibble in hex
; Extended generic registers (sbci, subi, cpi, andi, ori, ldi)
.def flags     = r16       ; main loop int, adc dummy, keyphase flags, sinus table polarity
.def temp      = r17       ; generic variable for main program
.def temp2     = r18       ; extra generic variable for main program
;.def temp3     = r19       ; 
.def ldelcnt   = r20       ; long delay count
.def sdelcnt   = r21       ; short delay count
.def isrtemp   = r22       ; generic variable for ISR routines
.def tim0dutcy = r23
.def flags2    = r24
.def editstat  = r25
.def ramptrl   = r26        ; RAM pointer used by main program subroutines. LSB of X
.def rx_tailptrl = r27      ; Tail ring buffer pointer LSB points to earliest added char
.def parmvalcnt  = r28      ; Tail ring buffer pointer LSB points to earliest added char
.def isrramprtl  = r28      ; RAM pointer used by ISR routines. LSB of Y
.def rx_headptrl = r29      ; Head ring buffer pointer MSB points to latest added char
.def tx_tailptrl = r30      ; Tail ring buffer pointer LSB points to earliest added char
.def tx_headptrl = r31      ; Head ring buffer pointer MSB points to latest added char

;flags register            ; The set* end tst* consts are sets. 
.equ setmlpintfl   = 1     ;  One to set a register bit (a bit pattern, with sbr), 
.equ tstmlpintfl   = 0     ;  another to test it (a bit number, with sbrc/sbrs).  
.equ setdebugfl    = 2     ;  Reeks like an instruction set botch to me.
.equ tstdebugfl    = 1     ;  Sets:1/0, 2/1, 4/2, 8/3, 16/4, 32/5, 64/6, 128/7
.equ setWavPolfl   = 4     ; Wave phase. positive if set, negative if clear.
.equ tstWavPolfl   = 2     ;   Set in GETSINVALUE
.equ setWavSlofl   = 8     ; Wave slope. ascending if set, descending if clear
.equ tstWavSlofl   = 3     ;   Set in GETSINVALUE
.equ setkeyphfl    = 16
.equ tstkeyphfl    = 4
.equ setTModfl     = 32    ;  type A: speed upper half vs. lower half,  
.equ tstTModfl     = 5     ;  type B: ascending vs. descending
.equ setMesgIntfl  = 128   ; 
.equ tstMesgIntfl  = 7     ; 

;flags2 register            ; The set* end tst* consts are sets. 
                            ;  Sets:1/0, 2/1, 4/2, 8/3, 16/4, 32/5, 64/6, 128/7
.equ setIncfl      = 1     ; Indicating EXT interrupt type; increment or decrement
.equ tstIncfl      = 0     ;  Used by ISRs EXT_INT0 and EXT_INT1 for parameter change
.equ setInhMsgfl   = 2     ; Inhibit output flag
.equ tstInhMsgfl   = 1     ;  Used while changing Control Change number value

;wavemode register. 
.equ sinusa        = 0     ; Sinus. Duty cycle modulates upper half vs. lower half.
.equ sinusb        = 1     ; Sinus. Duty cycle modulates ascending half vs. descending half.
.equ square        = 2     ; Square. Duty cycle modulates upper half vs. lower half.
.equ triang        = 3     ; Triangle. Duty cycle modulates ascending half vs. descending half.

.equ tstWModfl     = 0     ;  clear: upper/lower half; set: ascending/descending half
.equ tstWTypfl     = 1
.equ tstQuadRatefl  = 2     ;  just calling it twice is the safest way

;Xtal oscillator frequency
.equ Clock     = 8000000
;Baud rate for MIDI
.equ Baud      = 31250
.equ UbrrVal   = Clock/(Baud*16)-1

; Timer0 is for the message rate. The minimum timer interval is 1ms, 
;  the transmission time of one midi message. So the minimum value for the
;  message rate (Tim0PreScl = Clock/64) is Timer0Val 125 or 
;  (Tim0PreScl = Clock/1024) Timer0Val 8. Compensated for the dutycycle
;  value, we get 0x3F+8=0x47
;.equ Tim0PreScl = 0b00000101 ; Clock / 1024 (8 MHz / 1024 = 7812,5 Hz;  8 minimum.
.equ Tim0PreScl = 0b00000100 ; Clock / 256 (8 MHz / 256 = 31250 Hz;   32, 0x20
;.equ Tim0PreScl = 0b00000011 ; Clock / 64   (8 MHz / 64 = 125000 Hz; 125
;Timer 0 value to get ~10ms interrupts. Base for message rate
;.equ Timer0Val = 255 - 78 
;.equ Timer0Val = 0x47  ; Assumes the duty cycle value (-0x3F to +0x3F) is added
;.equ Timer0Val = 0x40  ; Assumes the duty cycle value  (-0x3F to +0x3F) is added.
;                      ; moved the minimum of 8 to the extension.
;.equ Timer0Val = 13    ; A tenth of the minimum time. This leaves 10 as minimum for
;                         the Tim0ExtBase
.equ Timer0Val = 0xFF - 0x05   ; Timers increment to overflow.
;.equ Tim0ExtBase = 8
;.equ Tim0ExtBase = 73 ; 0x3F (63) + 10
.equ Tim0ExtBase = 0x05

.equ Tim1PreScl = 0b00000100 ; Clk/256
;Timer 1 value to get 0.1 second interrupts for display/gui
;.equ Timer1Val = 65535 - 31250 ; One second interrupts
.equ Timer1Val = 65535 - 6250   ; 200 ms interrupt
;.equ Timer1Val = 65535 - 3125  ; 100 ms interrupt
;.equ Timer1Val = 65535 - 313   ; 10 ms interrupts


;Midi values               data bytes
;.equ KeyOff    = 0x80        ; 2 - 1 byte key number, 1 byte velocity
;.equ KeyOn     = 0x90        ; 2 - 1 byte key number, 1 byte velocity
;;.equ CC_Ch0    = 0xB0        ; 2 - 1 byte parameter number, 1 byte setting
;.equ PitchWhl  = 0xE0        ; 2 - 1 byte parameter number, 1 byte setting
;.equ SysEx     = 0xF0
;.equ SysExEOF  = 0xF7
;.equ TimeClk   = 0xF8
;.equ UndeF9    = 0xF9
;.equ Start     = 0xFA
;.equ Continue  = 0xFB
;.equ Stop      = 0xFC
;.equ UndeFD    = 0xFD
;.equ ActSens   = 0xFE
;.equ SysReset  = 0xFF


.equ DISP_WRPat = 0b11110000  ; Data direction mask for display write
.equ HD_Adr    = PORTB       ; Bits 3-5
.equ HD_Strb   = PORTC       ; Bit  4
.equ HD_Data   = PORTD       ; Bits 4-7
.equ HD_1LSN   = 0b00000000  ; 1st digit, a,b,c,d  segments
.equ HD_1MSN   = 0b00001000  ; 1st digit, e,f,g,dp segments
.equ HD_2LSN   = 0b00010000  ; 2nd digit, a,b,c,d  segments
.equ HD_2MSN   = 0b00011000  ; 2nd digit, e,f,g,dp segments
.equ HD_3      = 0b00100000  ; extra LED's

;Keyboard port aliasses, masks and values 
.equ ButRows   = PINC
.equ ButCol    = PORTB
.equ FncCol    = 5
.equ NavCol    = 4

.equ ButMask   = 0x0F

;Dutycycle/Rate LED
.equ RateLedPort = PORTC
.equ RateLedBit  = 5

;**********************************************************************
;**                             SRAM                                 **
;**********************************************************************
.dseg
.org 0x60
RXRBUFSTR:
.org 0x6F
RXRBUFEND:

.org 0x70
TXRBUFSTR:
.org 0x7F
TXRBUFEND:

.org 0x80
SINUSTABLE:
; The end point of the sinus table is determined by the size of the EEPROM table
;.equ SINUSTABLEEND = (EESINUSTABLEEND - EESINUSTABLE) + SINUSTABLE (Does not work!)
.org 0x9F
SINUSTABLEEND:

.org 0xA0
HDCHAR:
.org 0xAF
HDCHAREND:

;RAMEND 0xDF (stackbottom) 


;**********************************************************************
;**                           EEPROM                                 **
;**********************************************************************
.eseg
.org 0x00

EmptyPos:                  ;leave eeprom location 00 empty due to bug
.db 00                     ;in AVR that randomly erases the contents

FlashMessage:		
.db "Electrickery MIDI Exiter version 0.35. 2003-11, fjkraan@xs4all.nl"

.org 0xB0
EESINUSTABLE:  ; Implements one half of the sinus. Invert for other half.
.db 0x00,0x19,0x32,0x4A,0x62,0x78,0x8E,0xA2,0xB4,0xC5,0xD4,0xE1,0xEC,0xF4,0xFA,0xFE
.db 0xFF,0xFE,0xFA,0xF4,0xEC,0xE1,0xD4,0xC5,0xB4,0xA2,0x8E,0x78,0x62,0x4A,0x32,0x19
;.db  00,  06,  12,  18,  24,  30,  35,  40,  45,  49,  52,  56,  58,  60,  62,  63
;.db  63,  63,  62,  60,  58,  56,  52,  49,  45,  40,  35,  30,  24,  18,  12,  06
;.db 0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0xAA,0xBB,0xCC,0xDD,0xEE,0xFF
;.db 0xFF,0xEE,0xDD,0xCC,0xBB,0xAA,0x99,0x88,0x77,0x66,0x55,0x44,0x33,0x22,0x11,0x00
EESINUSTABLEEND:

EEHDCHAR:
;7-segment definitions. Each byte contains two nibbles
.db 0b11000000 ; 0
.db 0b11111001 ; 1
.db 0b10100100 ; 2
.db 0b10110000 ; 3
.db 0b10011001 ; 4
.db 0b10010010 ; 5
.db 0b10000010 ; 6
.db 0b11111000 ; 7
.db 0b10000000 ; 8
.db 0b10010000 ; 9
.db 0b10001000 ; A
.db 0b10000011 ; b
.db 0b11000110 ; C
.db 0b10100001 ; d
.db 0b10000110 ; E
.db 0b10001110 ; F
EEHDCHAREND:

.org 0xF8
EEVERSION:
.db 0x35 

EEMIDISTAT:
.db 0xB0

EEMIDICHAN:
.db 0x00

EEMIDICRTN:
.db 0x5C

EEEDITSTAT:
.db 0x00

EEWAVEMODE:
.db 0x00

EEMSGRATE:
.db 0x07

EEDUTYCYCL:
.db 0x0F