;**********************************************************************
;**                Midi Exiter 0.35  -- son of Midip                 **
;**********************************************************************
; The main program and less stable routines of the Midi Exiter. Midip
; was an ill-fated, never completed MIDI project I started in the mid 80's.
; To be build on wire-wrapped boards and Z80 based, it was a Pad-to-MIDI
; converter. The keyboard is reused in the Midi Exiter. 
; Files copyrighted by F.J. Kraan unless indicated otherwise. When all 
; foreign routines are replaced, the set will be released under GPL (or
; maybe sold for large sums of money :-) ).

.include "4433def.inc"
.include "midiexiter_def.asm"


;**********************************************************************
;**                            FLASH                                 **
;**********************************************************************
.cseg
.org 0x000             ; Jump to main program
    rjmp RESET         ;  and skip interrupt jump table

.org INT0addr
    rjmp EXT_INT0      ; IRQ0 Handler
.org INT1addr
    rjmp EXT_INT1      ; IRQ1 Handler
.org ICP1addr
    rjmp TIM1_CAPT     ; Timer1 Capture Handler
.org OC1Aaddr
    rjmp TIM1_COMP     ; Timer1 Compare Handler
.org OVF1addr
    rjmp TIM1_OVF      ; Timer1 Overflow Handler
.org OVF0addr
    rjmp TIM0_OVF      ; Timer0 Overflow Handler
.org SPIaddr
    rjmp SPI_STC       ; SPI Transfer Complete Handler
.org URXCaddr
    rjmp UART_RXC      ; UART RX Complete Handler
.org UDREaddr
    rjmp UART_DRE      ; UDR Empty Handler
.org UTXCaddr
    rjmp UART_TXC      ; UART TX Complete Handler
.org ADCCaddr
    rjmp ADC           ; ADC Conversion Complete Interrupt Handler
.org ERDYaddr
    rjmp EE_RDY        ; EEPROM Ready Handler
.org ACIaddr
    rjmp ANA_COMP      ; Analog Comparator Handler

RESET:
;	Stack pointer
	ldi   temp, low(RAMEND)
	out	  SPL,temp
;   Configure Baudrate 
    ldi   temp,  LOW(UbrrVal)
    out   UBRRL, temp
    ldi   temp,  HIGH(UbrrVal)
    out   UBRRH, temp
    sbi   UCSRB, TXEN      ; TX activeren
;   Port initialisation
    ldi   temp,  0xFF      ; PB output
    out   DDRB,  temp
    ldi   temp,  DISP_WRPat ; PD 0,1 input, 2-7 output 
    out   DDRD,  temp
	ldi   temp,  0xFF      ; Set all pins high
	out   PORTC, temp      ;  then define some of them output
    ldi   temp,  0xF0      ; PC 0-3 input, 4,5 output
    out   DDRC,  temp
;   Interrupt definition
;   Inputs
    ldi   temp,   0b00001010 ; INT0 en INT1 configureren: falling edge
;    ldi   temp,   0b00001111 ; INT0 en INT1 configureren: rising edge
;    ldi   temp,   0b00000101 ; INT0 en INT1 configureren: any change
;    ldi   temp,   0b00000000 ; INT0 en INT1 configureren: low level
    out   MCUCR,  temp
    ldi   temp,   0b11000000 ; INT0 en INT1 activeren
;    ldi   temp,   0b00000000 ; INT0 en INT1 deactiveren
    out   GIMSK,  temp

;   Timer0
    ldi   temp,   Tim0PreScl ; Prescaler 
	out   TCCR0,  temp
	ldi   temp,   Timer0Val
	out   TCNT0,  temp
;	mov   Tim0Ext, temp       ; Set when msgrate is retrieved fro EEPROM

;   Timer1
    ldi   temp,   0b00000000 ; Extended timer options. Not used.
	out   TCCR1A, temp
    ldi   temp,   Tim1PreScl ; Prescaler
    out   TCCR1B, temp
    ldi   temp,   HIGH(Timer1Val) ;  MSB
    out   TCNT1H, temp
    ldi   temp,   LOW(Timer1Val)  ;  LSB
    out   TCNT1L, temp
    ldi   temp,   0b10000000 ; TOV1  set
	out   TIFR,   temp
    ldi   temp,   0b10000010 ; TOIE1 & TOIE0 set
    out   TIMSK,  temp
;   Some runtime variables
	ldi   temp,     0
	mov   tempscan, temp
	mov   parmvalcnt, temp
	mov   flags,    temp

    ldi   temp, EEMIDICHAN       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    midichan, EEDR

    ldi   temp, EEMIDICRTN       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    midictrn, EEDR

    ldi   temp, EEEDITSTAT       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    editstat, EEDR

    ldi   temp, EEMSGRATE       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    msgrate, EEDR
	mov   Tim0Ext, msgrate ; Initialise timer
	inc   Tim0Ext

    ldi   temp, EEWAVEMODE       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    wavemode, EEDR

    ldi   temp, EEMIDISTAT       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    midistat, EEDR

    ldi   temp, EEDUTYCYCL       ; Retrieve it 
    out   EEAR, temp       ; Retrieve it 
    sbi   EECR, EERE       ;  from EEPROM
    in    dutycycl, EEDR

; Load Hex Display character table into SRAM. 
HDCHARLOAD:
	ldi   temp2,   EEHDCHAR
	ldi   ramptrl, LOW(HDCHAR)
HDCHARLDLOOP:
	out   EEAR,    temp2
	sbi   EECR,    EERE
	in    temp,    EEDR
	st    X+,      temp
	inc   temp2
	cpi   temp2,   LOW(EEHDCHAREND)
	brne  HDCHARLDLOOP
ENDOFHDCHARLDLOOP:

DISPLAYVERSION:
	ldi   temp,    EEVERSION
    out   EEAR,    temp       ; Retrieve it 
    sbi   EECR,    EERE       ;  from EEPROM
	in    tempscan, EEDR    ; The keyboard routine won't 
	mov   temp,    tempscan   ;  mind if I borrow tempscan here
	swap  temp
	rcall HD1_WR
	mov   temp,    tempscan
	rcall HD2_WR
	ldi   temp,     0
	mov   tempscan, temp


;   Ring buffer configuration
    ldi   rx_tailptrl, LOW(RXRBUFSTR) ; Reset all pointers to start
	ldi   rx_headptrl, LOW(RXRBUFSTR) ;  of ring buffers
    ldi   tx_tailptrl, LOW(TXRBUFSTR) ;
	ldi   tx_headptrl, LOW(TXRBUFSTR) ;

    ldi   temp,  0
	mov   rxrbstat,  temp        ; Initialise ring buffer statussus, stati?
	mov   txrbstat,  temp        ;  reflects usage, 0 = empty

;   UART
    sbi   UCSRB,  RXEN           ; Receiver enable
    sbi   UCSRB,  RXCIE          ; Character received interrupt enable
	sbi   UCSRB,  TXEN           ; Transmitter enable
	sbi   UCSRB,  UDRIE          ; UDR register empty interrupt enable
;	sbi   UCSRB,  TXCIE

; Load Sinus table into SRAM. temp2 is the EEPROM adress pointer, ramptrl the SRAM pointer
SINUSLOAD:
    ldi   temp2,   EESINUSTABLE
	ldi   ramptrl, LOW(SINUSTABLE)
    mov   sintabptr, ramptrl     ; intialisation for retrieval
SINLDLOOP:
    out   EEAR,    temp2         ; Retrieve it 
    sbi   EECR,    EERE          ;  from EEPROM
    in    temp,    EEDR
    st    X+,      temp          ; X is alternate name for ramptrl + ramptrh*256
    inc   temp2                  ; Point to next EEPROM address
    cpi   temp2,   LOW(EESINUSTABLEEND) ; Check for end of table
    brne  SINLDLOOP              ; Goto exit if not
ENDOFSINLD:

    sei                          ; Main interrupt activate 

RESETEND:

LOOP:
	mov   temp,    rxrbstat        ; If receive ring buffer is empty
	cpi   temp,    0x00
	breq  LOOP_3           ;  skip this part
	rcall GET4RXRB         ; Retrieve a character 
	rcall ADD2TXRB         ;  and dump it in the transmit ring buffer
	rjmp  LOOP             ; Repeat until RxRb is empty
LOOP_3:
	sbrs  flags, tstMesgIntfl ; Skip next if MesgIntFlag is set
	rjmp  LOOP_2
	cbr   flags, setMesgIntfl 
	sbrs  flags2, tstInhMsgfl ; Skip next if Message Inhibit flag is clear
	rcall SENDMESSAGE

LOOP_2:
	sbrs  flags, tstmlpintfl  ; Skip next if main loop interrupt flag. 
	rjmp  LOOP              ; If set do this part too.

    cbr  flags,  setmlpintfl   ; reset the main loop interrupt flag

LOOP_1:
    rcall READBUTTON


SAVESELECT:                   ; Save current parameter in EEPROM
	sbrc  scanbut, 3          ; Skip next instruction if scanbut 3 is clear (P)
	rcall SAVEEEVALUE

	rcall EDIT_SELECT
	rcall EDIT_DISPLAY



	rjmp  LOOP

;**********************************************************************
;**                           ISR Macros                             **
;**********************************************************************
.macro UD_G4TX
;GET4TXRINGBUFFER routine build into Tx ISR
	mov   isrramprtl,  tx_tailptrl    ; Get pointer
    ld    isrtemp,     Y+             ; Retrieve value from first filled location and increment pointer
	cpi   isrramprtl,  LOW(TXRBUFEND)+1
    brne  G4TX_NOWRAP                 ; Branch if pointer has legal value
    ldi   isrramprtl,  LOW(TXRBUFSTR) ; Reset pointer to start of range (ring buffer)
G4TX_NOWRAP:                          ;
	mov   tx_tailptrl, isrramprtl     ; Store pointer in appropriate register
	dec   txrbstat                    ; Adjust the status byte
;end of GET4TXRINGBUFFER routine 
.endmacro

.macro UR_A2RX
;ADD2RXRINGBUFFER routine build into Rx ISR
	mov   ramptrl,   rx_headptrl     ; Load significant part of RAM pointer
    st    X+,        isrtemp         ; Store value in first empty buffer location and increment pointer
	cpi   ramptrl,   LOW(RXRBUFEND)+1
	brne  A2RX_NOWRAP                ; But skip if it isn't
	ldi   ramptrl,   LOW(RXRBUFSTR)  ;
A2RX_NOWRAP:                         ;
    mov   rx_headptrl, ramptrl       ;
    inc   rxrbstat                   ;
;end of ADD2RXRINGBUFFER routine
.endmacro

.macro PARAM_EDIT              ; Apply rotary encoder changes to the selected parameter.
	cpi   editstat, 0          ;  This macro is called by two ISRs, hence checking the
	breq  PE_WAVTYP            ;  Increment flag tstIncfl.
	cpi   editstat, 1
	breq  PE_WAVMOD
	cpi   editstat, 2
	breq  PE_MSGRAT
	cpi   editstat, 3
	breq  PE_MCHAN
	cpi   editstat, 4
	breq  PE_MCRTN
	rjmp  PE_EXIT

PE_WAVTYP:                      ; 0
	mov   isrtemp,  wavemode
	sbrc  flags2,   tstIncfl    ; Skip next if bit is clear
	rjmp  PE_WVTINC
PE_WVTDEC:
	dec   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x00
	rjmp  PE_WVTEND
PE_WVTINC:
	inc   isrtemp
	sbrc  isrtemp,  3           ; Skip next if bit 3 is clear.
	ldi   isrtemp,  0x07        ; Top limit for editing
PE_WVTEND:
	mov   wavemode, isrtemp
	rjmp  PE_EXIT

PE_WAVMOD:                      ; 1
	mov   isrtemp,  dutycycl
	sbrc  flags2,   tstIncfl    ; Skip next if bit is clear
	rjmp  PE_WVMINC
PE_WVMDEC:
	dec   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x00
	rjmp  PE_WVMEND
PE_WVMINC:
	inc   isrtemp
	sbrc  isrtemp,  5
	ldi   isrtemp,  0x1F
PE_WVMEND:
	mov   dutycycl, isrtemp
	rjmp  PE_EXIT

PE_MSGRAT:                       ; 2
	mov   isrtemp,  msgrate
	sbrc  flags2,   tstIncfl   ; Skip next if bit is clear
	rjmp  PE_MSRINC
PE_MSRDEC:
	dec   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x00
	rjmp  PE_MSREND
PE_MSRINC:
	inc   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x7F
PE_MSREND:
	mov   msgrate, isrtemp
	rjmp  PE_EXIT

PE_MCHAN:                      ; 3
	mov   isrtemp,  midichan
	sbrc  flags2,   tstIncfl   ; Skip next if bit is clear
	rjmp  PE_MCNINC
PE_MCNDEC:
	dec   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x00
	rjmp  PE_MCNEND
PE_MCNINC:
	inc   isrtemp
	sbrc  isrtemp,  4
	ldi   isrtemp,  0x0F
PE_MCNEND:
	mov   midichan, isrtemp
	rjmp  PE_EXIT

PE_MCRTN:                      ; 4
	mov   isrtemp,  midictrn
	sbrc  flags2,   tstIncfl   ; Skip next if bit is clear
	rjmp  PE_MCRINC
PE_MCRDEC:
	dec   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x00
	rjmp  PE_MCREND
PE_MCRINC:
	inc   isrtemp
	sbrc  isrtemp,  7
	ldi   isrtemp,  0x7F
PE_MCREND:
	mov   midictrn, isrtemp
PE_EXIT:
.endmacro

;**********************************************************************
;**               Interrupt service routines from here               **
;**********************************************************************
; These routines should use their own set of registers and not the ones
; used by the main loop and subroutines.

EXT_INT0:
	in    savesreg,  SREG
	cbr   flags2,    setIncfl   ; Clear the flag for decrement value in macro
	PARAM_EDIT
	out   SREG,      savesreg
	reti
EXT_INT1:
	in    savesreg,  SREG
	sbr   flags2,    setIncfl   ; Set the flag for increment value in macro
	PARAM_EDIT
	out   SREG,      savesreg
	reti
TIM1_CAPT:
TIM1_COMP:
	reti
TIM1_OVF:                  ; Timer 1 controls the user interface: display refresh, keyboard
    in    savesreg,  SREG
	sbr   flags,     setmlpintfl
    ldi   isrtemp,   HIGH(Timer1Val) ;  MSB
    out   TCNT1H,    isrtemp
    ldi   isrtemp,   LOW(Timer1Val)  ;  LSB
    out   TCNT1L,    isrtemp
	out   SREG,      savesreg
    reti

TIM0_OVF:                  ; Timer 0 controls the MIDI message rate clock
    in    savesreg,  SREG  ;  

    ldi   isrtemp,   Timer0Val
;	sub   isrtemp,   tim0dutcy ; 
	sub   isrtemp,   msgrate
	out   TCNT0,     isrtemp
	ldi   isrtemp,   0x00
	dec   Tim0Ext
	cp    Tim0Ext,   isrtemp
	brne  TM0_EXIT           ; branch if Tim0Ext not 0
TM0_CONT:
	sbr   flags,     setMesgIntfl ; Trigger the MIDI message
TM0_REINIT:
; Reinitialisation
	ldi   isrtemp,   Tim0ExtBase
	add   isrtemp,   tim0dutcy ; 
;	add   isrtemp,   msgrate

;	inc   isrtemp               ; To prevent 0 at the low end (is max. delay).
    mov   Tim0Ext,   isrtemp
TM0_EXIT:
	out   SREG,      savesreg
    reti

SPI_STC:
    reti
UART_RXC:                  ; Message receive routine. 
    in    savesreg,  SREG
	in    isrtemp,   UDR             ; Get character from UART
	UR_A2RX
	out   SREG,      savesreg

	reti

UART_DRE:                  ; Message send routine.
    in    savesreg,  SREG
; Check for characters in ring buffer. Exit if none are left. This decativates the interrupt
;  driven processing of the transmit ring buffer. ADD2TXRB should restart it.
	mov   isrtemp,  txrbstat
	cpi   isrtemp,  0x00
    breq  UD_ISR_EXIT
	UD_G4TX
	out   UDR,      isrtemp         ;
	out   SREG,     savesreg
    reti
UD_ISR_EXIT:                      ;
	cbi   UCSRB,    UDRIE           ; Disable transmit interrupt as there is nothing to send
	out   SREG,     savesreg
    reti

UART_TXC:                           ; Not used. See UART_DRE.
    reti

ADC:
EE_RDY:
ANA_COMP:
	reti

.include "midiexiter_lib.asm"

