
/*
 *	System calls for /dev/dsp and /dev/audio
 */

int audio_read (int dev, struct fileinfo *file, char *buf, int count);
int audio_write (int dev, struct fileinfo *file, const char *buf, int count);
int audio_open (int dev, struct fileinfo *file);
void audio_release (int dev, struct fileinfo *file);
int audio_ioctl (int dev, struct fileinfo *file, unsigned int cmd, caddr_t arg, int local);
int audio_lseek (int dev, struct fileinfo *file, off_t offset, int orig);
void audio_init (void);

int audio_select(int dev, struct fileinfo *file, int sel_type, select_table_handle * wait);
void audio_unload(void);

void audio_intr(int irq, void *dev_id, struct pt_regs *dummy);

/*
 *
 *	Misc calls from various sources
 */

/*	From soundcard.c	*/
void soundcard_init(void);
void tenmicrosec(int *osp);
void request_sound_timer (int count);
void sound_stop_timer(void);
int snd_ioctl_return(int *addr, int value);
int snd_set_irq_handler (int interrupt_level, void(*hndlr)(int, void*, struct pt_regs *), char *name, int *osp);
void snd_release_irq(int vect);
void conf_printf(char *name, int base, int irq, int dma, int dma2);












