
#include <linux/config.h>
#include "sound_config.h"


                                     

/* ab hier sollte nichts mehr durch User editiert werden */
/*--------------------------------------------------------------------------------*/

/*
 *
 *	local defines
 *	-------------
 *
 */
						/* bits m_driver_state 	*/
						/* (from Space.c)	*/
#define INSTALLED		0x01		/* describing state	*/
#define OPENED			0x02		/*   driver HAS ... 	*/
#define WRITTEN			0x04
#define STARTEDMSND            	0x08
#define STOPPEDMSND		0x10

						/* m_driver_state:	*/
#define is(x)			(m_driver_state & (x))
#define isnot(x)		(!(m_driver_state & (x)))
#define set(x)			(m_driver_state |= (x))
#define clr(x)			(m_driver_state &= ~(x))
						/* other makros:	*/

#define EMPTY			0
#define FULL			-1

#define BUFFER_SIZE		16384
#define HALF_BUFFER_SIZE	8192

#define BUFFS_PER_BANK		1
#define BUFFSIZE_IN_BYTES	HALF_BUFFER_SIZE

#define NEUTRAL8		128	
#define NEUTRAL16		0

#define CounterCLR		0x8000
#define KMODE			0x4000
#define	Retransmit		0x2000
#define	RESET			0x1000
#define	IntE			0x0800
#define	Mono			0x0400
#define	SEL			0x0200
#define RW			0x0100
#define	Inp			0x0080
#define	Rstn			0x0040
#define CLD			0x0020
#define On			0x0010
#define ClockB			0x0008
#define ClockA			0x0004
#define CDO			0x0002
#define CCK			0x0001

#define ERR			0x4000
#define	FullFlag		0x2000
#define	DEP			0x1000
#define HalfFull		0x0800
#define EmptyFlag		0x0400
#define S1			0x0200
#define S2			0x0100

#define defaultPLL		CounterCLR | KMODE | Retransmit | SEL | RW | Rstn | CLD | ClockB | ClockA
#define default32		CounterCLR | RESET | Retransmit | SEL | Rstn | CLD | ClockB
#define default44		CounterCLR | RESET | Retransmit | SEL | Rstn | CLD | ClockA
#define default48		CounterCLR | RESET | Retransmit | SEL | Rstn | CLD

#define StereoOut		On
#define MonoOut			Mono | On
#define StereoIn		RESET | IntE | On
#define MonoIn			RESET | IntE | Mono | On

#define ChannelStatus32kHz	0x200000C0
#define ChannelStatus44kHz	0x20000000
#define ChannelStatus48kHz	0x20000040					


 #define io_data(d)	((d)->base)
 #define io_comand(d)	((d)->base+2)
 #define io_counter(d)	((d)->base+4)

static int		
    m_driver_state = 0;		/* Driver state (used as bit array) 	*/


/*
 *
 *	fixed and state dependend globals
 *	---------------------------------
 *
 */

static wait_handle *sleeper = NULL;
static volatile struct snd_wait sleep_flag ={0};

static char driver_name[] = "Digital Audio Interface";
static char driver_type[] = "AES/EBU input/output";

static int
	g_buffs,		/* no. of buffers allocated in open	*/
	g_buff_state[MAXBUFFS],	/* state for each buffer, FULL/EMPTY	*/
	g_intserv_buff_idx,	/* index of cur. served buffer by intr	*/
	g_rwclient_buff_idx,	/* as above, but by read/write ops.	*/
	g_rwclient_buff_pos,	/* cur. byte pos. in cur. serv. buffer	*/
	g_recbytes_ctr,		/* counter to track recorded bytes	*/
	g_playbytes_ctr,	/* same for played bytes		*/
	g_buff_err_ctr,		/* counts out-of-syncs events between	*/
				/*   intserv and read/writeserv		*/
	g_MSNDbank_err_ctr;	/* counts out-of-sync detected by dsp	*/
	
;
static caddr_t			/* buffer adresses		*/
	g_buff_adr[MAXBUFFS]
;

typedef struct {
        int
   	base,
     	irq,
  	channels,
     	format,      /* format der Daten AFMT_U8 oder AFMT_S16_LE, wird eigentlich nicht verwendet */  
   	bytes,       /* Zahl der Bytes, wichtig fr Ein/Ausgabe und DSP_SETFMT */
     	inputsource,
       	direction;  /* 1 fr Ausgabe */
        unsigned int	
	reg_2,
	speed,
	reg_akt;
}
audio16_info;

void static audio16_reset(void);

audio16_info dev_info;

/*
 *------------------------------------------------------
 * SetChannelStatus - Setzt Kanalstatusdaten des Senders
 *------------------------------------------------------
 */

static void SetChannelStatus (audio16_info *devc, unsigned long data, int internal_control)
{
    int i;
    unsigned int reg;
    reg = devc->reg_akt;
    outw( reg, io_comand(devc));
    reg &= ~CLD;
    outw( reg, io_comand(devc));
  
    for (i = 0; i < 34; i++)
    {
        if ((data & 0x80000000) || (i == 33 && internal_control))
    	    reg |= CDO;
        outw( reg | CCK, io_comand(devc));
        outw( reg      , io_comand(devc));
        reg &= ~CDO;
        data <<=1;
    }
    outw( devc->reg_akt, io_comand(devc));
}
     
/*
 *----------------------------------------------------------
 * SetSampleRate - Setzt Abtastrate, falls nicht im Pll-Mode
 *----------------------------------------------------------
 */ 

static int SetSampleRate (audio16_info *devc, int speed, int direction)
{
    unsigned long data;
    
    switch (speed)
    {
        case 32000:
            devc->speed = 32000;
    	    data = ChannelStatus32kHz;
    	    devc->reg_2 = direction ? default32 : defaultPLL;
    	    break;
        case 48000:
            devc->speed = 48000;
    	    data = ChannelStatus48kHz;
    	    devc->reg_2 = direction ? default48 : defaultPLL;
            break;
        case 44100:
            devc->speed = 44100;
            data = ChannelStatus44kHz;
            devc->reg_2 = direction ? default44 : defaultPLL;
            break;
        default:
            devc->speed = speed;  /* So tun, als ob 8kHz Abtastrate untersttzt wird, damit Software keine Fehler meldet */
    	    data = ChannelStatus44kHz;
    	    devc->reg_2 = direction ? default44 : defaultPLL;
            break;
    }
    if (devc->inputsource) 
  	devc->reg_2 |= Inp;
    devc->reg_akt = devc->reg_2;
    outw (devc->reg_akt, io_comand(devc));
    { 
        SetChannelStatus( devc, data, FALSE);
        SetChannelStatus( devc, 0, TRUE);
    }
    return speed;
}


/*
 *-------------------------------------------------------------------------
 * SetupTransfer - Started Ein-/Ausgabe durch ODER verknpfen des aktuellen
 * Registers mit dem jeweiligem Startwert
 *-------------------------------------------------------------------------
 */
 
static void SetupTransfer (audio16_info *devc)
{
    if (devc->direction) 
    {
        devc->reg_akt |= (devc->channels == 2) ? StereoOut : MonoOut;
        outw (devc->reg_akt, io_comand(devc));        
    }
    else
    {
        outw (devc->reg_akt & ~CounterCLR, io_comand(devc));
        devc->reg_akt |= (devc->channels == 2) ? StereoIn : MonoIn;  
        outw (devc->reg_akt, io_comand(devc));
    }
}

/*
 *-----------------------------------------------------------------------
 * StopTransfer - Stoppt die Ein-/Ausgabe durch kopieren des Registers 2,
 * das die Belegung fr die gestoppte Schaltung enthlt, in das Register.
 * Setzt Blockzhler zurck (bei started = 2 wird Schaltung gestartet.)
 *-----------------------------------------------------------------------
 */
 
static void StopTransfer (audio16_info *devc)
{
    devc->reg_akt = devc->reg_2;
    outw (devc->reg_akt, io_comand(devc));
}

/*
 *--------------------------------------
 * ResetFifo - Gibt Reset Impuls an Fifo
 *--------------------------------------
 */
 
static void ResetFifo (audio16_info *devc)
{
    outw (devc->reg_akt & ~RESET, io_comand(devc));
    outw (devc->reg_akt, io_comand(devc));
}

/*
 *--------------------------------------------------------
 * EnableInterrupt - Gibt Interupterzeugung auf Karte frei
 *--------------------------------------------------------
 */
 
static void EnableInterrupt (audio16_info *devc)
{
    devc->reg_akt |= IntE;
    outw (devc->reg_akt , io_comand(devc));
}

/*
 *------------------------------------------------------
 * DisableInterrupt - Stoppt Interupterzeugung auf Karte
 *------------------------------------------------------
 */
 
static void DisableInterrupt (audio16_info *devc)
{
    devc->reg_akt &= ~IntE;
    outw (devc->reg_akt , io_comand(devc));
}

/*
 *---------------------------------------------------------------------------
 * SetSampleSize - Zur Wahrung der Kompatibiltt untersttze ich auch 8 - Bit
 *---------------------------------------------------------------------------
 */
 
static int SetSampleSize (audio16_info *devc, int arg)
{
    if (arg & AFMT_S16_LE)
    {
        devc->format = AFMT_S16_LE;
        devc->bytes = 2;
        printk ("16 Bit \n");
        return (arg & AFMT_S16_LE);
    }
    else if (arg & AFMT_U8)
    {
        devc->format = AFMT_U8;
        devc->bytes = 1;
        printk ("8 Bit \n");
        return (arg & AFMT_U8);
    }
    else
    {
        devc->format = AFMT_U8;
        devc->bytes = 1;
        printk ("Default: 8 Bit \n");
        return (AFMT_U8);
    }
} 
 
/*
 *---------------------------------------------------------------
 * SetnChannels - Legt die Zahl der Kanle fest, Mono oder Stereo
 *---------------------------------------------------------------
 */
 
static int SetnChannels (audio16_info *devc, int arg)
{
    if (arg != 1 && arg != 2)
        arg = devc->channels;
   
    devc->channels = arg;
    return arg;
}  


/*
 *-------------------------------------------------------
 * audio16_output_block - Treiberfunktion startet Ausgabe
 *-------------------------------------------------------
 */
 
static void audio16_output_block ( char *buf, int count)
{
    int i;
    unsigned short x = 0;
    audio16_info *devc = &dev_info;
 
    if (devc->bytes == 2) 
    {
        count >>= 1; 
        for (i = 0; i < count; i++)
        {
            outw ( ((unsigned short *) buf) [i], io_data(devc));
        }
    }
    else
    {
        for (i = 0; i < count; i++)
        {
            x = ((unsigned char *) buf) [i];
            x <<= 8;
            x ^= 0X8000; 
            outw ( x, io_data(devc));
        } 
    }
}

/*
 *------------------------------------------------------
 * audio16_start_input - Treiberfunktion startet Eingabe
 *------------------------------------------------------
 */
 
static void audio16_start_input ( char *buf, int count)
{
    int i;
    unsigned short x = 0;
    audio16_info *devc = &dev_info;
    
    {
        if (devc->bytes == 2)
        {
            count >>= 1;
            for (i = 0; i < count; i++)
            {
                ((unsigned short*) buf) [i] = inw ( io_data(devc));      
            }
        }
        else
        {
            for (i = 0; i < count; i++)
            {
                x = inw ( io_data(devc));
                x ^= 0x8000;
                x >>= 8;   
                ((unsigned char*) buf) [i] = x;
            }
        }     
    }
}



/*
 *------------------------------------------------------------------------------------
 * audio16_ioctl - Treiberfunktion z.B. fr Setzen der Sample-Rate und Zahl der Kanle
 *------------------------------------------------------------------------------------
 */
 
int
audio_ioctl (int dev, struct fileinfo *file, unsigned int cmd, caddr_t arg, int local)
{
  audio16_info	*devc = &dev_info;
  int arg2 = get_fs_long ((long*) arg);
    
  printk("audio16_ioctl(dev=%d, cmd=0x%x, arg=0x%x) \n", dev, cmd, arg2);
  
  if (isnot(INSTALLED) && isnot(OPENED))
  {
      printk("ioctl: not installed and not opened \n"); 
      return -ENODEV;
  }
  
  if (!(dev & 0x0f & (SND_DEV_DSP | SND_DEV_DSP16 | SND_DEV_AUDIO)))
  {
      printk("ioctl: no audio dev \n");
      return -ENXIO;
  } 
     
  switch (cmd)
    {
    case SNDCTL_DSP_SYNC:
      DEB(printk("cmd: SNDCTL_DSP_SYNC \n"));
      return 0;
      
    case SNDCTL_DSP_POST:
      printk("cmd: SNDCTL_DSP_POST \n");
      return 0;
      
    case SNDCTL_DSP_RESET:
      audio16_reset();
      DEB(printk("cmd: SNDCTL_DSP_RESET \n"));
      return 0;
      break;
      
    case SNDCTL_DSP_GETFMTS:
      printk("cmd: SNDCTL_DSP_GETFMTS \n");
      return 0;
      
    case SNDCTL_DSP_GETISPACE:
      printk("cmd: SNDCTL_DSP_GETISPACE \n");
      return 0;
      
    case SNDCTL_DSP_GETOSPACE:
      printk("cmd: SNDCTL_DSP_GETOSPACE \n");
      return 0;
      
    case SNDCTL_DSP_NONBLOCK:
      printk("cmd: SNDCTL_DSP_NONBLOCK \n");
      return 0;
      
    case SNDCTL_DSP_GETCAPS:
      printk("cmd: SNDCTL_DSP_GETCAPS \n");
      return 0;
    
    case SNDCTL_DSP_GETBLKSIZE:
      printk("cmd: SNDCTL_DSP_GETBLKSIZE \n");
      return snd_ioctl_return((int *) arg, BUFFSIZE_IN_BYTES);
      
    case SOUND_PCM_WRITE_RATE:
      printk("cmd: SOUND_PCM_WRITE_RATE \n");
      if (local)
        return SetSampleRate (devc, (int) arg, devc->direction);
      return snd_ioctl_return ((int*) arg, SetSampleRate (devc, get_fs_long ((long*) arg), devc->direction));
      
    case SOUND_PCM_READ_RATE:
      printk("cmd: SOUND_PCM_READ_RATE \n");
      if (local)
        return devc->speed;
      return snd_ioctl_return ((int*) arg, devc->speed);
      
    case SNDCTL_DSP_STEREO:
      printk("cmd: SNDCTL_DSP_STEREO \n");
       
      if (local)
        {
          return devc->channels-1;
          devc->channels = (int) arg +1;
        }
      devc->channels = get_fs_long ((long*) arg) +1;
      return snd_ioctl_return ((int*) arg, devc->channels-1);
       
    case SOUND_PCM_WRITE_CHANNELS:
      printk("cmd: SOUND_PCM_WRITE_CHANNELS \n");
      if (local)
        return SetnChannels (devc, (int) arg); 
      return snd_ioctl_return ((int*) arg, SetnChannels (devc, get_fs_long ((long*) arg)));
           
    case SOUND_PCM_READ_CHANNELS:
      printk("cmd: SOUND_PCM_READ_CHANNELS \n");
      if (local)
        return devc->channels;
      return snd_ioctl_return ((int*) arg, devc->channels);
        
    case SNDCTL_DSP_SETFMT:
      printk("cmd: SNDCTL_DSP_SETFMT \n");
      if (local)
        return SetSampleSize (devc, (int) arg);
      return snd_ioctl_return ((int*) arg, SetSampleSize(devc, get_fs_long ((long*) arg)));
              
    case SOUND_PCM_READ_BITS:
      printk("cmd: SOUND_PCM_READ_BITS \n");
      if (local)
        return devc->format;
      return snd_ioctl_return ((int*) arg, devc->format);
  
    default: return -EINVAL;
    }
  return -EINVAL;
}





/*
 *-------------------------------------------------------------------------------------
 * audio16_init - Interrupt anfordern, Adressraum reservieren, Variablen initialisieren
 * Abtastrate und Kanalstatus initialisieren
 *-------------------------------------------------------------------------------------
 */ 

void audio_init (void)
{
    audio16_info *devc = &dev_info;
 
    m_driver_state = 0;
    devc->irq = IRQ_LEVEL;
    devc->base = IO_BASE;
    devc->channels = 2;
    devc->format = AFMT_S16_LE;
    devc->bytes = 2;
    devc->inputsource = INPUTSOURCE;  /* bei mir ist nur Eingang 2 bestckt!!! */
    devc->direction = 1;
    devc->speed = 0;
    devc->reg_akt = default44;
    devc->reg_2 = default44; 
     
    request_region (devc->base, 0x08, driver_name); 
    
    SetSampleRate (devc, 44100, DefaultDirektion);
       
    if (devc->irq > 0) 
    {
        if (snd_set_irq_handler (devc->irq, 
        			   audio_intr,
        			   driver_name, 
        			   0) < 0)
        {
            printk ("audio16: IRQ in use \n");
        }
    }   
    sprintf (driver_name, driver_type);
    conf_printf (driver_name, devc->base, devc->irq,-1,-1);
    clr(STARTEDMSND);
    set(INSTALLED);	    
    ResetFifo (devc);    
}

/*
 *-------------------------------------------------
 * audio16_unload - Adressbereich und IRQ freigeben
 *-------------------------------------------------
 */

void audio_unload (void)
{
  audio16_info *devc = &dev_info;
  if (devc != NULL)
  {
    release_region (devc->base, 0x08);
    if (devc->irq > 0)
    {
      snd_release_irq (devc->irq);
    }
  }
  else
     printk ("audio16: Can't find device to be unloaded \n");
}


static void Buff_queue_to_fifo(void)
{
	int i;
        audio16_info *devc = &dev_info;

	for (i = 0; i < BUFFS_PER_BANK; i++) {
		if (g_buff_state[g_intserv_buff_idx] == EMPTY)
		{    
                    DisableInterrupt(devc);  		     
		    printk ("audio16: Playing and queue empty \n");
	        }
		audio16_output_block(g_buff_adr[g_intserv_buff_idx], BUFFSIZE_IN_BYTES);
		
		g_buff_state[g_intserv_buff_idx++] = EMPTY;
		g_intserv_buff_idx %= g_buffs;
	}
}


static void Fifo_to_buff_queue(void)
{
	int i;

	for (i = 0; i < BUFFS_PER_BANK; i++) {
		if (g_buff_state[g_intserv_buff_idx] == FULL)
                    printk("audio16: Recording overrun \n");

                audio16_start_input(g_buff_adr[g_intserv_buff_idx], BUFFSIZE_IN_BYTES);
		
		g_buff_state[g_intserv_buff_idx++] = FULL;
		g_intserv_buff_idx %= g_buffs;
	}
}



static void startplay_MSND(void)
{
	audio16_info *devc = &dev_info;
	if (isnot(STARTEDMSND)) {
		g_intserv_buff_idx = 0;
		SetSampleRate(devc, devc->speed, devc->direction); 
                ResetFifo(devc);
		Buff_queue_to_fifo();
		Buff_queue_to_fifo();
		EnableInterrupt(devc);
		SetupTransfer(devc);
		set(STARTEDMSND);
		DEB(printk("started playing \n"));
	}
}

static void startrec_MSND(void)
{
        audio16_info *devc = &dev_info;
	if (isnot(STARTEDMSND)) {
                SetSampleRate(devc, devc->speed, devc->direction);
                ResetFifo(devc);
                SetupTransfer(devc);
		set(STARTEDMSND);
		DEB(printk("started recording \n"));
	}
}

static void stop_MSND(void)
{
	unsigned long flags;
        audio16_info *devc = &dev_info;
	save_flags(flags);
	cli(); 
	StopTransfer(devc);
	clr(STARTEDMSND);
	set(STOPPEDMSND);
	restore_flags(flags); 
	DEB(printk("stopped \n"));
}

/*
 *
 *	buffer-queue handling on MultiSound side invoked by interrupt 
 *	-------------------------------------------------------------
 *
 */

static void int_rout(void)
{

        audio16_info *devc = &dev_info;
        int flags;
        
	if (is(STARTEDMSND)) 
        {
            if (devc->direction)
            {
                if ((inw (io_comand(devc)) & EmptyFlag) == 0)
                {
                    devc->reg_akt &= ~On;
                    outw (devc->reg_akt, io_comand(devc));
                    printk ("audio16: playing and Fifo Empty \n");  
                    stop_MSND();
                } 
                outw (devc->reg_akt & ~IntE, io_comand(devc));
                Buff_queue_to_fifo();
            }
            else
            {
                outw (devc->reg_akt & ~IntE, io_comand(devc));
                Fifo_to_buff_queue();       
            }
            outw (devc->reg_akt, io_comand(devc));
        }
	save_flags (flags);
	cli();
	if (sleep_flag.mode & WK_SLEEP)
        {
            sleep_flag.mode = WK_WAKEUP;
	    module_wake_up (&sleeper);
	}
	restore_flags (flags);
}


/*
 *
 *	buffer-queue handling on driver entry side
 *	------------------------------------------
 *
 */

		
static int wait_for_buff_to_be(int state, int index)
{
	int err = 0;
	unsigned long flags;

	if (g_buff_err_ctr || g_MSNDbank_err_ctr || is(STOPPEDMSND)) {
		stop_MSND();
		return(EIO);
	}	
	while (g_buff_state[index] != state) {
		if (state == FULL)
			startrec_MSND();
		if (state == EMPTY)
			startplay_MSND();
		/*
		 * enter CRITICAL/ATOMIC section ....
		 * (sleep only if we can be sure we'll be raised)
		 */
		
		save_flags(flags);
		cli(); 
		if (g_buff_state[index] != state) {
			
			sleep_flag.mode = WK_SLEEP;
						
			module_interruptible_sleep_on(&sleeper);
						
			sleep_flag.mode &= ~WK_SLEEP;
			
			if (current_got_fatal_signal())
 				err = EINTR;
			if (g_buff_err_ctr || g_MSNDbank_err_ctr) 
				err = EIO;
		}
		restore_flags(flags); 
		
		/*
	 	 * ... leave CRITICAL/ATOMIC section 
	 	 */
		
		if (err) {
			stop_MSND();
			return(err);
		}
	}
	return(0);
}

static int read_buff_queue(char *dest,int count)
{
	char *buff;
	int err, space, size, offset = 0;
        audio16_info *devc = &dev_info;

	devc->direction = 0;
	
	if (count < 0)
		return(EFAULT);
	while (count > 0) {
		g_rwclient_buff_idx %= g_buffs;
		err = wait_for_buff_to_be(FULL, g_rwclient_buff_idx);
		if (err)
		    return(err);
		buff = g_buff_adr[g_rwclient_buff_idx];
		size = devc->bytes*BUFFSIZE_IN_BYTES/2;
		space = size - g_rwclient_buff_pos;
		if (count < space) {
			memcpy_tofs(&((dest)[offset]), (buff + g_rwclient_buff_pos), count);  
			g_rwclient_buff_pos += count;
			count = 0;
		} else {
			memcpy_tofs(&((dest)[offset]), (buff + g_rwclient_buff_pos), space);
			g_buff_state[g_rwclient_buff_idx++] = EMPTY;
			g_rwclient_buff_pos = 0;
			count -= space;
			offset += space;
		}
	}
	return(0);
}

static int write_buff_queue(const char *source, int count)
{
	char *buff;
	int err, space, size, offset = 0;
        audio16_info *devc = &dev_info;
        
	devc->direction = 1;
	
	if (count < 0)
		return(EFAULT);
	while (count > 0) {
		g_rwclient_buff_idx %= g_buffs;
		err = wait_for_buff_to_be(EMPTY, g_rwclient_buff_idx);
		if (err)
		    return(err);
		buff = g_buff_adr[g_rwclient_buff_idx];
		size = devc->bytes*BUFFSIZE_IN_BYTES/2;
		space = size - g_rwclient_buff_pos;
		if (count < space) {
			memcpy_fromfs( (buff + g_rwclient_buff_pos), &((source)[offset]), count);
			g_rwclient_buff_pos += count;
			count = 0;
		} else {
			memcpy_fromfs( (buff + g_rwclient_buff_pos), &((source)[offset]), space);
			g_buff_state[g_rwclient_buff_idx++] = FULL;
			g_rwclient_buff_pos = 0;
			count -= space;
			offset += space;
		}
		set(WRITTEN);
	}
	return(0);
}

static int write_zero_completed_buff_to_queue(void)
{
	char *buff, *p, *e;
	int size, err;
	audio16_info *devc = &dev_info; 

	g_rwclient_buff_idx %= g_buffs;
	err = wait_for_buff_to_be(EMPTY, g_rwclient_buff_idx);
	if (err)
	    return(err);
	buff = g_buff_adr[g_rwclient_buff_idx];
	
	size = devc->bytes*BUFFSIZE_IN_BYTES/2;
	
	if ((size - g_rwclient_buff_pos) > 0) {
		p = buff + g_rwclient_buff_pos;
		e = buff + size;
		do {
			*p++ = 0;
		} while (p != e);
	}
	
	g_buff_state[g_rwclient_buff_idx++] = FULL;
	g_rwclient_buff_pos = 0;
	set(WRITTEN);
	return(0);
}

static int flush_buff_queue(void)
{
	int err, i, watch;
	/*
	 * check if we were not written or MultiSound
	 * isn't running anyway
	 */
	if (isnot(WRITTEN) || is(STOPPEDMSND)) {
		stop_MSND();
		return(0);
	}
	watch = (g_rwclient_buff_idx +2*BUFFS_PER_BANK) % g_buffs;
	/*
	 * (MultiSound is still running and was written)
	 * The current buff might be empty or left partly filled
	 * with relevant data (see write_buff_queue()). We consider
	 * this buff the last that MUST be played. To be sure to have
	 * it played we have to stuff some zeroed buffs into the queue. 
	 * Then we'll watch a buffer TWO BANKS away from current
	 * buff to become empty. We'll be notified by wakeup when it got
	 * emptied via int_rout. At this time MultiSound has finished playing
	 * the bank containing our last relevant buffer and has just
	 * started playing a first irrelevant bank (containing zeros).
	 * We are only notified of the watch buffer being emptied when
	 * int_rout() has already moved data onto a second irrelevant bank.
	 * Now we can safely halt MultiSound. In order keep not to detect
	 * an overrun condition in int_rout() we have to have another 
	 * three zeroed buffers waiting behind.
	 *
	 * Summary:	Assume we have 4 buffs fitting on a bank, than
	 *		stuff current buff padded with zeros and another 11
	 *		zero buffs onto the que. Thats 12 buffs to be pushed.
	 *		Wait until the 9th got emptied, then stop MultiSound.
	 *		Easy, eh?
	 *
	 */
	
	for (i = 3*BUFFS_PER_BANK; i > 0; i--)
	{
	    err = write_zero_completed_buff_to_queue();
	    if (err)
		return(err);
	}

	err = wait_for_buff_to_be(EMPTY, watch);
	if (err) {
		return(err);
	}
	stop_MSND();
	return(0);
}

static void free_buffs_until(int badindex) 
{
	int i;
	for (i = 0; i < badindex; i++) 
		kfree(g_buff_adr[i]);
}

static int allocate_buffs(int n) 
{
	int i;
	/*
	 * Allocate buffers one be one.
	 * Should we fail once return already allocated buffs
	 * to avoid mem leakage
	 */
 	for (i = 0; i < n; i++) {
	    if ((g_buff_adr[i] = kmalloc(BUFFSIZE_IN_BYTES,GFP_KERNEL)) == NULL) {
		    printk("ERROR: not enough memory for MultiSound \n");
		    free_buffs_until(i);
		    return(-ENOMEM);
	    }
	}
	printk(" %d-buffers allocated \n", n+1);
	return(0);
}

/*
 *
 * SUMMARY: calls (as defined before) to implement buffered MultiSound driver
 * --------------------------------------------------------------------------
 *
 *	static void stop_MSND()
 *	static void int_rout()
 *
 *	static int allocate_buffers(int n) 
 *	static void free_buffers_until(int badindex) 
 *	static int read_buff_queue(int dest, int count)
 *	static int write_buff_queue(int source, int count)
 *	static int flush_buff_queue()
 *	static int check_transm_err()
 *
 */
	
/*
 *
 *	entry points for SysV386 specific driver
 *	----------------------------------------
 *
 */


void audio_intr(int irq, void *dev_id, struct pt_regs *dummy)
{
	if (isnot(INSTALLED))
		return;
	DEB(printk("ISR routine \n"));
	int_rout();
}





int audio_read(int dev, struct fileinfo *file, char *buf, int count)
{
	int err;

        DEB(printk("audio read \n"));
        	
	if (isnot(INSTALLED) && isnot(OPENED)) {
		return 0;
	}
	
	
	if (!(err = read_buff_queue(buf, count))) {
		g_recbytes_ctr += count;
	} else {
		stop_MSND();
 		count = 0;
	}
	return count;
}

int audio_write(int dev, struct fileinfo *file, const char *buf, int count)
{
	int err;

        DEB(printk("audio write \n"));

	if (isnot(INSTALLED) && isnot(OPENED)) {
		return 0;
	}
	
	
	if (!(err = write_buff_queue(buf, count))) {
		g_playbytes_ctr += count;
	} else {
		count = 0;
		stop_MSND();
	}
        return count;
}

int audio_select(int dev, struct fileinfo *file, int sel_type, select_table_handle *wait)
{
    printk("audio select \n");	
    return 0;
}

/*
 *--------------------------------------------------------
 * audio16_reset - Treiberfunktion, setzt Schaltung zurck
 *--------------------------------------------------------
 */
 
static void
audio16_reset (void)
{
  audio16_info	*devc = &dev_info;
  flush_buff_queue();
  StopTransfer (devc);  
  ResetFifo (devc);
  SetSampleRate (devc, devc->speed, devc->direction);
}

/*
 *----------------------------------------------
 * audio16_open - Die Open-Funktion des Treibers
 *----------------------------------------------
 */

int
audio_open (int dev, struct fileinfo *file)
{
  audio16_info  *devc = &dev_info;
  unsigned long	flags;
  int err;
  int i; 
  
  if (dev < 0) return -ENXIO;  
  save_flags (flags);
  cli ();  
 
  if (is(OPENED) )
  
  {
     restore_flags (flags);
     printk ("audio16: Already opened \n");
     return -EBUSY;
  }
  restore_flags (flags);
  clr(WRITTEN|STARTEDMSND|STOPPEDMSND);
  sleep_flag.mode = WK_NONE;

  if (file->mode == OPEN_READ)
  {
      devc->direction = 0;
  }
  else if (file->mode == OPEN_WRITE)
  {
      devc->direction = 1;
  }

  g_buffs = MAXBUFFS;    
  
  for (i = 0; i < g_buffs; i++)
  {
      g_buff_state[i] = EMPTY;
      g_buff_adr[i] = NULL;
  }

  g_buff_err_ctr = 0;
  g_MSNDbank_err_ctr = 0;
  g_intserv_buff_idx = 0;
  g_rwclient_buff_idx = 0;
  g_rwclient_buff_pos = 0;
  g_recbytes_ctr = 0;
  g_playbytes_ctr = 0;
  err = allocate_buffs(g_buffs); 
  if (err != 0) return err;
  set(OPENED);
  printk("sound driver opened \n"); 
  
  StopTransfer (devc);  
  ResetFifo (devc);
  SetSampleRate (devc, devc->speed, devc->direction);
  
  return 0;
}   





/*
 *----------------------------------------------
 * audio16_close - Treiberfunktion zum Schlieen
 *----------------------------------------------
 */
 
void
audio_release (int dev, struct fileinfo *file)
{
  unsigned long	flags;
 
  audio16_reset();
   
  free_buffs_until(g_buffs);

  clr(OPENED|WRITTEN|STARTEDMSND|STOPPEDMSND);

  save_flags (flags);
  cli ();
  sleep_flag.mode = WK_NONE;
  restore_flags (flags);

  printk("sound driver closed \n");
}
