// serialEuroDomest - replaces the Type 972060 Remote Control (JR C15c).
// a 2008-8 433 MHz transmitter breakout board should be connected to pin 10

unsigned long On1 = 11473455;
unsigned long On2 = 11473453;
unsigned long On3 = 11473451;
unsigned long On4 = 11473447;
unsigned long Off1 = 11473454;
unsigned long Off2 = 11473452;
unsigned long Off3 = 11473450;
unsigned long Off4 = 11473446;

#include <RCSwitch.h>

RCSwitch mySwitch = RCSwitch();
#define DELAY 250L

#define SERIALBUFSIZE         50
char serialBuffer[SERIALBUFSIZE];
byte setBufPointer = 0;

void setup() {
  Serial.begin(9600);
 
  mySwitch.enableTransmit(10);

  Serial.println(F("Arduino RC-switch started."));
}

void loop() {
  commandCollector();
}

void commandCollector() {
  if (Serial.available() > 0) {
    int inByte = Serial.read();
    switch(inByte) {
    case '.':
//    case '\r':
    case '\n':
      commandInterpreter();
      clearSerialBuffer();
      setBufPointer = 0;
      break;
    case '\r':
      break;  // ignore carriage return
    default:
      serialBuffer[setBufPointer] = inByte;
      setBufPointer++;
      if (setBufPointer >= SERIALBUFSIZE) {
        Serial.println("Serial buffer overflow. Cleanup.");
        clearSerialBuffer();
        setBufPointer = 0;
      }
    }
  }
}

void commandInterpreter() {
  byte bufByte = serialBuffer[0];
  
  switch(bufByte) {
    case 'A':
    case 'a':
      aan();
      break;
    case 'U':
    case 'u':
      uit();
      break;
    case 'H':
    case 'h':
    case '?':
      Serial.println(F("Usage:"));
			Serial.println(F("       An - Switch channel (1,2,3,4,A(ll)) on"));
			Serial.println(F("       Un - Switch channel (1,2,3,4,A(ll)) off"));
      Serial.println(F("       H  - This help text"));
      break;

    default:
      Serial.print(bufByte);
      Serial.print(" ");
      Serial.println("unsupported");
      return;
  }
}

void clearSerialBuffer() {
  byte i;
  for (i = 0; i < SERIALBUFSIZE; i++) {
    serialBuffer[i] = 0;
  }
}

void aan() {
	if (setBufPointer <= 1) return;
  int channel = serialBuffer[1];
	switch(channel) {
		case '1':
		  mySwitch.send(On1, 24);
			break;
		case '2':
		  mySwitch.send(On2, 24);
			break;
		case '3':
		  mySwitch.send(On3, 24);
			break;
		case '4':
		  mySwitch.send(On4, 24);
			break;
		case 'A':
    case 'a':
		  mySwitch.send(On1, 24);
      delay(DELAY);
		  mySwitch.send(On2, 24);
      delay(DELAY);
		  mySwitch.send(On3, 24);
      delay(DELAY);
		  mySwitch.send(On4, 24);
			break;
		default:
		  return;
	}
}

void uit() {
	if (setBufPointer <= 1) return;
  int channel = serialBuffer[1];
	switch(channel) {
		case '1':
		  mySwitch.send(Off1, 24);
			break;
		case '2':
		  mySwitch.send(Off2, 24);
			break;
		case '3':
		  mySwitch.send(Off3, 24);
			break;
		case '4':
		  mySwitch.send(Off4, 24);
			break;
		case 'A':
    case 'a':
		  mySwitch.send(Off1, 24);
      delay(DELAY);
		  mySwitch.send(Off2, 24);
      delay(DELAY);
		  mySwitch.send(Off3, 24);
      delay(DELAY);
		  mySwitch.send(Off4, 24);
			break;
		default:
		  return;
	}
}

