// rcSwitchNanoBox3

$fn = 32;
include <camferCube.scad>

pcbLength = 43.5; // length Arduino Nano
pcbWidth  = 19.0; // width Tmit 433 MHz R433 board
icLength = pcbLength + 0.25;  // internal case length
icWidth  = pcbWidth + 0.5;  // internal case width
pcbThick = 1.6;
boardHeight = 14.0;
wall = 1.5;
ridge = 1.5;
usbBWidth = 8.0;
usbBHeight = 3.5;

//
module baseBox() {
    difference() {
    //    cube([icLength + 2 * wall, icWidth + 2 * wall, boardHeight + 2 * wall]);
        translate([icLength/2 + wall, icWidth/2 + wall, boardHeight/2 + wall]) 
            camferCube([icLength + 2 * wall, icWidth + 2 * wall, boardHeight + 3 * wall], 2.0);
        //
        translate([-0.1, -wall/2, boardHeight + 2.5]) cube([icLength + 3 * wall, icWidth + 3 * wall, 10]);
        // pcb and solder side space
        translate([wall + 0, wall + ridge, wall]) cube([icLength - 1 * ridge, icWidth - 2 * ridge, boardHeight + wall + 0.1]);
        translate([wall, wall, wall + ridge]) cube([icLength, icWidth, boardHeight + wall + 0.1]);
        // USB-B hole
        translate([-0.01, (icWidth + 2 * wall)/2 - usbBWidth/2, wall + ridge + pcbThick]) 
            cube([wall + 0.2, usbBWidth, usbBHeight]);
        // lid ridges
        translate([(icLength + 2 * wall)/2, wall, boardHeight]) rotate([45, 0, 0]) cube([icLength - 5, 1, 1], true);
        translate([(icLength + 2 * wall)/2, icWidth+wall, boardHeight]) rotate([45, 0, 0]) cube([icLength - 5, 1, 1], true);
    }
}

translate([0, 0, 0.7]) baseBox();
//translate([icLength/2 + wall, -icWidth + 2 * wall, 5]) boxLid();

// Arduino nano
//translate([wall, wall + 0.5, wall + ridge]) color("blue") cube([pcbLength, 18.0, pcbThick]);
// Tx433_2008-8
//translate([wall, wall + 0.5, wall + ridge + 6]) color("green") cube([19.0, pcbWidth, pcbThick]);

module boxLid() {
    difference() {
        camferCube([icLength + 2 * wall, icWidth + 2 * wall, 10], 2.0);
        translate([0, 0, 4]) cube([icLength + 5, icWidth + 5, 15], true);
        translate([icLength/2 - 16.0, 0, -5.02]) cylinder(d = 5.5, h = wall + 0.03);
    }
    // 
    difference() {
        translate([0, 0, -3]) cube([icLength, icWidth, 2.0], true);
        translate([0, 0, -3]) cube([icLength-wall*2, icWidth-wall*2, 2.02], true);
    }
    difference() {
        translate([0, 0, -1]) cube([icLength-wall*2, icWidth, 2.0], true);
        translate([0, 0, -1]) cube([icLength-wall*2 + 0.02, icWidth-wall*2, 2.02], true);
    }
    // ridges
    translate([0, icWidth/2, -0.9]) rotate([45, 0, 0]) cube([icLength - 5, 1, 1], true);
    translate([0, -icWidth/2, -0.9]) rotate([45, 0, 0]) cube([icLength - 5, 1, 1], true); 
    
}
