SUPERC 	ORG	5200H	;*** SUPERCOP ***
 START	CALL	INTRO
 	LD	A,(RECSL)
 	CP	1
 	JP	Z,COMD
 	LD	A,0
 	LD	(RECSL),A
 	JP	COMD
 ;DAN L. ROBINSON, 1625 HIGGINS WAY, PACIFICA CA,94044
 BUF	DEFS	256
 AMSG	DEFM	'INPUT DISC FILESPEC'
 	DEFB	0DH
 CASMSG	DEFM	'WHICH CASSETTE IS TO BE USED (1 OR 2)?'
 	DEFB	0DH
 CMSG	DEFM	'INPUT COMMAND TO BE EXECUTED ON EXIT'
 	DEFB	0DH
 TWMSG	DEFM	'INSERT TAPE AND PRESS RECORD & PLAY.  <ENTER> '
 	DEFB	0DH
 NMSG	DEFM	'INPUT DOS-COMMAND (NEWDOS 80 ONLY)'
 	DEFB	0DH
 ND2MSG	DEFM	'PRESS ANY KEY TO RETURN TO SUPERCOP'
 	DEFB	03H
 MSGCOM	DEFM	'  D   LOAD DISK FILE                B   ENTER DEBUG '
 	DEFB	0DH
 MSGC1	DEFM	'  W   WRITE TO DISK                 C   COMMAND ON EXIT '
 	DEFB	0DH
 MSGC2	DEFM	'  T   LOAD TAPE FILE                E   EXIT TO DOS '
 	DEFB	0DH
 MSGC3	DEFM	'  P   WRITE TO TAPE                 N   NEWDOS-80 DOS-CALL'
 	DEFB	0DH
 MSGC4	DEFM	'  S   LOAD SPECIAL TAPE             R   RECORDER SELECT '
 	DEFB	0DH
 MSGC5	DEFM	'  H   HARD COPY                     A   ADJUST BUFFER '
 	DEFB	0DH
 OMSG	DEFM	'PROGRAM IS OFFSET.         NORMAL LOAD '
 O1MSG	DEFM	'XXXX'
 O2MSG	DEFM	' - '
 O3MSG	DEFM	'XXXX'
 O4MSG	DEFM	', ENTRY = '
 O5MSG	DEFM	'XXXX'
 	DEFB	03H
 TYPEM4	DEFM	'DATA FILE'
 	DEFB	0DH
 TYPEM2	DEFM	'EDTASM SOURCE FILE '
 	DEFB	0DH
 TYPEM3	DEFM	'BASIC FILE '
 	DEFB	0DH
 TYPEM1	DEFM	'OBJECT FILE '
 	DEFB	0DH
 TYPEM6	DEFM	'BASIC ASCII FILE'
 	DEFB	0DH
 TYPEM7	DEFM	'ELECTRIC PENCIL FILE'
 	DEFB	0DH
 TMSG	DEFM	'INSERT TAPE & PRESS PLAY.  <ENTER>'
 	DEFB	0DH
 A1MSG	DEFM	'START ADDRESS = '
 A2MSG	DEFM	'XXXX'
 A3MSG	DEFM	'   END ADDRESS = '
 A4MSG	DEFM	'XXXX'
 A5MSG	DEFM	'   ENTRY ADDRESS = '
 A6MSG	DEFM	'XXXX'
 	DEFB	03H
 BMSG	DEFM	'FILE IS IN BUFFER AT LOCATIONS '
 B1MSG	DEFM	'XXXX'
 	DEFM	' TO '
 B2MSG	DEFM	'XXXX.  '
 GRAN	DEFM	'XX GRANS.'
 	DEFB	0DH
 RECSL	DEFS	1H	;STORE RECORDER SELECTION
 BUFEND	DEFS	2H	;STORE BUFFER EOF
 FORMAT	DEFS	1H	;STORE DISC/TAPE FORMAT
 TYPEMK	DEFS	1H	;STORE FILE TYPE
 STADR	DEFS	2H	;STORE START ADDR
 ENDAD	DEFS	2H	;STORE END ADDR
 TRFAD	DEFS	2H	;STORE TRF ADDR
 OFST	DEFS	2H	;STORE OFSET RANGE
 DOFST	DEFS	2	;STORE DISK OFFSET
 OSADR	DEFS	2H	;STORE OFFSET START ADDR
 OEADR	DEFS	2H	;STORE OFFSET END ADDR
 OTADR	DEFS	2H	;STORE OFFSET TRF ADDR
 FILE	DEFS	20H	;STORE FILESPEC
 TFILE	DEFS	7H	;STORE TAPE FILESPEC
 INST	DEFS	2DH	;STORE INPUT
 COMD	CALL	01F8H
 	LD	A,20H
 	LD	(3C3EH),A
 	LD	(3C3FH),A
 	EI
 	LD	A,83H	;PUT BLOCK CURSOR ON SCREEN
 	CALL	0033H
 	LD	A,19H	;LINEFEED
 	CALL	033AH
 KEY	CALL	035BH	;INPUT COMMAND KEY
 	CP	0H
 	JR	Z,KEY
 	CP	42H	;JUMP TO DEBUG
 	JP	Z,440DH
 	CP	43H	;C=COMMAND ON EXIT
 	JP	Z,CMD
 	CP	57H	;W=WRITE TO DISC
 	JP	Z,WRITE
 	CP	45H	;E=EXIT TO DOS
 	JP	Z,402DH
 	CP	52H	;RECORDER SELECT
 	JP	Z,RECSLT
 	CP	44H	;D=INPUT DISCFILE
 	JP	Z,DISK
 	CP	4EH	;N=NEWDOS DOS-CALL
 	JP	Z,NEWDS
 	CP	53H	;LOAD PROBLEM TAPE TO BUFFER
 	JP	Z,PROBLD
 	CP	50H	;P=WRITE TO TAPE
 	JP	Z,TAPWRT
 	CP	54H	;T=TAPE ADDR & LOAD TO BUFFER
 	JP	Z,TAPE
 	CP	41H	;ADD/DELETE BYTES IN BUFFER
 	JP	Z,BUFCHG
 	CP	48H	;HARDCOPY
 	JP	Z,PBF
 	JR	COMD
 TAPWRT	CALL	BOT
 	LD	HL,TWMSG
 	CALL	4467H
 TPWRT1	CALL	035BH
 	CP	0DH
 	JR	Z,TPWRT2
 	JR	TPWRT1
 TPWRT2	DI
 	LD	A,2AH
 	LD	(3C3EH),A
 	LD	A,(RECSL)
 	LD	HL,(BUFEND)
 	LD	DE,TBUF
 	OR	A
 	SBC	HL,DE
 	INC	HL
 	PUSH	HL
 	LD	HL,TBUF
 	CALL	0212H
 	CALL	0287H	;WRITE LEADER & SYNC BYTE
 	POP	DE
 	LD	C,D
 	LD	B,0
 	LD	A,(FORMAT)
 	CP	01
 	JP	Z,DTAPWT
 	LD	A,(TYPEMK)
 	CP	04
 	JP	Z,TDATWT
 TWT1	LD	A,(HL)
 	CALL	0264H
 	INC	HL
 	DJNZ	TWT1
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	DEC	C
 	JP	Z,TWT1B
 	LD	B,0
 	JR	TWT1
 TWT1B	LD	B,E
 TWT1C	LD	A,(HL)
 	CALL	0264H
 	INC	HL
 	DJNZ	TWT1C
 	JP	COMD
 TDATWT	LD	A,(HL)
 	INC	HL
 	CALL	0264H
 	CP	0DH
 	DEC	BC
 	JR	NZ,TDATWT
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	LD	A,D
 	OR	E
 	JP	Z,COMD
 	CALL	0287H	;WRITE LEADER & SYNC BYTE
 	JR	TDATWT
 DTAPWT	LD	A,(TYPEMK)
 	CP	01
 	JP	Z,WSYST
 	CP	04
 	JP	Z,TDATWT	;JUMP FOR DATA FILES
 	CP	03
 	JR	Z,DBWT
 	CP	07
 	JP	Z,DPENWT
 	JP	TWT1
 DPENWT	LD	A,0FFH
 	LD	B,A
 	CALL	0264H
 	LD	C,0
 DPEN1	LD	A,(HL)
 	CALL	0264H
 	INC	HL
 	DEC	DE
 	ADD	A,C
 	LD	C,A
 	DJNZ	DPEN1
 	LD	A,C
 	CALL	0264H
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	LD	A,D
 	CP	0
 	JP	NZ,DPENWT
 	LD	A,E
 	CP	0
 	JP	Z,DPEN3
 	LD	A,E
 	CALL	0264H
 	LD	B,E
 	LD	C,0
 DPEN2	LD	A,(HL)
 	CALL	0264H
 	ADD	A,C
 	LD	C,A
 	INC	HL
 	DJNZ	DPEN2
 	LD	A,C
 	CALL	0264H
 DPEN3	LD	A,0
 	CALL	0264H
 	JP	COMD
 DBWT	INC	HL
 	DEC	B
 	LD	A,0D3H
 	CALL	0264H
 	CALL	0264H
 	CALL	0264H
 	LD	IX,TFILE
 	LD	A,(IX)
 	CALL	0264H
 	JP	TWT1
 TAPE	CALL	ZBUF
 	LD	A,0
 	LD	(FORMAT),A
 	LD	HL,TMSG
 	CALL	4467H
 	CALL	CLRSPC
 	DI		;DISABLE INTERUPTS
 TPLD1	CALL	035BH
 	CP	0DH
 	JR	Z,TPLD2
 	JR	TPLD1
 TPLD2	LD	A,(RECSL)	;INITIALIZE CASSETTE PORT
 	CALL	0212H	;TURN ON CASSETTE
 	LD	HL,TBUF
 	LD	DE,FILE
 	CALL	0296H	;SEARCH FOR LEADER & SYNC BYTE
 	CALL	READ	;READ BYTE
 	CP	55H	;SYST TAPE
 	JR	Z,SYST
 	CP	0D3H
 	JP	Z,BASEDT
 	JP	DATTAP
 SYST	LD	(HL),A
 	INC	HL
 	LD	B,6H
 NAME	CALL	READ	;READ BYTE FROM TAPE
 	LD	(DE),A	;LOAD NAME TO FILESPEC
 	LD	(HL),A	;LOAD NAME TO BUFFER
 	INC	DE
 	INC	HL
 	DJNZ	NAME
 	LD	A,03H
 	LD	(DE),A	;MARK FILESPEC END
 TLOOP	CALL	READ
 	CP	3CH	;BLOC SYNC
 	JR	NZ,TLOOP
 	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	B,A	;BYTE COUNT
 	LD	IX,BYTE
 	LD	(IX),A
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	E,A
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	D,A
 	LD	(OSADR),DE	;TAPE LOAD ADDRESS
 	ADD	A,E
 	LD	C,A	;SAVE FOR CHECKSUM
 NXT	CALL	READ
 	LD	(HL),A
 	INC	HL
 	ADD	A,C
 	LD	C,A
 	DJNZ	NXT
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	CP	C	;CHECKSUM
 	JR	Z,BLINK
 	LD	A,43H	;C ON SCREEN
 	LD	(3C3EH),A	;IN PLACE OF STAR
 BLINK	CALL	022CH	;BLINK STAR
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 TLOOP1	CALL	READ
 	CP	78H	;END OF PROGRAM MARK
 	JR	Z,FIN
 	CP	3CH	;BLOCK SYNC
 	JR	NZ,TLOOP1
 	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	B,A	;BYTE COUNT
 	LD	(IX),A
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	E,A
 	LD	C,A
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	D,A
 	ADD	A,C
 	LD	C,A	;SAVE FOR CHECKSUM
 TLOOP2	CALL	READ
 	LD	(HL),A
 	INC	HL
 	ADD	A,C
 	LD	C,A
 	DJNZ	TLOOP2
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	CP	C	;CHECKSUM
 	JR	Z,BLINK
 	LD	A,43H	;CHECKSUM ERROR
 	LD	(3C3EH),A
 	JR	BLINK
 READ	PUSH	BC
 	PUSH	HL
 	LD	B,08H	;FOR 8 BITS
 READ1	PUSH	BC
 	PUSH	AF
 READ2	IN	A,(0FFH)	;LOOK FOR BIT
 	RLA
 	JR	NC,READ2
 	LD	B,41H	;DELAY LOOP
 READ3	DJNZ	READ3
 	CALL	021EH	;PERFORMS OUT 0FFH
 	LD	B,50H	;DELAY LOOP
 READ4	DJNZ	READ4
 	LD	B,14H	;DELAY LOOP
 READ5	IN	A,(0FFH)
 	DJNZ	READ5
 	LD	B,A
 	POP	AF
 	RL	B
 	RLA
 	PUSH	AF
 	CALL	021EH	;PERFORMS OUT 0FFH
 	POP	AF
 	POP	BC
 	DJNZ	READ1	;GO BACK FOR NEXT BIT
 	POP	HL
 	POP	BC
 	RET
 FIN	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	(OTADR),A	;LSB TRANS ADDR
 	CALL	READ
 	LD	(HL),A
 	LD	(OTADR+1),A	;MSB TRANS ADDR
 	LD	(BUFEND),HL
 	LD	C,(IX)
 	LD	B,0
 	PUSH	DE
 	POP	HL
 	OR	A
 	ADC	HL,BC
 	LD	(OEADR),HL
 	LD	HL,(OSADR)
 	LD	(STADR),HL
 	LD	HL,(OTADR)
 	LD	(TRFAD),HL
 	LD	HL,(OEADR)
 	LD	(ENDAD),HL
 	LD	A,(OSADR)
 	CALL	CONV
 	LD	(A2MSG+2),HL
 	LD	A,(OSADR+1)
 	CALL	CONV
 	LD	(A2MSG),HL
 	LD	A,(OEADR)
 	CALL	CONV
 	LD	(A4MSG+2),HL
 	LD	A,(OEADR+1)
 	CALL	CONV
 	LD	(A4MSG),HL
 	LD	A,(OTADR)
 	CALL	CONV
 	LD	(A6MSG+2),HL
 	LD	A,(OTADR+1)
 	CALL	CONV
 	LD	(A6MSG),HL
 	CALL	BOT
 	LD	HL,TFILE
 	CALL	4467H
 	LD	A,0DH
 	CALL	033AH
 	LD	HL,A1MSG
 	CALL	4467H
 	CALL	PBUF	;PRINT ADDRESSES IN BUFFER
 	LD	A,01
 	LD	(TYPEMK),A
 	LD	HL,TYPEM1
 	CALL	4467H
 	JP	COMD
 BASEDT	LD	(HL),A
 	INC	HL
 	CALL	READ
 	CP	0D3H
 	JP	Z,BASTAP
 	LD	B,6H
 	JR	EDTNM1
 EDTNAM	CALL	0235H
 EDTNM1	LD	(HL),A
 	LD	(DE),A
 	INC	DE
 	INC	HL
 	DJNZ	EDTNAM
 	LD	A,03H
 	LD	(DE),A
 EDTNXT	CALL	READ
 EDTNX1	LD	(HL),A
 	INC	HL
 	CP	0DH
 	JP	NZ,EDTNXT
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	CALL	READ
 	CP	1AH
 	JP	NZ,EDTNX1
 	LD	(HL),A
 	LD	(BUFEND),HL
 	LD	A,2
 	LD	(TYPEMK),A
 	CALL	BOT
 	LD	HL,TFILE
 	CALL	4467H
 	LD	A,0DH
 	CALL	033AH
 	CALL	PBUF
 	LD	HL,TYPEM2
 	CALL	4467H
 	JP	COMD
 BASTAP	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	LD	(DE),A
 	INC	DE
 	LD	A,03H
 	LD	(DE),A
 BASNXT	CALL	READ
 BASNX1	LD	(HL),A
 	INC	HL
 	CALL	READ
 	CP	00
 	JR	NZ,BASNX1
 	LD	(HL),A
 	INC	HL
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	CALL	READ
 	CP	00
 	JR	NZ,BASNX1
 	LD	(HL),A
 	INC	HL
 	CALL	READ
 	CP	00
 	JR	NZ,BASNX1
 	LD	(HL),A
 	LD	(BUFEND),HL
 	LD	A,3
 	LD	(TYPEMK),A
 	LD	HL,FILE
 	CALL	4467H
 	LD	A,0DH
 	CALL	033AH
 	CALL	PBUF
 	LD	HL,TYPEM3
 	CALL	4467H
 	JP	COMD
 DATTAP	LD	(HL),A
 	INC	HL
 	CALL	READ
 	CP	0DH
 	JR	NZ,DATTAP
 	LD	(HL),A
 	INC	HL
 	CALL	DTRD
 	CP	0
 	JR	NZ,PENTAP
 DATAP1	CALL	DTRD
 	CP	0A5H
 	JR	NZ,DATAP1
 DATAP2	CALL	DTRD
 	LD	(HL),A
 	INC	HL
 	CP	0DH
 	JR	NZ,DATAP2
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	JP	DATAP1
 DTRD	LD	B,0
 	PUSH	BC
 	PUSH	HL
 	LD	B,8
 DTRD2	PUSH	BC
 	PUSH	AF
 	LD	C,6
 DTRD3	LD	B,0
 DTRD4	IN	A,(0FFH)
 	RLA
 	JR	C,DTRD5
 	DJNZ	DTRD4
 	DEC	C
 	JP	Z,DTRD9
 	JR	DTRD3
 DTRD5	LD	B,41H
 DTRD6	DJNZ	DTRD6
 	CALL	021EH
 	LD	B,50H
 DTRD7	DJNZ	DTRD7
 	LD	B,14H
 DTRD8	IN	A,(0FFH)
 	DJNZ	DTRD8
 	LD	B,A
 	POP	AF
 	RL	B
 	RLA
 	PUSH	AF
 	CALL	021EH
 	POP	AF
 	POP	BC
 	DJNZ	DTRD2
 	POP	HL
 	POP	BC
 	RET
 DTRD9	POP	AF
 	POP	AF
 	POP	BC
 	POP	HL
 	POP	BC
 	DEC	HL
 	LD	(BUFEND),HL
 	CALL	BOT
 	CALL	PBUF
 	LD	A,4
 	LD	(TYPEMK),A
 	LD	HL,TYPEM4
 	CALL	4467H
 	JP	COMD
 PENTAP	LD	(HL),A
 	INC	HL
 	CALL	READ
 	CP	00
 	JR	Z,PENTP1
 	DJNZ	PENTAP
 	LD	(HL),A
 	INC	HL
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	LD	B,0
 	CALL	READ
 	JR	PENTAP
 PENTP1	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	INC	HL
 	CALL	READ
 	LD	(HL),A
 	LD	(BUFEND),HL
 	LD	A,7
 	LD	(TYPEMK),A
 	CALL	BOT
 	CALL	PBUF
 	LD	HL,TYPEM7
 	CALL	4467H
 	JP	COMD
 NEWDS	CALL	BOT
 	LD	HL,NMSG
 	CALL	4467H
 	CALL	LINP	;INPUT NEWDOS COMMAND
 	LD	HL,FILE
 	CALL	4419H	;DOS CALL
 	JP	Z,ND2
 	CALL	ERCK
 ND2	LD	A,1AH	;DOWNWARD LINE FEED
 	CALL	033AH
 	LD	HL,ND2MSG
 	CALL	4467H
 ND3	CALL	035BH	;TEST FOR ANY KEY
 	CP	0H
 	JR	Z,ND3
 	CALL	INTRO	;REPRINT DISPLAY MENU
 	CALL	BOT
 	JP	COMD
 CMD	CALL	BOT
 	LD	HL,CMSG
 	CALL	4467H
 	CALL	LINP	;INPUT EXIT COMMAND
 	LD	HL,FILE
 	CALL	4405H	;JUMP TO DOS & EXECUTE COMMAND
 DISK	CALL	ZBUF
 	LD	A,01
 	LD	(FORMAT),A
 	LD	HL,AMSG
 	CALL	4467H
 	CALL	CLRSPC
 	CALL	LINP
 	LD	A,03H
 	LD	(DE),A	;ADDS END MARK TO FILESPEC
 	CALL	BOT
 	LD	HL,FILE
 	CALL	4467H
 	LD 	DE,FILE
 	LD	HL,BUF	;SET FCB BUFFER ADRR
 	LD	IY,TBUF
 	LD	B,0
 	CALL	4424H	;OPEN FILE
 	JP	NZ,ERCK
 RDBT	LD	B,0
 	CALL	0013H	;READ BYTE
 	CP	01	;CHECK FOR TRSDOS SYST FILES
 	JP	Z,DOBJCT
 	CP	0FFH
 	JP	Z,DBASIC
 	CP	0D3H
 	JP	Z,DEDTAS
 	CP	00
 	JR	Z,NOLOAD
 	CP	20H
 	JP	M,NOLOAD
 	JP	DDATA
 DOBJCT	LD	(IY),A
 	INC	IY
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	C,A	;NUMBER OF BYTES TO LOAD
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	(STADR),A	;START ADDRESS
 	LD	L,A
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	(STADR+1),A
 	LD	H,A
 	DEC	C
 	DEC	C
 	OR	A
 	ADC	HL,BC
 	CALL	Z,FIX	;CHECK FOR 256 BYTE LOAD
 LOOP3	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	DEC	C
 	JR	NZ,LOOP3
 	CALL	022CH
 LOOP2	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	CP	02H	;LOOK FOR TRANSFER MARK
 	JR	Z,TRF
 	CALL	0013H
 	LD	C,A
 	LD	(IY),A
 	INC	IY
 	DEC	C
 	DEC	C
 	CALL	Z,FIX	;CHECK FOR 256 BYTE LOAD
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	L,A
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	H,A
 	OR	A
 	ADC	HL,BC
 	JP	LOOP3
 NOLOAD	CALL	0013H	;BYPASS TRSDOS PREAMBLE
 	LD	(IY),A
 	INC	IY
 	LD	B,A
 NL2	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	DJNZ	NL2
 	JP	RDBT
 FIX	LD	C,0FFH	;ADJUST FOR 256 BYTE LOAD
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	RET
 TRF	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	CALL	0013H
 	LD	(IY),A
 	INC	IY
 	LD	(TRFAD),A	;STORE TRANSFER ADDRESS
 	CALL	0013H
 	LD	(IY),A
 	LD	(TRFAD+1),A
 	LD	(BUFEND),IY
 	LD	DE,FILE
 	CALL	4428H	;CLOSE FILE
 	DEC	HL
 	LD	(ENDAD),HL
 	LD	DE,(STADR)
 	LD	(OEADR),HL
 	LD	(OSADR),DE
 	LD	HL,(TRFAD)
 	LD	(OTADR),HL
 	LD	A,(STADR)
 	CALL	CONV
 	LD	(A2MSG+2),HL
 	LD	A,(STADR+1)
 	CALL	CONV
 	LD	(A2MSG),HL
 	LD	A,(ENDAD)
 	CALL	CONV
 	LD	(A4MSG+2),HL
 	LD	A,(ENDAD+1)
 	CALL	CONV
 	LD	(A4MSG),HL
 	LD	A,(TRFAD)
 	CALL	CONV
 	LD	(A6MSG+2),HL
 	LD	A,(TRFAD+1)
 	CALL	CONV
 	LD	(A6MSG),HL
 	LD	HL,A1MSG	;DISPLAY LOAD ADDR
 	CALL	4467H
 	CALL	OFTST	;CHECK FOR OFFSET
 	CALL	PBUF
 	LD	A,1
 	LD	(TYPEMK),A
 	LD	HL,TYPEM1
 	CALL	4467H
 	CALL	TRSPC
 	JP	COMD
 CONV	LD	C,A	;CONVERT BYTES FOR DISPLAY
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	CHECK
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	CHECK
 	LD	H,A
 	RET
 CHECK	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 ERCK	OR	80H	;CHECK FOR DOS ERROR
 	CALL	4409H
 	JP	COMD
 LINP	LD	HL,INST	;INPUT ROUTINE
 	LD	A,20H
 	LD	B,2CH
 CLR	LD	(HL),A
 	INC	HL
 	DJNZ	CLR
 LINP1	LD	HL,INST
 	LD	B,2CH
 	CALL	05D9H
 	JR	C,LINP1
 	DEC	B
 	JP	M,LINP1
 	LD	HL,INST
 	DEC	HL
 	LD	DE,FILE	;TRANSFER INPUT DATA TO FILESPEC
 LIN	INC	HL
 	LD	A,(HL)
 	LD	(DE),A
 	INC	DE
 	CP	0DH
 	JR	NZ,LIN
 	RET
 DEDTAS	LD	(IY),A
 	INC	IY
 	CALL	0013H
 	CP	0DH
 	JR	NZ,DEDTAS
 	LD	(IY),A
 	INC	IY
 	CALL	022CH
 	CALL	0013H
 	CP	1AH
 	JR	NZ,DEDTAS
 	LD	(IY),A
 	LD	(BUFEND),IY
 	LD	A,02
 	LD	(TYPEMK),A
 	LD	HL,TYPEM2
 	CALL	4467H
 	CALL	4428H
 	CALL	PBUF
 	CALL	TRSPC
 	JP	COMD
 DBASIC	LD	(IY),A
 	INC	IY
 	CALL	0013H
 	CP	00
 	JR	NZ,DBASIC
 	LD	(IY),A
 	INC	IY
 	CALL	022CH
 	CALL	0013H
 	CP	00
 	JR	NZ,DBASIC
 	LD	(IY),A
 	INC	IY
 	CALL	0013H
 	CP	00
 	JR	NZ,DBASIC
 	LD	(IY),A
 	LD	(BUFEND),IY
 	LD	A,03
 	LD	(TYPEMK),A
 	LD	HL,TYPEM3
 	CALL	4467H
 	LD	A,0DH
 	CALL	PBUF
 	CALL	TRSPC
 	JP	COMD
 DDATA	LD	(IY),A
 	INC	IY
 	CALL	022CH
 	CALL	0013H
 	JP	NZ,DATCHK
 	JR	DDATA
 DATCHK	CP	1CH
 	JP	NZ,4409H
 	DEC	IY
 	LD	(BUFEND),IY
 	LD	A,(IY)
 	CP	00
 	JR	Z,DEND1
 	LD	IY,TBUF
 	LD	A,(IY)
 	CP	20H
 	JR	Z,DEND2
 	CP	3AH
 	JP	P,DEND2
 	LD	A,6
 	LD	(TYPEMK),A
 	CALL	PBUF
 	LD	HL,TYPEM6
 	CALL	4467H
 	JP	COMD
 DEND1	LD	A,7
 	LD	(TYPEMK),A
 	CALL	PBUF
 	LD	HL,TYPEM7
 	CALL	4467H
 	JP	COMD
 DEND2	LD	A,4
 	LD	(TYPEMK),A
 	CALL	PBUF
 	LD	HL,TYPEM4
 	CALL	4467H
 	JP	COMD
 CLRSPC	LD	B,8
 	LD	A,20H
 	LD	HL,FILE
 CS2	LD	(HL),A
 	INC	HL
 	DJNZ	CS2
 	LD	A,20H
 	LD	B,6
 	LD	IX,TFILE
 CTSPC	LD	(IX),A
 	INC	IX
 	DJNZ	CTSPC
 	LD	A,03H
 	LD	(IX),A
 	RET
 PBUF	LD	DE,TBUF	;PRINT BUFFER ADDRESSES OF FILE
 	LD	A,E
 	CALL	CONV
 	LD	(B1MSG+2),HL
 	LD	A,D
 	CALL	CONV
 	LD	(B1MSG),HL
 	LD	A,(BUFEND)
 	CALL	CONV
 	LD	(B2MSG+2),HL
 	LD	A,(BUFEND+1)
 	CALL	CONV
 	LD	(B2MSG),HL
 	LD	HL,(BUFEND)
 	LD	DE,TBUF
 	SBC	HL,DE
 	LD	A,H
 	INC	A
 	LD	C,5
 	LD	B,0
 GRN	INC	B
 	SUB	C
 	JP	P,GRN
 	LD	A,B
 	LD	B,0
 	LD	C,10
 GRN2	INC	B
 	SUB	C
 	JR	Z,GRN3
 	JP	P,GRN2
 	DEC	B
 	ADD	A,C
 GRN3	ADD	A,30H
 	LD	(GRAN+1),A
 	LD	A,B
 	ADD	A,30H
 	LD	(GRAN),A
 	LD	HL,BMSG
 	CALL	4467H
 	RET
 TRSPC	LD	B,6
 	LD	IX,FILE
 	LD	IY,TFILE
 TRSPC1	LD	A,(IX)
 	CP	2FH
 	RET	Z
 	CP	03H
 	RET	Z
 	CP	0DH
 	RET	Z
 	LD	(IY),A
 	INC	IX
 	INC	IY
 	DJNZ	TRSPC1
 	RET
 OFTST	LD	HL,0000
 	LD	(OFST),HL
 	LD	HL,(BUFEND)
 	LD	BC,0012H
 	OR	A
 	SBC	HL,BC
 	PUSH	HL
 	POP	IX
 	LD	A,(IX+10)
 	CP	0EDH
 	RET	NZ
 	LD	A,(IX+11)
 	CP	0B0H
 	RET	NZ
 	LD	L,(IX+5)
 	LD	H,(IX+6)
 	LD	(OSADR),HL
 	LD	C,(IX+8)
 	LD	B,(IX+9)
 	LD	E,(IX+13)
 	LD	D,(IX+14)
 	LD	(OTADR),DE
 	LD	E,(IX+2)
 	LD	D,(IX+3)
 	PUSH	HL
 	OR	A
 	SBC	HL,DE
 	LD	(OFST),HL
 	POP	HL
 	OR	A
 	ADC	HL,BC
 	LD	(OEADR),HL
 	LD	A,(OSADR)
 	CALL	CONV
 	LD	(O1MSG+2),HL
 	LD	A,(OSADR+1)
 	CALL	CONV
 	LD	(O1MSG),HL
 	LD	A,(OEADR)
 	CALL	CONV
 	LD	(O3MSG+2),HL
 	LD	A,(OEADR+1)
 	CALL	CONV
 	LD	(O3MSG),HL
 	LD	A,(OTADR)
 	CALL	CONV
 	LD	(O5MSG+2),HL
 	LD	A,(OTADR+1)
 	CALL	CONV
 	LD	(O5MSG),HL
 	LD	HL,(OSADR)
 	LD	DE,(STADR)
 	OR	A
 	SBC	HL,DE
 	LD	(OFST),HL
 	LD	HL,OMSG
 	CALL	4467H
 	RET
 BOT	LD	HL,3E80H	;CLEAR BOTTOM OF SCREEN
 	LD	(4020H),HL
 	LD	A,1FH
 	CALL	033AH
 	LD	HL,3E80H
 	LD	(4020H),HL
 	RET
 INTRO	CALL	01C9H	;CLEAR SCREEN
 	LD	HL,3C07H
 	LD	IX,SUPDIS
 	LD	B,48
 INTLP	LD	A,(IX)
 	LD	(HL),A
 	INC	HL
 	INC	IX
 	DJNZ	INTLP
 	LD	HL,3C47H
 	LD	B,48
 INTLP2	LD	A,(IX)
 	LD	(HL),A
 	INC	HL
 	INC	IX
 	DJNZ	INTLP2
 	LD	HL,3CC0H
 	LD	(4020H),HL
 	LD	HL,MSGCOM	;DISPLAY COMMAND MENU
 	CALL	4467H
 	LD	HL,MSGC1
 	CALL	4467H
 	LD	HL,MSGC2
 	CALL	4467H
 	LD	HL,MSGC3
 	CALL	4467H
 	LD	HL,MSGC4
 	CALL	4467H
 	LD	HL,MSGC5
 	CALL	4467H
 	LD	HL,3C80H
 	LD	DE,0064
 	LD	A,149
 	CALL	BAR
 	LD	A,170
 	LD	HL,3CBFH
 	CALL	BAR
 	LD	HL,3C9FH
 	CALL	BAR
 	LD	HL,3C80H
 	LD	B,40H
 	LD	A,131
 I1LOOP	LD	(HL),A
 	INC	HL
 	DJNZ	I1LOOP
 	LD	HL,3E40H
 	LD	B,40H
 	LD	A,131
 ILOOP	LD	(HL),A
 	INC	HL
 	DJNZ	ILOOP
 	LD	A,151
 	LD	HL,3C80H
 	LD	(HL),A
 	LD	A,171
 	LD	HL,3CBFH
 	LD	(HL),A
 	LD	HL,3C9FH
 	LD	(HL),A
 	LD	HL,3E80H
 	LD	(4020H),HL
 	RET
 SUPDIS	DEFB	151	;SUPERDIS DISPLAY
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	179
 	DEFB	187
 	DEFB	151	;U
 	DEFB	171
 	DEFB	191
 	DEFB	191
 	DEFB	151
 	DEFB	171
 	DEFB	151	;P
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	147
 	DEFB	171
 	DEFB	151	;E
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	179
 	DEFB	187
 	DEFB	151	;R
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	147
 	DEFB	171
 	DEFB	151	;C
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	179
 	DEFB	191
 	DEFB	151	;O
 	DEFB	163
 	DEFB	179
 	DEFB	179
 	DEFB	131
 	DEFB	191
 	DEFB	151	;P
 	DEFB	163
 	DEFB	179
 	DEFB	179	
 	DEFB	147
 	DEFB	171
 	DEFB	157	;LOWER ROW,S
 	DEFB	140
 	DEFB	140
 	DEFB	140
 	DEFB	132
 	DEFB	170
 	DEFB	149	;U
 	DEFB	138
 	DEFB	143
 	DEFB	143
 	DEFB	133
 	DEFB	170
 	DEFB	149	;P
 	DEFB	168
 	DEFB	188
 	DEFB	188
 	DEFB	188
 	DEFB	190	
 	DEFB	149	;E
 	DEFB	136
 	DEFB	142
 	DEFB	143
 	DEFB	143
 	DEFB	175
 	DEFB	149	;R
 	DEFB	168
 	DEFB	188
 	DEFB	188
 	DEFB	144
 	DEFB	174
 	DEFB	149	;C
 	DEFB	138
 	DEFB	143
 	DEFB	143
 	DEFB	143
 	DEFB	191
 	DEFB	149	;O
 	DEFB	138
 	DEFB	143
 	DEFB	143
 	DEFB	128
 	DEFB	191
 	DEFB	149	;P
 	DEFB	168
 	DEFB	188
 	DEFB	188
 	DEFB	188
 	DEFB	190
 BAR	LD	B,7
 BAR2	LD	(HL),A
 	ADC	HL,DE
 	DJNZ	BAR2
 	RET
 WSYST	LD	IX,TBUF
 	LD	A,55H
 	CALL	0264H
 	LD	DE,TFILE
 	LD	B,6
 WSY1	LD	A,(DE)
 	CALL	0264H
 	INC	DE
 	DJNZ	WSY1
 	LD	HL,(ENDAD)
 	LD	DE,8000H
 	OR	A
 	SBC	HL,DE
 	JP	P,WSY1A
 	LD	HL,0000
 	LD	(OFST),HL
 	LD	HL,(TRFAD)
 	LD	(OTADR),HL
 WSY1A	LD	DE,(OFST)
 WSY2	LD	A,(IX)
 	CP	01
 	JP	NZ,WSY4
 	LD	A,3CH
 	CALL	0264H
 	INC	IX
 	LD	A,(IX)
 	DEC	A
 	DEC	A
 	LD	B,A
 	CALL	0264H
 	INC	IX
 	LD	L,(IX)
 	INC	IX
 	LD	H,(IX)
 	INC	IX
 	OR	A
 	ADC	HL,DE
 	LD	A,L
 	LD	C,A
 	CALL	0264H
 	LD	A,H
 	CALL	0264H
 	ADD	A,C
 	LD	C,A
 WSY3	LD	A,(IX)
 	CALL	0264H
 	ADD	A,C
 	LD	C,A
 	INC	IX
 	DJNZ	WSY3
 	CALL	0264H
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	JR	WSY2
 WSY4	LD	A,78H
 	CALL	0264H
 	LD	DE,(OTADR)
 	LD	A,E
 	CALL	0264H
 	LD	A,D
 	CALL	0264H
 	JP	COMD
 WRITE	CALL	BOT
 	LD	HL,AMSG
 	CALL	4467H
 	CALL	CLRSPC
 	LD	HL,0000
 	LD	(DOFST),HL
 	CALL	LINP
 	LD	A,03H
 	LD	(DE),A
 	LD	HL,(BUFEND)
 	LD	DE,TBUF
 	OR	A
 	SBC	HL,DE
 	INC	HL
 	PUSH	HL
 	LD	B,0
 	LD	IY,TBUF
 	LD	DE,FILE
 	LD	HL,BUF
 	EXX
 	LD	DE,FILE
 	LD	B,0
 	LD	HL,BUF
 	CALL	4420H
 	JP	NZ,ERCK
 	POP	BC
 	LD	A,(FORMAT)
 	CP	00
 	JP	Z,WT2
 WT1	LD	A,(IY)
 	INC	IY
 	DEC	BC
 	CALL	DSKWRT
 	CALL	022CH
 	LD	A,B
 	OR	C
 	JR	NZ,WT1
 	LD	B,0
 	CALL	4428H
 	JP	COMD
 DSKWRT	EXX
 	CALL	001BH
 	EXX
 	JP	NZ,ERCK
 	RET
 WT2	LD	A,(TYPEMK)
 	CP	01
 	JP	Z,WT2AA
 	CP	03
 	JP	Z,WT6
 	CP	7
 	JR	Z,WTTPEN
 	JP	WT1
 WTTPEN	PUSH	BC
 	POP	DE
 	LD	A,(IY)
 	LD	B,A
 	DEC	DE
 	DEC	DE
 	DEC	DE
 	INC	IY
 WTPN2	LD	A,(IY)
 	CALL	DSKWRT
 	DEC	DE
 	INC	IY
 	DJNZ	WTPN2
 	CALL	022CH
 	LD	HL,0000
 	OR	A
 	ADC	HL,DE
 	JR	Z,WTPN3
 	JP	P,WTPN1
 WTPN3	LD	DE,FILE
 	LD	B,0
 	LD	HL,BUF
 	CALL	4428H
 	JP	COMD
 WTPN1	INC	IY
 	LD	A,(IY)
 	LD	B,A
 	INC	IY
 	DEC	DE
 	DEC	DE
 	JP	WTPN2
 WT2AA	LD	IY,TBUF
 	LD	HL,0000
 	LD	(DOFST),HL
 	LD	A,(IY+9)
 	LD	E,A
 	LD	A,(IY+10)
 	LD	D,A
 	LD	HL,8000H
 	OR	A
 	SBC	HL,DE
 	JP	M,WT2A
 	LD	(DOFST),HL
 WT2A	LD	BC,0008
 	ADD	IY,BC
 WT5	LD	A,01
 	CALL	DSKWRT
 	LD	A,(IY)
 	INC	IY
 	LD	B,A
 	INC	A
 	INC	A
 	CALL	DSKWRT
 	PUSH	BC
 	LD	BC,(DOFST)
 	LD	A,B
 	OR	C
 	POP	BC
 	JP	NZ,OSTAJ
 	LD	A,(IY)
 	CALL	DSKWRT
 	INC	IY
 	LD	A,(IY)
 	CALL	DSKWRT
 	INC	IY
 WT4	LD	A,(IY)
 	INC	IY
 	CALL	DSKWRT
 	DJNZ	WT4
 	CALL	022CH
 	INC	IY
 	LD	A,(IY)
 	INC	IY
 	CP	78H
 	JR	NZ,WT5
 	LD	BC,(DOFST)
 	LD	A,B
 	OR	C
 	JP	NZ,OTAJ
 	LD	A,02
 	CALL	DSKWRT
 	LD	A,02
 	CALL	DSKWRT
 	LD	BC,(OTADR)
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	EXX
 	CALL	4428H
 	JP	COMD
 WT6	LD	A,0FFH
 	CALL	DSKWRT
 	INC	IY
 	INC	IY
 	INC	IY
 	INC	IY
 	DEC	BC
 	DEC	BC
 	DEC	BC
 	DEC	BC
 	JP	WT1
 OSTAJ	PUSH	BC
 	PUSH	HL
 	LD	A,(IY)
 	INC	IY
 	LD	L,A
 	LD	A,(IY)
 	INC	IY
 	LD	H,A
 	LD	BC,(DOFST)
 	OR	A
 	ADC	HL,BC
 	PUSH	HL
 	POP	BC
 	POP	HL
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	POP	BC
 	JP	WT4
 OTAJ	LD	A,01
 	CALL	DSKWRT
 	LD	A,11H
 	CALL	DSKWRT
 	PUSH	HL
 	LD	HL,(OEADR)
 	INC	HL
 	LD	BC,(DOFST)
 	OR	A
 	ADC	HL,BC
 	LD	A,L
 	CALL	DSKWRT
 	LD	A,H
 	CALL	DSKWRT
 	PUSH	HL
 	LD	A,0
 	CALL	DSKWRT
 	LD	A,21H
 	CALL	DSKWRT
 	LD	A,00
 	CALL	DSKWRT
 	LD	A,80H
 	CALL	DSKWRT
 	LD	BC,(OSADR)
 	LD	A,11H
 	CALL	DSKWRT
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	PUSH	HL
 	LD	HL,(OEADR)
 	LD	BC,(OSADR)
 	OR	A
 	SBC	HL,BC
 	PUSH	HL
 	POP	BC
 	POP	HL
 	LD	A,01
 	CALL	DSKWRT
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	LD	A,0EDH
 	CALL	DSKWRT
 	LD	A,0B0H
 	CALL	DSKWRT
 	LD	A,0C3H
 	CALL	DSKWRT
 	LD	BC,(OTADR)
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	LD	A,02
 	CALL	DSKWRT
 	LD	A,02
 	CALL	DSKWRT
 	POP	BC
 	POP	HL
 	LD	A,C
 	CALL	DSKWRT
 	LD	A,B
 	CALL	DSKWRT
 	EXX
 	CALL	4428H
 	JP	COMD
 ZBUF	LD	HL,(4049H)
 	DEC	HL
 	LD	DE,TBUF
 	OR	A
 	SBC	HL,DE
 ZBUF1	LD	A,0
 	LD	(DE),A
 	INC	DE
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,ZBUF1
 	CALL	BOT
 	RET
 PROBLD	CALL	ZBUF
 	LD	HL,TMSG
 	CALL	4467H
 	DI
 	LD	HL,TBUF
 PBLD1	CALL	035BH
 	CP	0DH
 	JR	NZ,PBLD1
 	LD	A,(RECSL)
 	CALL	0212H
 	CALL	0296H
 	LD	A,2AH
 	LD	(3C3EH),A
 	CALL	022CH
 	LD	A,5
 	LD	(TYPEMK),A
 	LD	A,0
 	LD	(FORMAT),A
 PBRD1	PUSH	HL
 	LD	B,8
 	LD	DE,0000
 PBRD2	PUSH	BC
 	PUSH	AF
 PBRD3	DEC	DE
 	LD	A,D
 	OR	E
 	JP	Z,PBRD9
 PBRD4	IN	A,(0FFH)
 	RLA
 	JR	NC,PBRD3
 PBRD5	LD	B,41H
 PBRD6	DJNZ	PBRD6
 	CALL	021EH
 	LD	B,50H
 PBRD7	DJNZ	PBRD7
 	LD	B,14H
 PBRD8	IN	A,(0FFH)
 	DJNZ	PBRD8
 	LD	B,A
 	POP	AF
 	RL	B
 	RLA
 	PUSH	AF
 	CALL	021EH
 	POP	AF
 	POP	BC
 	DJNZ	PBRD2
 	POP	HL
 	LD	(HL),A
 	INC	HL
 	CALL	022CH
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	JP	PBRD1
 PBRD9	POP	AF
 	POP	BC
 	POP	HL
 	DEC	HL
 	LD	(BUFEND),HL
 	CALL	BOT
 	CALL	PBUF
 	JP	COMD
 COPYWR	LD	HL,CWMSG
 	LD	B,88
 CWR	LD	A,(HL)
 	ADD	A,20H
 	LD	(HL),A
 	INC	HL
 	DJNZ	CWR
 	LD	A,0DH
 	CALL	033AH
 	LD	HL,CWMSG
 	CALL	4467H
 	JP	COMD
 CWMSG	DEFB	24H
 	DEFB	21H
 	DEFB	2EH
 	DEFB	00
 	DEFB	32H
 	DEFB	2FH
 	DEFB	22H
 	DEFB	29H
 	DEFB	2EH
 	DEFB	33H
 	DEFB	2FH
 	DEFB	2EH
 	DEFB	00
 	DEFB	00
 	DEFB	08H
 	DEFB	14H
 	DEFB	11H
 	DEFB	15H
 	DEFB	09H
 	DEFB	00
 	DEFB	13H
 	DEFB	15H
 	DEFB	19H
 	DEFB	0DH
 	DEFB	13H
 	DEFB	13H
 	DEFB	13H
 	DEFB	18H
 	DEFB	00
 	DEFB	00
 	DEFB	11H
 	DEFB	16H
 	DEFB	12H
 	DEFB	15H
 	DEFB	00
 	DEFB	28H
 	DEFB	29H
 	DEFB	27H
 	DEFB	27H
 	DEFB	29H
 	DEFB	2EH
 	DEFB	33H
 	DEFB	00
 	DEFB	37H
 	DEFB	21H
 	DEFB	39H
 	DEFB	00
 	DEFB	30H
 	DEFB	21H
 	DEFB	23H
 	DEFB	29H
 	DEFB	26H
 	DEFB	29H
 	DEFB	23H
 	DEFB	21H
 	DEFB	0CH
 	DEFB	23H
 	DEFB	21H
 	DEFB	00
 	DEFB	19H
 	DEFB	14H
 	DEFB	10H
 	DEFB	14H
 	DEFB	14H
 	DEFB	33H
 	DEFB	35H
 	DEFB	30H
 	DEFB	25H
 	DEFB	32H
 	DEFB	23H
 	DEFB	2FH
 	DEFB	30H
 	DEFB	00
 	DEFB	00
 	DEFB	21H
 	DEFB	30H
 	DEFB	32H
 	DEFB	29H
 	DEFB	2CH
 	DEFB	00
 	DEFB	12H
 	DEFB	18H
 	DEFB	0CH
 	DEFB	00
 	DEFB	11H
 	DEFB	19H
 	DEFB	18H
 	DEFB	11H
 	DEFB	0DH
 BUFCHG	LD	HL,BUFMSG
 	CALL	4467H
 BC1	CALL	035BH
 	CP	00
 	JR	Z,BC1
 	CALL	033AH
 	LD	E,A
 BC2	CALL	035BH
 	CP	00
 	JR	Z,BC2
 	CALL	033AH
 	SUB	30H
 	LD	C,A
 BC3	CALL	035BH
 	CP	00
 	JR	Z,BC3
 	CALL	033AH
 	SUB	30H
 	ADD	A,C
 	LD	C,A
 	LD	B,0
 	LD	HL,(BUFEND)
 	LD	A,E
 	CP	2DH
 	JP	Z,BUFCG2
 	CP	2BH
 	JP	NZ,BUFCHG
 	ADC	HL,BC
 	LD	(BUFEND),HL
 	LD	A,0DH
 	CALL	033AH
 	JP	COMD
 BUFCG2	SBC	HL,BC
 	LD	(BUFEND),HL
 	LD	A,0DH
 	CALL	033AH
 	JP	COMD
 BUFMSG	DEFM	'BYTES TO ADD/DELETE (+/-)?'
 	DEFB	0DH
 PRNTBF	DEFS	48
 PRNTB1	DEFS	16
 	DEFB	0DH
 PBF	LD	HL,(BUFEND)
 	LD	DE,TBUF
 	OR	A
 	SBC	HL,DE
 	LD	DE,TBUF
 PBF1	LD	IX,PRNTBF
 	LD	IY,PRNTB1
 	LD	B,16
 PBF2	LD	A,(DE)
 	LD	C,A
 	PUSH	HL
 	PUSH	BC
 	CALL	CONV
 	LD	A,L
 	LD	(IX),A
 	INC	IX
 	LD	A,H
 	LD	(IX),A
 	INC	IX
 	LD	A,20H
 	LD	(IX),A
 	INC	IX
 	POP	BC
 	POP	HL
 	LD	A,C
 	CP	20H
 	JP	M,PBF4
 	CP	7FH
 	JP	P,PBF4
 	JP	PBF5
 PBF3	INC	DE
 	DEC	HL
 	DJNZ	PBF2
 	PUSH	HL
 	LD	HL,PRNTBF
 	CALL	446AH
 	POP	HL
 	LD	A,(3840H)
 	CP	4
 	JP	Z,COMD
 	LD	BC,0000
 	ADC	HL,BC
 	JP	M,COMD
 	JP	PBF1
 PBF4	LD	A,2EH
 	LD	(IY),A
 	INC	IY
 	JP	PBF3
 PBF5	LD	(IY),A
 	INC	IY
 	JP	PBF3
 RECSLT	CALL	BOT
 	LD	HL,CASMSG
 	CALL	4467H
 CASSEL	CALL	035BH
 	CP	0
 	JR	Z,CASSEL
 	CP	31H
 	JR	Z,CASS1
 	CP	21H
 	JP	Z,COPYWR
 	CP	32H
 	JR	NZ,CASSEL
 CASS1	SBC	A,31H
 	LD	(RECSL),A
 	JP	COMD
 BYTE	DEFS	1H	;STORE BYTE COUNT
 TBUF	EQU	6600H
 	END	START
