CLOAD  ; #######################################################
 ; BASIC AUTOEXECUTION ROUTINE PATCH FOR LEVEL II BASIC
 ; #######################################################
 ;
 BYTE	EQU	1D78H		; INTERPRETER CALL ADDR.
 ;
 ; #######################################################
 ;
 	ORG	7F00H		; RELOCATE IF DESIRED
 START	LD	HL,(4004H)	; GET INTERPRETER PATCH
 	LD	(RETURN),HL	; CHAINING PROCESS HERE
 	LD	HL,ENTRY	; ENTRY OF AUTOEXECUTOR
 	LD	(4004H),HL	; PATCH INTO INTERPRETER
 	JP	06CCH		; RETURN TO BASIC READY
 ;
 ; #######################################################
 ; CHECK FOR STATUS OF INTERPRETER (MUST BE AT 1D5BH)
 ; #######################################################
 ;
 ENTRY	EX	(SP),HL		; GET RETURN ADDRESS
 	LD	A,L		; GET LSB INTO A REG.
 	CP	5BH		; CHECK LSB OF 1D5BH
 	JR	NZ,NOTRDY	; GO OUT IF NOT AT 1D5B
 	LD	A,H		; GET MSB INTO A REG.
 	CP	1DH		; CHECK MSB OF 1D5BH
 NOTRDY	EX	(SP),HL		; RETURN STACK POSITION
 	JP	NZ,AWAY		; BEGONE IF NOT ID5BH
 ;
 ; #######################################################
 ; COMPARE PRESENT LINE POSITION WITH CLOAD (TOKEN B9)
 ; #######################################################
 ;
 	CALL	BYTE		; GET NEXT BUFFER CHAR.
 	PUSH	AF		; SAVE PRESENT ACCUM.
 	CP	0B9H		; SEE IF CLOAD TOKEN
 	JR	Z,CLOAD		; SPECIAL ROUTINE IF B9
 	POP	AF		; RESTORE PRESENT ACCUM.
 	DEC	HL		; RESTORE HL POINTER
 	JR	AWAY		; OUT TO NORMAL MODE
 ;
 ; #######################################################
 ; IF CLOAD TOKEN IS FOUND, EXECUTE CLOAD PROCESS, BUT
 ; FIRST INTERCEPT KEYBOARD SCAN (CRUDE WAY OF DOING IT)
 ; TO GRAB PROGRAM ON ITS WAY BACK TO A READY CONDITION
 ; #######################################################
 ;
 CLOAD	POP	AF		; CLEAR STACK OF AF REG.
 	LD	HL,(4016H)	; GET CURRENT KEYBRD SCAN
 	LD	(STORE),HL	; SAVE IT FOR A WHILE
 	LD	HL,BYPASS	; GET VALUE OF ROUTINE
 	LD	(4016H),HL	; PATCH INTO KEYBRD PLACE
 	LD	HL,41E9H	; POINT TO BUFFER LOC'N
 	LD	(HL),00		; PLACE END OF LINE CMD.
 	DEC	HL		; BUMP HL BACK TO START
 	LD	A,0B9H		; GET CLOAD VALUE
 	SUB	80H		; STRIP OFFSET VALUE
 	JP	1D65H		; BACK TO EXECUTION ROUT.
 ;
 ; #######################################################
 ; CLOAD ABOVE WILL EXECUTE, RESET THE STACK, AND ATTEMPT
 ; TO RETURN TO A READY CONDITION.  AT THIS POINT, THE 
 ; KEYBOARD DRIVER INTERCEPT WILL REDIRECT THE PROCESSOR
 ; TO THE BYPASS ROUTINE BELOW, WHICH WILL AGAIN SET UP
 ; THE BUFFER, REPATCH THE KEYBOARD DRIVER, AND RUN.
 ; #######################################################
 ;
 BYPASS	LD	HL,(STORE)	; GET BACK KEYBRD SCAN
 	LD	(4016H),HL	; PUT BACK INTO PLACE
 	LD	HL,41E8H	; GET BUFFER LOCATION
 	LD	(HL),8EH	; GET RUN COMMAND TOKEN
 	INC	HL		; BUMP UP BUFFER POS'N
 	LD	(HL),00		; CLOSE OFF THE BUFFER
 	DEC	HL		; BUMP BACK IN BUFFER...
 	DEC	HL		; ...TO THE RUN COMMAND
 	JP	1D5AH		; AND THEN EXECUTE IT
 ;
 ; #######################################################
 ; THE FOLLOWING FOUR BYTES ARE TEMPORARY KEYBOARD STORAGE
 ; #######################################################
 ;
 STORE	DEFW	0000		; TEMPORARY TWO-BYTE AREA
 AWAY	DEFB	0C3H		; JUMP COMMAND IN PLACE
 RETURN	DEFW	1D78H		; ORIGINAL VALUE CHANGES
 ;
 	END	START		; PATCH ROUTINE AT START
 ;
