; Based on BPORT Blink
; TMS7000 Evaluation Module User's Guide
; TMS70C02 version

        INCLUDE "PR_TMS70C02.asm"
        
COUNTER EQU     >0020
OUTBYTE EQU     >0033
INBYTE  EQU     >0034
HIBITMK EQU     >7F
SP      EQU     >0080
        
        AORG    >E000
        
START   MOV     SP, B
        LDSP                 ;Set SP = 0x0080
        DINT                 ;Disable interrupts
        MOVP    %0b00001000, PORTA  ; %>0D0, PORTA    ;PORTA=x50    ;LEDs OFF
        MOVP    %0b10001110, DDRA   ; %>0DF, ADDR     ;DDRA=0xDF  
        MOVP    %>008, PORTB    ;PORTB=x0f (bit 0-3 only - PB4-PB7 reservedfor bus control signals)
        MOVP    %0b01010101, SCTL0 ; reset serial port & error flags
        
        CALL    @UARTINIT    ; Setup UART for 9600b
        MOV     %>1F, OUTBYTE
        EINT
LOOP
        ANDP    %>08, PORTB     ; 0b00001000
D1      DECD    COUNTER         ; Loop D1
        JC      D1
        ORP     %>09, PORTB     ; 0b00001001
        
        MOV     OUTBYTE, A
        INC     A
        CMP     %>7F, A       ; Greater than `~`
        JL      SKIP
        MOV     %' ', OUTBYTE
        MOV     %' ', A
SKIP
        CALL    @OUTCHR
        
        CALL    @CHKKEY
        JZ      NOINBYTE
        CALL    @GETBYTE
        MOV     A, OUTBYTE
NOINBYTE
        
D2      DECD    COUNTER         ; Loop D2
        JC      D2
        JMP     LOOP           ; REPEAT SINGLE BLINK


; E.M. Klaus code modified & annotated
;;************************************************************************
;; UARTINIT Setup UART for 9600b 8 data 1 stop No Parity
;; NOTE: @9600b 1 char takes 1.04ms
;;************************************************************************
UARTINIT
        MOVP    %>051, SCTL0    ;SCTL0 = x10 Reset UART 0b01010001
        MOVP    %7, T3DATA   ;T3DATA= 11-15 for 4800b,  6-7 for 9600b(not working)
        ORP     %>0F9, PORTB    ;ENABLE TX Pin   PORTB Bit3=TXD 0b11111001
        ANDP    %>0DF, DDRA     ;PORTA BIT5 = INPUT (RXD)       0b11011111
        MOVP    %0b01001110, SMODE ; %>0CE, SMODE    ;SMODE =CE 01001110   1 Stop, No Parity, 8Data, Async
        MOVP    %>015, SCTL0    ;SCTL0 =15 00010101   Tx & Rx Enabled
        MOVP    %>0C0, SCTL1    ;SCTL1 =C0 11000000   Use Timer3, no prescale bits
        RETS
        
;;************************************************************************
; OUTCHR  Send Serial 1 byte from A (PORTB Bit3=TXD)
; A,B are unchanged uses R33 (OUTBYTE)
;;************************************************************************
OUTCHR  MOV     A, OUTBYTE  ; R33
TXEMPTY 
        MOVP    SSTAT, A    ; SSTAT-P22  Bit0=TXRDY
        AND     %>01, A
        JZ      TXEMPTY     ; 0=TXBUSY keep checking...
        MOV     OUTBYTE, A  ; Restore A and return
        MOVP    A, TXBUF    ; TXBUF=P26  A->TXBUF 
        RETS

;;************************************************************************
; CHKKEY test if RXBUF is full (data available)
; RETURNS: Z=0 if data is available
;;************************************************************************
CHKKEY    MOVP SSTAT, A   ;Get UART SSTAT reg    9 cycles
          AND  %>02, A    ;Test for RXRDY bit    7 cycles
          TSTA
          RETS            ;Return Z=0 (NOT Zero return 0x20) if data otherwise zero  7 cycles

;;************************************************************************
; WAIT4BYTE  Get 1 Serial 1 byte (PORTA Bit5=RXD)
;;************************************************************************
WAIT4BYTE 
        CLR     INBYTE       ; R34 = Input Byte
WAITKEY CALL    @CHKKEY  
        JNZ      WAITKEY    ; If NOT SET keep checking
        
GETBYTE MOVP    RXBUF, A     ; RXBUF -> A
        MOV     A, INBYTE    ; A-> INBYTE
        RETS


        
        AORG    >FFF6           ; Set up 4 vectors 
                                ; =interrupts 
        DATA    INTER4, START, START, START, START 
        
        END
