;	Epson QX-10 IPL v0.06

	ORG	0000h

	MACLIB	Z80

HF000	EQU	0F000h		;boot0 address
HFC00	EQU	0FC00h		;FDD and keyboard command parm buffer during IRQ
;
;HFC00 		= command
;  +1  		= drive#
;  +2  		= track#
;  +3  		= head#
;  +4  		= skew
;  +5  		= data bytes / sector
;  +6  		= sectors/track
;  +7  		= gaplength
;  +8  		= bytes/sector
;  +9  		= # of pages to load
;  +10 		= DMA address word
;  +12 to +18 	= FDD status reg 0-7
;  +19 		= bit 6 set then command ready for IRQ execution
;  +20 		= 0 if command successful
;  +22 		= keyboard status reg 0 (main)
;  +23 		= keyboard status reg 1
;  +24 		= keyboard data
;  +25 		= keyboard transmit IRQ state
;  +33 		= return address
;
	LXI 	SP,0000h
	MVI 	A,10h		;memory bank = 0
	OUT 	18h
	IM0
;
;	init speaker timer#1 = 100ms
;   	
	MVI 	A,32h
	OUT 	03h
	MVI 	A,00h
	OUT 	00h
	MVI 	A,01h
	OUT 	00h
;
;	init speaker timer#2 frequency = 1KHz
;
	MVI 	A,36h
	OUT 	07h
	MVI 	A,00h
	OUT 	04h
	MVI 	A,08h
	OUT 	04h
;
;	init keyboard clock = 1200BPS
;
	MVI 	A,76h
	OUT 	07h
	MVI 	A,80h
	OUT 	05h
	MVI 	A,06h
	OUT 	05h
;
;	init RS232C clock = 9600BPS
;
	MVI 	A,0B6h
	OUT 	07h
	MVI 	A,0D4h
	OUT 	06h
	MVI 	A,00h
	OUT 	06h
;
;	init 8259A interrupt controller (master)
;
	MVI 	A,95h	;ICW1 = edge sense, 4-byte, multi, with ICW4
	OUT 	08h
	MVI 	A,07h	;ICW2 = interrupt address table = 780H
	OUT 	09h
	MVI 	A,80h	;ICW3 = slave is connected to master
	OUT 	09h
	MVI 	A,02h	;ICW4 = automatic end of interrupt
	OUT 	09h
	MVI 	A,2Fh	;OCW1 = 00101111 interrupt mask
	OUT 	09h
;
;	init 8259A slave
;
	MVI 	A,0B5h	;ICW1 = edge sense, 4-byte, multi, with ICW4
	OUT 	0Ch
	MVI 	A,07h	;ICW2 = interrupt address = 7A0H
	OUT 	0Dh
	MVI 	A,07h	;ICW3 = slave interrupt level 7 in master
	OUT 	0Dh
	MVI 	A,02h	;ICW4 = automatic end of interrupt
	OUT 	0Dh
	MVI 	A,0FAh	;OCW1 = 11111010 interrupt mask
	OUT 	0Dh
;
;	init 7201 keyboard serial interface
;
	LXI 	H,H07C0
	MVI 	B,0Bh
	MVI 	C,12h
	OUTIR
;
;	init reference clock = 32.768KHz and FDD motor timer length
;	
	LXI 	D,0A2Eh
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Ah
	DCR 	C
	OUTP  	E	;46818 write data 2Eh to address 0Ah
;
;	enable FDD timer and set clock = 24hr
;
	MVI 	D,0Bh
	MVI 	E,0Ah
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Bh
	DCR 	C
	OUTP  	E	;46818 write data 0Ah to address 0Bh
;
;	flag clock ram as valid
;
	LXI 	D,0D80h
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Dh	
	DCR 	C
	OUTP  	E	;46818 write data 80h to address 0Dh
;
;	init 8255 printer interface:
;		port A byte output
;		port B bit input
;		port C bit output
;		port C bit control
;
	MVI 	A,0A2h
	OUT 	17h
	MVI 	A,0Bh
	OUT 	17h	;set bit 5 port C
	MVI 	A,01h
	OUT 	17h	;set bit 0 port C
	MVI 	A,0Ah
	OUT 	17h	;reset bit 5 port C
;
;	init DMA controller #1:
;		CH1 = single mode, address decrement
;		CH1 CRT base address = H0772				
;		CH1 = PACK low, DREQ low, Extended Write, Fixed Priority
;		CH1 = Normal Timing, Controller Enabled
;		CH1 = Addr Holt CH0 disabled, Mem to Mem disabled
; 		
	XRA 	A
	OUT 	4Dh	;master clear
	MVI 	A,49h	;01001001
	OUT 	4Bh	;CH1 = single mode, address decrement
	LXI 	H,H0772	;CH1 base address for CRT
	MOV 	A,L
	OUT 	42h
	MOV 	A,H
	OUT 	42h
	MVI 	A,01h	;CH1 word address
	OUT 	43h
	XRA 	A
	OUT 	43h
	MVI 	A,60h	;01100000
	OUT 	48h	;8 more CH1 parameters listed above
	MVI 	A,0Dh	;00001101
	OUT 	4Fh	;CH1 mask register
;
;	init 7220 Graphics Display Controller
;
;	port 39h	W= send command R= read data
;	port 38h	W= send parm	R= status
;
	MVI 	A,00h	;reset
	OUT 	39h
	MVI 	A,6Fh	;generate vert sync as master
	OUT 	39h
	IN  	2Ch	;color or monochrome?
	ANI 	01h	;0=mono 1=color
	JRNZ  	H011B	;taken if graphics (color) mode
;
; for character (mono) mode
;
	MVI 	A,0Eh	;specify sync format (blank the display)
	OUT 	39h
	MVI 	C,38h
	MVI 	B,08h
	LXI 	H,H07CB
	OUTIR		;send sync format parms for monochrome 	
H00D3	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H00D3	;loop until FIFO parm buffer empty
	MVI 	A,4Bh
	OUT 	39h	;cursor and character characteristics
	MVI 	A,0Fh
	OUT 	38h	;16 lines per character row (no display cursor)
	MVI 	A,6Dh
	OUT 	38h	;cursor top line# = 13
	MVI 	A,70h
	OUT 	38h	;cursor bottom line# = 14
	MVI 	A,46h
	OUT 	39h	;zoom command	
	XRA 	A
	OUT 	38h	;zoom factor of 1
	OUT 	3Ah	;zoom magnification 0
H00F4	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H00F4	;loop until FIFO parm buffer empty
	MVI 	A,47h
	OUT 	39h	;pitch command
	MVI 	A,50h	
	OUT 	38h	;80 word addresses / line
	MVI 	A,70h
	OUT 	39h	;PRAM load command (start addr = 0)
	MVI 	A,00h
	OUT 	38h	;clear PRAM addr 0
	OUT 	38h	;clear PRAM addr 1
	OUT 	38h	;clear PRAM addr 2
	MVI 	A,19h
	OUT 	38h	;PRAM addr 3 = 19h
	LXIX  	H01B4
	JMP 	H04A1
;
; for graphics (color) mode
;
H011B	MVI 	A,0Eh	;specify sync format (blank the display)
	OUT 	39h
	MVI 	C,38h
	MVI 	B,08h
	LXI 	H,H07D3
	OUTIR		;send sync format parms for color 	
H0128	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h	
	JRNZ  	H0128	;loop until FIFO parm buffer empty
	MVI 	A,4Bh
	OUT 	39h	;cursor and character characteristics
	XRA 	A	;clear all cursor/char settings
	OUT 	38h
	OUT 	38h
	OUT 	38h
	MVI 	A,46h	
	OUT 	39h	;zoom command
	XRA 	A
	OUT 	38h	;zoom factor of 1
	OUT 	3Ah	;zoom magnification of 0
H0144	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0144	;loop until FIFO parm buffer empty
	MVI 	A,47h
	OUT 	39h	;pitch command
	MVI 	A,28h	;40 word addresses / line
	OUT 	38h	
	MVI 	A,70h	
	OUT 	39h	;PRAM load command (start addr = 0)
	XRA 	A
	OUT 	38h	;clear PRAM addr 0
	OUT 	38h	;clear PRAM addr 1
	OUT 	38h	;clear PRAM addr 2
	MVI 	A,19h
	OUT 	38h	;PRAM addr 3 = 19h
	MVI 	A,01h	;to select blue color memory bank
	LXI 	H,H016B
	JMP 	H04E4	;init/clear blue memory bank
H016B	MVI 	A,04h	;to select red color memory bank
	LXI 	H,H0173
	JMP 	H04E4	;init/clear red memory bank
H0173	MVI 	A,02h	;to select green color memory bank
	LXI 	H,H017B
	JMP 	H04E4	;init/clear green memory bank
H017B	LXI 	D,HF000
	LXI 	H,H07D3
	LXI 	B,0008h
	LDIR  	
	LXI 	H,HF000
	SETB  	4,M
	MVI 	B,08h
	MVI 	C,38h
	MVI 	A,0Eh
	OUT 	39h	;specify sync format (blank the display)
	OUTIR		;init sync format parms for color 	
H0195	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0195	;loop until FIFO parm buffer empty
	MVI 	A,47h
	OUT 	39h	;pitch command
	MVI 	A,28h
	OUT 	38h	;40 word addresses/line
	MVI 	A,70h
	OUT 	39h	;PRAM load command (start addr = 0)
	XRA 	A
	OUT 	38h	;clear PRAM addr 0
	OUT 	38h	;clear PRAM addr 1
	OUT 	38h	;clear PRAM addr 2
	MVI 	A,19h
	OUT 	38h	;PRAM addr 3 = 19h
;
;done with video init
;test the processor by executing all instructions and checking registers.
;display DIAGNOSTIC CODE 001 if processor error.
;also test the memory.
;display DIAGNOSTIC CODE 002 if memory error
;
H01B4	MVI 	A,6Bh
	OUT 	39h	;start display and end idle mode
	XRA 	A
	OUT 	4Dh	;master clear (hardware reset)
	MVI 	B,00h
	MOV 	A,B
	ORA 	A
	JRZ   	H01C5
H01C1	JMP 	H045C	;DIAGNOSTIC CODE 001 ERROR
	HLT 	
H01C5	ADI 	0D2h
	RLC 	
	JRNC  	H01C1
	MOV 	B,A
	MOV 	C,B
	MOV 	D,C
	MOV 	E,D
	MOV 	H,E
	MOV 	A,H
	JP 	H01C1
	XRI 	0A5h
	JRNZ  	H01C1
	LXI 	B,0F1Eh
	LXI 	D,2D3Ch
	LXI 	H,4B5Ah
	EXX 	
	EXX 	
	XCHG	
	ANA 	B
	XRA 	C
	ORA 	D
	ANA 	E
	ADD 	H
	SUB 	L
	CPI 	4Bh
	JRNZ  	H01C1
	XRA 	A
	LXI 	B,0102h
	LXI 	D,0304h
	LXI 	H,0506h
	ADD 	B
	ADD 	C
	ADD 	D
	ADD 	E
	ADD 	H
	ADD 	L
	CPI 	15h
	JNZ	H01C1
	DAD 	B
	DAD 	D
	DAD 	H
	ADD 	H
	ADD 	L
	CPI 	3Fh
	JNZ	H01C1
	LXIX  	H0219
	LXI 	B,0001h
	LXI 	D,0001h
	LXI 	SP,0000h
H0219	NOP 	
	NOP 	
	XRA 	A
	DADX  	B 
	DADX  	D 
	DADX  	SP
	LDX   	A,00h
	CPI 	0AFh
	JNZ	H01C1
	LXIY  	H0219
	DADY  	B 
	DADY  	D 
	DADY  	SP
	LDY   	A,00h
	CPI 	0AFh
	JNZ	H01C1
	MVI 	A,00h
	LXI 	H,H0382
	LXI 	B,0003h
	CCI   	
	JNZ	H01C1
	INR 	A
	JZ 	H01C1
	DCR 	A
	JNZ	H01C1
	MVI 	A,09h
	ACI 	01h
	DAA 	
	CPI 	10h
	JNZ	H01C1
	CMA 	
	CPI 	0EFh
	JNZ	H01C1
	NEG   	
	CPI 	11h
	JNZ	H01C1
	STC 	
	JNC	H01C1
	CMC 	
	JC 	H01C1
	LXI 	H,H0280
	LXIX  	H0283
	LXIY  	H0286
	PCHL	
	JMP 	H01C1
	HLT 	
H0280	PCIX  	
	HLT 	
H0283	PCIY  	
	HLT 	
H0286	MVI 	B,05h
H0288	DJNZ  	H0288
	XRA 	A
	ORA 	B
	JNZ	H01C1
	LXI 	H,HF000
	LXI 	B,1000h
H0295	MVI 	M,0FFh
	INX 	H
	DCX 	B
	MOV 	A,B
	ORA 	C
	JRNZ  	H0295
	LXI 	B,0FFFh
	LXI 	H,0FFFFh
	LXI 	D,0FFFEh
H02A6	LDAX	D
	ANA 	M
	JZ 	H046C
	CPI 	0FFh
	JNZ	H046C
	XRA 	M
	MOV 	M,A
	MOV 	A,M
	ORA 	A
	JNZ	H046C
	DCX 	H
	DCX 	B
	DCX 	D
	MOV 	A,B
	ORA 	C
	JRNZ  	H02A6
	MOV 	A,M
	XRI 	0FFh
	MOV 	M,A
	JNZ	H046C
	MVI 	A,41h
	RLC 	
	JC 	H01C1
	RAL 	
	JNC	H01C1
	RAL 	
	JC 	H01C1
	RRC 	
	JNC	H01C1
	RAR 	
	JC 	H01C1
	LXIX  	0FFFFh
	STX   	A,00h
	RLCX  	00h
	JNC	H01C1
	RALX  	00h
	JNC	H01C1
	RRCX  	00h
	JNC	H01C1
	RARX  	00h
	JNC	H01C1
	SLAX  	00h
	JNC	H01C1
	SRAX  	00h
	JC 	H01C1
	SRLX  	00h
	JC 	H01C1
	LXI 	H,0FFFFh
	MVI 	A,0Eh
	RLD   	
	JZ 	H01C1
	RRD   	
	JZ 	H01C1
	BIT   	7,A
	JNZ	H01C1
	BIT   	3,A
	JZ 	H01C1
	BIT   	6,M
	JZ 	H01C1
	BITX  	1,00h
	JNZ	H01C1
	SETB  	6,A
	SETB  	7,M
	SETX  	2,00h
	RES   	3,A
	RES   	0,M
	RESX  	5,00h
	ADDX  	00h
	JNC	H01C1
	JZ 	H01C1
	LXI 	D,HF000		;test function of RAM area F000h which
	LXI 	H,H035E		;will be used for boot0
	LXI 	B,0010h		 
	LDIR			;also tests function of LDIR instruction  	
	MVI 	A,02h
H035E	JR    	H0361
	HLT 	
H0361	NOP 	
	JR    	H0365
	HLT 	
H0365	DCR 	A
	ORA 	A
	JZ 	H036E		;back to ROM
	JNZ	HF000		;jump to H035E instructions now in RAM
	HLT 	
H036E	LXI 	D,HFC00		;test function of ram area FC00h which
	LXI 	H,H037C+6	;will be used for FDD IRQ command parms
	LXI 	B,0006h
	LDDR			;also tests function of LDDR instruction 	
	JMP 	HFC00-5		;jumps to code in RAM from next 4 lines below:
;
H037C	NOP			;now in RAM 	
	NOP 	
	JMP 	H0382		;back to ROM
	HLT
;
; more testing of memory and stack functions
;	
H0382	NOP 	
	LXI 	SP,0000h
	LXIX  	0A55Ah
	LXIY  	0A55Ah
	LXI 	B,0A55Ah
	LXI 	D,0A55Ah
	LXI 	H,0A55Ah
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	PUSHIX	
	PUSHIY	
	POP 	B
	ORA 	B
	ORA 	C
	MVI 	C,04h
H03A4	POP 	D
	ANA 	D
	ORA 	E
	DCR 	C
	JRNZ  	H03A4
	POPIX 	
	MVI 	B,0FFh
	XRA 	B
	JNZ	H01C1
	MVI 	A,03h
	CALL	H03BF
	CNZ	H03C1
	JZ 	H01C1
	JR    	H03C7
H03BF	ANA 	A
	RET 	
H03C1	ORA 	A
	RNZ	
	JMP 	H01C1
	HLT
;
;done with diagnostic testing. begin boot process
; 	
H03C7	LXI 	SP,0000h
	LXI 	B,03E1h		;cursor position for message
	LXI 	H,H0708		;'INSERT DISKETTE'
	MOV 	E,M
	INX 	H
	LXIX  	H03D9
	JMP 	H0555
H03D9	OUT 	30h		;turn on FDD motor
	CALL	H059C		;status = ready for command
	MVI 	A,03h		
	OUT 	35h		;specify times/mode
	CALL	H05AB		;ready for output
;
;step rate time = 8ms
;head unload time = 240ms
;
	MVI 	A,8Fh
	OUT 	35h
;		
	CALL	H05AB		;ready for output
;
;head load time = 18ms
;DMA mode
;
	MVI 	A,12h
	OUT 	35h
;
	LXI 	H,HFC00+5
	MVI 	A,01h
	MOV 	M,A		;1 = data bytes per sector?
	INX 	H
	MVI 	A,10h		;16 sectors/track
	MOV 	M,A
	INX 	H
	MVI 	A,0Eh		;gap length
	MOV 	M,A
	INX 	H
	MVI 	A,0FFh		;256 bytes/sector
	MOV 	M,A
	LXI 	H,0000h
	SHLD	HFC00+33
	MVI 	A,00h		;drive 0
	STA 	HFC00+1
	CALL	H05E4		;recalibrate
	MVI 	A,27h
	STA 	HFC00+2		;track#
	CALL	H05D8		;seek outer track 39
H0418	MVI 	A,00h		;drive 0
	STA 	HFC00+1
	CALL	H05E4		;recalibrate
	LDA 	HFC00+20	;status
	ANA 	A
	JRNZ  	H0418		;loop if not successful
	LXI 	B,03E1h		;cursor position for message
	LXI 	H,H0762		;blank out insert diskette message
	MOV 	E,M
	INX 	H
	LXIX  	H0435
	JMP 	H0555
H0435	LXI 	H,HFC00+1
	MVI 	M,00h		;drive 0
	INX 	H
	MVI 	M,00h		;track 0
	INX 	H
	MVI 	M,00h		;head 0
	INX 	H
	MVI 	M,01h		;skew = 1
	MVI 	A,0Ch		;# of 256 byte pages to load
	STA 	HFC00+9		;so length of load = 0C00h
	LXI 	H,HF000
	SHLD	HFC00+10	;DMA load address = HF000
	LXI 	H,H0418
	SHLD	HFC00+33	;return address
	CALL	H0623
	JRZ   	H0418		;try again to read track 0
	JMP 	HF000		;go execute boot0
;
;	DIAGNOSTIC CODE 001 error
;
;	sound continuous tone = 1Khz
;
H045C	MVI 	A,14h		;nnnnn1nn = speaker on
	OUT 	18h
	LXI 	H,H0718
	LXIX  	H0469
	JR    	H0499
H0469	JR    	H0469
	HLT 	
;
;	DIAGNOSTIC CODE 002 error
;
H046C	LXI 	H,H073D
	LXIX  	H0475
	JR    	H0499
;
;	sound repeated tones 1 per second
;
H0475	MVI 	A,14h		;nnnnn1nn = speaker on
	OUT 	18h
	MVI 	B,05h		;delay loop
	LXI 	D,0FFFFh
H047E	LXI 	H,39DEh
H0481	DAD 	D
	JRC   	H0481
	DJNZ  	H047E
	MVI 	A,10h		;nnnnn0nn = speaker off
	OUT 	18h
	MVI 	B,05h
	LXI 	D,0FFFFh
H048F	LXI 	H,39DEh
H0492	DAD 	D
	JRC   	H0492
	DJNZ  	H048F
	JR    	H0475
H0499	MOV 	E,M
	INX 	H
	LXI 	B,0000h
	JMP 	H0555
;
; for character (mono) mode
;
H04A1	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h	
	JRNZ  	H04A1	;loop until FIFO parm buffer empty
	MVI 	A,49h
	OUT 	39h	;specify cursor position
	XRA 	A
	OUT 	38h	;word address = 0000
	OUT 	38h
	MVI 	B,04h	;loop 4 times
H04B4	LXI 	H,03FFFh	;# of RMW cycles
	MVI 	A,4Ch
	OUT 	39h	;figure drawing parms
	MVI 	A,02h
	OUT 	38h	;character display mode
	MOV 	A,L
	OUT 	38h	;DC drawing parm low
	MOV 	A,H
	OUT 	38h	;DC drawing parm high
	MVI 	A,4Ah
	OUT 	39h	;mask register load
	MVI 	A,0FFh
	OUT 	38h	;mask = FFFF
	OUT 	38h
	MVI 	A,20h	;write data into display memory
	OUT 	39h	;word replace with pattern
	XRA 	A
	OUT 	38h	;word = 0000
	OUT 	38h
H04D8	IN  	38h	
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H04D8	;loop until FIFO parm buffer is empty
	DJNZ  	H04B4	;repeat 4 times
	PCIX
;
; for graphics (color) mode
;
;initialize/clear color memory bank for color in acc
;port 2D = color control register:
;1=blue 2=green 4=red
; 	
H04E4	OUT 	2Dh	;select color memory bank
H04E6	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H04E6	;loop until FIFO parm buffer is empty
	MVI 	A,49h
	OUT 	39h	;specify cursor position
	XRA 	A
	OUT 	38h	;word address = 0000
	OUT 	38h
	OUT 	38h	;dot address = 00
	MVI 	A,4Ah
	OUT 	39h	;mask register load
	MVI 	A,0FFh
	OUT 	38h	;mask = FFFF
	OUT 	38h
H0503	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0503	;loop until FIFO parm buffer empty
	MVI 	A,78h
	OUT 	39h	;PRAM load command (start addr = 8)
	MVI 	B,08h
	MVI 	A,0FFh
H0513	OUT 	38h	;PRAM address 8-15 = FFh
	DJNZ  	H0513
H0517	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0517	;loop until FIFO parm buffer is empty
	MVI 	A,4Ch
	OUT 	39h	;figure drawing parms
	MVI 	A,10h
	OUT 	38h	;graphics character draw mode
	LXI 	B,0027h	;# of RMW cycles
	MOV 	A,C
	OUT 	38h	;DC drawing parm low
	MOV 	A,B
	OUT 	38h	;dc drawing parm high
	LXI 	B,0668h	;D drawing parm
	MOV 	A,C
	OUT 	38h
	MOV 	A,B
	OUT 	38h
	MVI 	A,22h
	OUT 	39h	;write data into display memory (reset to 0)
	MVI 	A,68h
	OUT 	39h	;execute graphics fill pattern
	MVI 	A,49h
	OUT 	39h	;specify cursor position
	XRA 	A
	OUT 	38h	;word address = 0000
	OUT 	38h
	OUT 	38h	;dot address = 00
H054C	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H054C	;loop until FIFO parm buffer is empty
	PCHL
;	
H0555	IN  	2Ch
	ANI 	01h	;0 = mono 1 = color
	JRNZ  	H059A	;if color, return to IX caller
;
; for character (mono) mode
; print message (HL) to display
;
H055B	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H055B	;loop until FIFO parm buffer empty
H0563	MVI 	A,49h
	OUT 	39h	;specify cursor position
	MOV 	A,C
	OUT 	38h	;BC = word address
	MOV 	A,B
	OUT 	38h
	MVI 	A,4Ah
	OUT 	39h	;mask register load
	MVI 	A,0FFh
	OUT 	38h	;mask = FFFF
	MVI 	A,0FFh
	OUT 	38h
H0579	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0579	;loop until FIFO parm buffer empty
	MVI 	A,20h	;write data into display memory
	OUT 	39h	;word replace with pattern
	MOV 	A,M
	OUT 	38h	;word 00 (M)
	MVI 	A,00h
	OUT 	38h
	INX 	B	;cursor position
	INX 	H	;next character in message
H058E	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H058E	;loop until parm buffer empty
	DCR 	E	;character counter of message
	JNZ	H0563
H059A	PCIX
;
; loop until FDD data register ready for command
;
; port 34h = upd765 main status register
;  	
H059C	OUT 	30h	;turn on FDD motor
	IN  	34h
	ANI 	10h
	JRNZ  	H059C	;loop until DDC ready
	IN  	34h
	ANI 	0Fh
	JRNZ  	H059C	;loop until device ready
	RET
;
; loop until FDD data port is ready for an OUT instruction
;  	
H05AB	IN  	34h
	BIT   	7,A
	JRZ   	H05AB	;loop until data register is ready
	BIT   	6,A
	JRNZ  	H05AB	;loop until direction is processor to data reg
	RET
;
; loop until FDD data port is ready for an IN instruction
; 	
H05B6	IN  	34h
	BIT   	7,A
	JRZ   	H05B6	;loop until data register is ready
	BIT   	6,A
	JRZ   	H05B6	;loop until direction is data reg to processor
	RET
;
;return drive HFC00+1 ready status. NZ if ready.
; 	
H05C1	CALL	H059C	;status = ready for command
	MVI 	A,04h
	OUT 	35h	;sense drive status
	CALL	H05AB	;ready for output
	LDA 	HFC00+1	;drive#
	OUT 	35h
	CALL	H05B6	;ready for input
	IN  	35h
	ANI 	20h	;ready bit
	RET
;
;execute FDD seek command
; 	
H05D8	PUSH	PSW
	PUSH	B
	DI  	
	MVI 	A,0Fh
	STA 	HFC00
	MVI 	B,03h
	JR    	H05EE
;
;execute FDD recalibrate command
;
H05E4	PUSH	PSW
	PUSH	B
	DI  	
	MVI 	A,07h
	STA 	HFC00
	MVI 	B,02h
H05EE	CALL	H0607
	EI  	
H05F2	LDA 	HFC00+19
	BIT   	6,A
	JRNZ  	H05F2		;loop until command completed
	LDA 	HFC00+12
	BIT   	6,A
	JRNZ  	H0601
	XRA 	A
H0601	STA 	HFC00+20	;=0 if successful
	POP 	B
	POP 	PSW
	RET
;
;execute FDD command from HFC00 buffer. B = # of command parms.
; 	
H0607	CALL	H05C1		;drive ready?
	JRZ   	H0607		;loop until drive ready
	CALL	H059C		;status = ready for command
	PUSH	H
	LXI 	H,HFC00		;command parm buffer
H0613	CALL	H05AB		;ready for output
	MOV 	A,M
	OUT 	35h
	INX 	H
	DJNZ  	H0613
	LXI 	H,HFC00+19
	SETB  	6,M		;flag as command ready for IRQ execution
	POP 	H
	RET
;
;read FDD into F000-FBFF
; 	
H0623	DI  	
	PUSH	H
	PUSH	D
	PUSH	B
;
;DMA FDD CH0 single increment write non-auto
;
	MVI 	C,44h		;DMA mode
	MVI 	B,60h		;DMA status
	CALL	H064C		;set FDD DMA parms to load to F000-FBFF
	MVI 	C,46h		;read MFM data
	MOV 	A,C
	STA 	HFC00
	MVI 	B,09h		;9 parm bytes
	CALL	H0607
	EI  	
H063A	LDA 	HFC00+19
	BIT   	6,A
	JRNZ  	H063A		;wait for command completion during IRQ
	LDA 	HFC00+12	;sector ID after execution
	ANI 	0C0h
	CPI 	40h		;nz if all 12 sectors read ok
	POP 	B
	POP 	D
	POP 	H
	RET
;
;on entry: B = status reg   C = DMA mode
;          HFC00+9     = # of 256 byte pages to load
;          HFC00+10,11 = load address
; 	
H064C	PUSH	PSW
	XRA 	A
	OUT 	4Dh		;clear temp reg
	MOV 	A,C
	OUT 	4Bh		;DMA mode
	LDA 	HFC00+10
	OUT 	40h		;FDD DMA CH0 base address (F000h) load address
	LDA 	HFC00+11
	OUT 	40h
	MVI 	A,0FFh
	OUT 	41h		;FDD DMA CH0 word address low
	LDA 	HFC00+9		;address high (C0h)		
	DCR 	A		
	OUT 	41h		;FDD DMA CH0 word address (0BFFh) length of load
	MOV 	A,B
	OUT 	48h		;DMA status register
	MVI 	A,0Eh
	OUT 	4Fh		;mask = 01001111
	POP 	PSW
	RET
;
;keyboard IRQ handler
; 	
H0670	PUSH	PSW
	IN  	12h		;keyboard status
	STA 	HFC00+22
	BIT   	0,A
	JRZ   	H0688		;character not available
	MVI 	A,01h
	OUT 	12h		;set control reg 1
	IN  	12h		;read status reg 1
	STA 	HFC00+23
	IN  	10h		;keyboard data
	STA 	HFC00+24
H0688	LDA 	HFC00+22
	BIT   	2,A
	JRNZ  	H0697		;taken if transmit buffer empty
	MVI 	A,28h
	OUT 	12h		;reset pending transmit IRQ
	XRA 	A
	STA 	HFC00+25
H0697	MVI 	A,30h
	OUT 	12h		;enable error checking
	MVI 	A,38h
	OUT 	12h		;7201 channel A end of interrupt
	MVI 	A,20h
	OUT 	08h		;set 8259A end of interrupt
	POP 	PSW
	EI  	
	RETI
;
;FDD IRQ handler. execute command in HFC00 buffer.
;  	
H06A7	PUSH	H
	PUSH	B
	PUSH	PSW
	LDA 	HFC00
	ORA 	A
	JRZ   	H06FD		;taken if reset command
	IN  	34h		;FDD status
	BIT   	5,A
	JRNZ  	H06D8		;result not ready
	BIT   	4,A
	JRNZ  	H06E4		;valid FDD command has been given
	MVI 	A,08h
	OUT 	35h		;sense interrupt status
	CALL	H05B6		;ready for input
	IN  	35h
	STA 	HFC00+12	;status reg 0
	CALL	H05B6		;ready for input
	IN  	35h
	STA 	HFC00+15	;present track#
	LDA 	HFC00+12	;status reg 0
	RLC 	
	JRC   	H06FD		;command never started or got interrupted
	ANI 	40h
	JRNZ  	H06F8		;abnormal termination of command
H06D8	MVI 	A,20h
	OUT 	08h		;set 8259A end of interrupt
	POP 	PSW
	POP 	B
	POP 	B
	POP 	H
	LHLD	HFC00+33	;loop back to H0418 to retry
	PCHL
;
;read 7 byte results data into HFC00+12 to HFC00+18
; 	
H06E4	XRA 	A
	OUT 	4Dh		;clear DMA1 temp reg
	CMA 	
	OUT 	4Fh		;DMA1 mask = FF
	MVI 	B,07h
	LXI 	H,HFC00+12
H06EF	CALL	H05B6		;ready for input
	IN  	35h
	MOV 	M,A
	INX 	H
	DJNZ  	H06EF		;read results data into HFC00+12 to HFC00+18
H06F8	LXI 	H,HFC00+19
	RES   	6,M		;flag as IRQ command complete
H06FD	MVI 	A,20h
	OUT 	08h		;set 8259A end of interrupt
	POP 	PSW
	POP 	B
	POP 	H
	EI  	
	RETI			;end of FDD IRQ handler
;  	
H0707	HLT			;unsupported IRQ jumps here
;
H0708	DB 0Fh
	DB 'INSERT DISKETTE'
H0718	DB 24h
	DB 'DIAGNOSTIC CODE  0001           0.06'
H073D	DB 24h
	DB 'DIAGNOSTIC CODE  0002           0.06'
H0762	DB 0Fh
	DB '               '
H0772	DB 00h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
;
; 0780h = 8259 master IRQ table
; all unsupported except keyboard and FDD
;
	NOP 	
	JMP 	H0707	;IRQ0
	NOP 	
	JMP 	H0707	;IRQ1
	NOP 	
	JMP 	H0707	;IRQ2
	NOP 	
	JMP 	H0707	;IRQ3
	NOP 	
	JMP 	H0670	;keyboard IRQ4
	NOP 	
	JMP 	H0707	;IRQ5
	NOP 	
	JMP 	H06A7	;FDD IRQ6
	NOP 	
	NOP 	
	NOP 	
	NOP
;
; 07A0h = 8259 slave IRQ table
; all unsupported
; 	
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
	NOP 	
	JMP 	H0707
;
;	init data for 7201 keyboard serial interface
;
H07C0	DB 18h	;channel reset
	DB 14h	;reset external status interrupt. set control reg 4
	DB 37h	;enable parity, even parity, async 1 stop bit
	DB 03h	;set control reg 3 (receiver control)
	DB 0E1h	;receiver enabled 8 bits/char, DCD enabled 
	DB 05h	;set control reg 5 (transmitter control)
	DB 0EAh	;transmitter enabled 8 bits/char, DTR active, no RTS
	DB 02h	;set control reg 2 (processor/bus interface control)
	DB 00h	;??? unlikely all parms 0 ???
	DB 01h	;set control reg 1 (interrupt control)
	DB 10h	;interrupt and issue DMA request on all received chars
;
;H07CB = 8 sync parms for monochrome
;
;mixed graphics and character display
;non-interlaced
;dynamic ram - refresh
;draw during retrace
;80 display words/line
;vsync width = 16
;hsync width = 3
;hfrontporch = 7
;hbackporch = 19
;vfrontporch = 1
;vbackporch = 4
;display lines/field = 400
;
H07CB	DB 14h,4Eh,02h,1Ah,12h
	DB 01h,90h,11h
;
;H07D3 = 8 sync parms for color
;
;graphics display
;non-interlaced
;dynamic ram - refresh
;draw during active display
;40 display words/line
;vsync width = 9
;hsync width = 4
;hfrontporch = 5
;hbackporch = 5
;vfrontporch = 7
;vbackporch = 25
;display lines/field = 400
;
H07D3	DB 06h,26h,23h,11h,04h,07h,90h,65h
;
	DB 0E8h,0E4h,0C9h,0C3h,0C8h,0C9h,40h,0E4h
	DB 0E2h,0C8h,0C9h,0E8h,0C1h,0D4h,0C1h,40h
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
;
	JMP 	H05D8	;FDD seek
	JMP 	H0623	;FDD load boot0

	END
