;	Epson QX-10 IPL v0.03

	ORG	0000h

	MACLIB	Z80

HF000	EQU	0F000h	;boot0 address
HFC00	EQU	0FC00h	;FDD and keyboard command parm buffer during IRQ
;
;HFC00 		= command
;  +1  		= drive#
;  +2  		= track#
;  +3  		= head#
;  +4  		= skew
;  +5  		= data bytes / sector
;  +6  		= sectors/track
;  +7  		= gaplength
;  +8  		= bytes/sector
;  +9  		= # of pages to load
;  +10 		= DMA address word
;  +12 to +18 	= FDD status reg 0-7
;  +19 		= bit 6 set then command ready for IRQ execution
;  +20 		= 0 if command successful
;  +22 		= keyboard status reg 0 (main)
;  +23 		= keyboard status reg 1
;  +24 		= keyboard data
;  +25 		= keyboard transmit IRQ state
;  +33 		= return address
;
	LXI 	SP,0000h
	MVI 	A,10h		;memory bank = 0
	OUT 	18h
	IM0
;
;	init speaker timer#1 = 100ms
;   	
	MVI 	A,32h
	OUT 	03h
	MVI 	A,00h
	OUT 	00h
	MVI 	A,01h
	OUT 	00h
;
;	init speaker timer#2 frequency = 1KHz
;
	MVI 	A,36h
	OUT 	07h
	MVI 	A,00h
	OUT 	04h
	MVI 	A,08h
	OUT 	04h
;
;	init keyboard clock = 1200BPS
;
	MVI 	A,76h
	OUT 	07h
	MVI 	A,80h
	OUT 	05h
	MVI 	A,06h
	OUT 	05h
;
;	init RS232C clock = 9600BPS
;
	MVI 	A,0B6h
	OUT 	07h
	MVI 	A,0D4h
	OUT 	06h
	MVI 	A,00h
	OUT 	06h
;
;	init 8259A interrupt controller (master)
;
	MVI 	A,95h	;ICW1 = edge sense, 4-byte, multi, with ICW4
	OUT 	08h
	MVI 	A,07h	;ICW2 = interrupt address table = 780H
	OUT 	09h
	MVI 	A,80h	;ICW3 = slave is connected to master
	OUT 	09h
	MVI 	A,02h	;ICW4 = automatic end of interrupt
	OUT 	09h
	MVI 	A,02h	;OCW1 = 00000010 interrupt mask
	OUT 	09h
;
;	init 8259A slave
;
	MVI 	A,0B5h	;ICW1 = edge sense, 4-byte, multi, with ICW4
	OUT 	0Ch
	MVI 	A,07h	;ICW2 = interrupt address = 7A0H
	OUT 	0Dh
	MVI 	A,07h	;ICW3 = slave interrupt level 7 in master
	OUT 	0Dh
	MVI 	A,02h	;ICW4 = automatic end of interrupt	
	OUT 	0Dh
	MVI 	A,20h	;OCW1 = 00100000 interrupt mask
	OUT 	0Dh
;
;	init 7201 keyboard serial interface
;
	LXI 	H,H07C0
	MVI 	B,0Bh
	MVI 	C,12h
	OUTIR
;
;	init reference clock = 32.768KHz and FDD motor timer length
; 	
	LXI 	D,0A2Eh
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Ah
	DCR 	C
	OUTP  	E	;46818 write data 2Eh to address 0Ah
;
;	enable FDD timer and set clock = 24hr
;
	MVI 	D,0Bh
	MVI 	E,0Ah
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Bh
	DCR 	C
	OUTP  	E	;46818 write data 0Ah to address 0Bh
;
;	flag clock ram as valid
;
	LXI 	D,0D80h
	MVI 	C,3Dh
	OUTP  	D	;46818 clock address = 0Dh
	DCR 	C
	OUTP  	E	;46818 write data 80h to address 0Dh
;
;	init 8255 printer interface:
;		port A byte output
;		port B bit input
;		port C bit output
;		port C bit control
;
	MVI 	A,0A2h
	OUT 	17h
	MVI 	A,0Bh
	OUT 	17h	;set bit 5 port C
	MVI 	A,01h
	OUT 	17h	;set bit 0 port C
	MVI 	A,0Ah
	OUT 	17h	;reset bit 5 port C
;
;	init DMA controller #1:
;		CH1 = single mode, address decrement
;		CH1 CRT base address = H0772				
;		CH1 = PACK low, DREQ low, Extended Write, Fixed Priority
;		CH1 = Normal Timing, Controller Enabled
;		CH1 = Addr Holt CH0 disabled, Mem to Mem disabled
;
	XRA 	A
	OUT 	4Dh	;master clear
	MVI 	A,49h	;01001001
	OUT 	4Bh	;CH1 = single mode, address decrement
	LXI 	H,H06D4	;CH1 base address for CRT
	MOV 	A,L
	OUT 	42h
	MOV 	A,H
	OUT 	42h
	MVI 	A,01h	;CH1 word address
	OUT 	43h
	XRA 	A
	OUT 	43h
	MVI 	A,60h	;01100000
	OUT 	48h	;8 more CH1 parameters listed above
	MVI 	A,0Dh	;00001101
	OUT 	4Fh	;CH1 mask register
;
;	init 7220 Graphics Display Controller
;
;	port 39h	W= send command R= read data
;	port 38h	W= send parm	R= status
;
	MVI 	A,00h	;reset
	OUT 	39h
H00BC	NOP 	
	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H00BC	;loop until FIFO parm buffer empty
	MVI 	A,6Fh	;generate vert sync as master
	OUT 	39h
	MVI 	A,0Eh	;specify sync format (blank the display)
	OUT 	39h
;
;output 8 sync parms for monochrome:
;
;mixed graphics and character display
;non-interlaced
;dynamic ram - refresh
;draw during retrace
;80 display words/line
;vsync width = 16
;hsync width = 3
;hfrontporch = 7
;hbackporch = 19
;vfrontporch = 1
;vbackporch = 4
;display lines/field = 400
;
	MVI 	A,14h
	OUT 	38h
	MVI 	A,4Eh
	OUT 	38h
	MVI 	A,02h
	OUT 	38h
	MVI 	A,1Ah
	OUT 	38h
	MVI 	A,12h
	OUT 	38h
	MVI 	A,01h
	OUT 	38h
	MVI 	A,90h
	OUT 	38h
	MVI 	A,11h
	OUT 	38h
;
H00ED	NOP 	
	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H00ED	;loop until FIFO parm buffer empty
	MVI 	A,4Bh
	OUT 	39h	;cursor and character characteristics
	MVI 	A,0Fh
	OUT 	38h	;16 lines per character row (no display cursor)
	MVI 	A,6Dh
	OUT 	38h	;cursor top line# = 13
	MVI 	A,70h
	OUT 	38h	;cursor bottom line# = 14
	MVI 	A,46h
	OUT 	39h	;zoom command
	MVI 	A,00h
	OUT 	38h	;zoom factor of 1
	NOP 	
	OUT 	3Ah	;zoom magnification 0
H0111	NOP 	
	IN  	38h
	ANI 	06h	;FIFO state
	XRI 	04h
	JRNZ  	H0111	;loop until FIFO parm buffer empty
	MVI 	A,47h
	OUT 	39h	;pitch command
	MVI 	A,50h
	OUT 	38h	;80 word addresses / line
	MVI 	A,70h
	OUT 	39h	;PRAM load command (start addr = 0)
	MVI 	A,00h
	OUT 	38h	;clear PRAM addr 0
	MVI 	A,00h
	OUT 	38h	;clear PRAM addr 1
	MVI 	A,00h
	OUT 	38h	;clear PRAM addr 2
	MVI 	A,19h
	OUT 	38h	;PRAM addr 3 = 19h
	LXIX  	H013D
	JMP 	H03A7
;
;done with video init
;test the processor by executing all instructions and checking registers.
;display DIAGNOSTIC CODE 001 if processor error.
;also test the memory.
;display DIAGNOSTIC CODE 002 if memory error
;
H013D	MVI 	A,6Bh
	OUT 	39h	;start display and end idle mode
	XRA 	A
	OUT 	4Dh	;master clear (hardware reset)
	MVI 	B,00h
	MOV 	A,B
	ORA 	A
	JRZ   	H014E
H014A	JMP 	H0362	;DIAGNOSTIC CODE 001 ERROR
	HLT 	
H014E	ADI 	0D2h
	RLC 	
	JRNC  	H014A
	MOV 	B,A
	MOV 	C,B
	MOV 	D,C
	MOV 	E,D
	MOV 	H,E
	MOV 	A,H
	JP 	H014A
	XRI 	0A5h
	JRNZ  	H014A
	LXI 	B,0F1Eh
	LXI 	D,2D3Ch
	LXI 	H,4B5Ah
	EXX 	
	EXX 	
	XCHG	
	ANA 	B
	XRA 	C
	ORA 	D
	ANA 	E
	ADD 	H
	SUB 	L
	CPI 	4Bh
	JRNZ  	H014A
	XRA 	A
	LXI 	B,0102h
	LXI 	D,0304h
	LXI 	H,0506h
	ADD 	B
	ADD 	C
	ADD 	D
	ADD 	E
	ADD 	H
	ADD 	L
	CPI 	15h
	JNZ	H014A
	DAD 	B
	DAD 	D
	DAD 	H
	ADD 	H
	ADD 	L
	CPI 	3Fh
	JNZ	H014A
	LXIX  	H01A2
	LXI 	B,0001h
	LXI 	D,0001h
	LXI 	SP,0000h
H01A2	NOP 	
	NOP 	
	XRA 	A
	DADX  	B 
	DADX  	D 
	DADX  	SP
	LDX   	A,00h
	CPI 	0AFh
	JNZ	H014A
	LXIY  	H01A2
	DADY  	B 
	DADY  	D 
	DADY  	SP
	LDY   	A,00h
	CPI 	0AFh
	JNZ	H014A
	MVI 	A,00h
	LXI 	H,H030B
	LXI 	B,0003h
	CCI   	
	JNZ	H014A
	INR 	A
	JZ 	H014A
	DCR 	A
	JNZ	H014A
	MVI 	A,09h
	ACI 	01h
	DAA 	
	CPI 	10h
	JNZ	H014A
	CMA 	
	CPI 	0EFh
	JNZ	H014A
	NEG   	
	CPI 	11h
	JNZ	H014A
	STC 	
	JNC	H014A
	CMC 	
	JC 	H014A
	LXI 	H,H0209
	LXIX  	H020C
	LXIY  	H020F
	PCHL	
	JMP 	H014A
	HLT 	
H0209	PCIX  	
	HLT 	
H020C	PCIY  	
	HLT 	
H020F	MVI 	B,05h
H0211	DJNZ  	H0211
	XRA 	A
	ORA 	B
	JNZ	H014A
	LXI 	H,HF000
	LXI 	B,1000h
H021E	MVI 	M,0FFh
	INX 	H
	DCX 	B
	MOV 	A,B
	ORA 	C
	JRNZ  	H021E
	LXI 	B,0FFFh
	LXI 	H,0FFFFh
	LXI 	D,0FFFEh
H022F	LDAX	D
	ANA 	M
	JZ 	H0372
	CPI 	0FFh
	JNZ	H0372
	XRA 	M
	MOV 	M,A
	MOV 	A,M
	ORA 	A
	JNZ	H0372
	DCX 	H
	DCX 	B
	DCX 	D
	MOV 	A,B
	ORA 	C
	JRNZ  	H022F
	MOV 	A,M
	XRI 	0FFh
	MOV 	M,A
	JNZ	H0372
	MVI 	A,41h
	RLC 	
	JC 	H014A
	RAL 	
	JNC	H014A
	RAL 	
	JC 	H014A
	RRC 	
	JNC	H014A
	RAR 	
	JC 	H014A
	LXIX  	0FFFFh
	STX   	A,00h
	RLCX  	00h
	JNC	H014A
	RALX  	00h
	JNC	H014A
	RRCX  	00h
	JNC	H014A
	RARX  	00h
	JNC	H014A
	SLAX  	00h
	JNC	H014A
	SRAX  	00h
	JC 	H014A
	SRLX  	00h
	JC 	H014A
	LXI 	H,0FFFFh
	MVI 	A,0Eh
	RLD   	
	JZ 	H014A
	RRD   	
	JZ 	H014A
	BIT   	7,A
	JNZ	H014A
	BIT   	3,A
	JZ 	H014A
	BIT   	6,M
	JZ 	H014A
	BITX  	1,00h
	JNZ	H014A
	SETB  	6,A
	SETB  	7,M
	SETX  	2,00h
	RES   	3,A
	RES   	0,M
	RESX  	5,00h
	ADDX  	00h
	JNC	H014A
	JZ 	H014A
	LXI 	D,HF000		;test function of RAM area F000h which
	LXI 	H,H02E7		;will be used for boot0
	LXI 	B,0010h
	LDIR			;also tests function of LDIR instruction  	
	MVI 	A,02h
H02E7	JR    	H02EA
	HLT 	
H02EA	NOP 	
	JR    	H02EE
	HLT 	
H02EE	DCR 	A
	ORA 	A
	JZ 	H02F7		;back to ROM
	JNZ	HF000		;jump to H02E7 instructions now in RAM
	HLT 	
H02F7	LXI 	D,HFC00		;test function of ram area FC00h which
	LXI 	H,H0305+6	;will be used for FDD IRQ command parms
	LXI 	B,0006h
	LDDR			;also tests function of LDDR instruction  	
	JMP 	HFC00-5		;jumps to code in RAM from next 4 lines below:
;
H0305	NOP			;now in RAM
	NOP 	
	JMP 	H030B		;back to ROM
	HLT
;
; more testing of memory and stack functions
;	
H030B	NOP 	
	LXI 	SP,0000h
	LXIX  	0A55Ah
	LXIY  	0A55Ah
	LXI 	B,0A55Ah
	LXI 	D,0A55Ah
	LXI 	H,0A55Ah
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	PUSHIX	
	PUSHIY	
	POP 	B
	ORA 	B
	ORA 	C
	MVI 	C,04h
H032D	POP 	D
	ANA 	D
	ORA 	E
	DCR 	C
	JRNZ  	H032D
	POPIX 	
	MVI 	B,0FFh
	XRA 	B
	JNZ	H014A
	MVI 	A,03h
	CALL	H0348
	CNZ	H034A
	JZ 	H014A
	JR    	H0350
H0348	ANA 	A
	RET 	
H034A	ORA 	A
	RNZ	
	JMP 	H014A
	HLT
;
;done with diagnostic testing. begin boot process
; 	
H0350	LXI 	SP,0000h
	LXI 	B,03E1h		;cursor position for message
	LXI 	H,H065E		;'INSERT DISKETTE'
	MOV 	E,M
	INX 	H
	LXIX  	H03F9
	JMP 	H04AD
;
;	DIAGNOSTIC CODE 001 error
;
;	sound continuous tone = 1Khz
;
H0362	MVI 	A,14h		;nnnnn1nn = speaker on
	OUT 	18h
	LXI 	H,H066E
	LXIX  	H036F
	JR    	H039F
H036F	JR    	H036F
	HLT 	
;
;	DIAGNOSTIC CODE 002 error
;
H0372	LXI 	H,H0699
	LXIX  	H037B
	JR    	H039F
;
;	sound repeated tones 1 per second
;
H037B	MVI 	A,14h		;nnnnn1nn = speaker on
	OUT 	18h
	MVI 	B,05h		;delay loop
	LXI 	D,0FFFFh
H0384	LXI 	H,39DEh
H0387	DAD 	D
	JRC   	H0387
	DJNZ  	H0384
	MVI 	A,10h		;nnnnn0nn = speaker off
	OUT 	18h
	MVI 	B,05h
	LXI 	D,0FFFFh
H0395	LXI 	H,39DEh
H0398	DAD 	D
	JRC   	H0398
	DJNZ  	H0395
	JR    	H037B
H039F	MOV 	E,M
	INX 	H
	LXI 	B,0000h		;cursor position
	JMP 	H04AD
;
H03A7	NOP 	
	IN  	38h
	ANI 	06h
	XRI 	04h
	JRNZ  	H03A7
	LXI 	H,07D0h		;# of RMW cycles
	MVI 	A,0Ch
	OUT 	39h		;blank the display
H03B7	NOP 	
	IN  	38h
	ANI 	06h		;FIFO state
	XRI 	04h
	JRNZ  	H03B7		;loop until FIFO parm buffer empty
	MVI 	A,49h
	OUT 	39h		;specify cursor position
	XRA 	A
	OUT 	38h		;word address = 0000
	OUT 	38h
	MVI 	A,4Ch
	OUT 	39h		;figure drawing parms
	MVI 	A,02h
	OUT 	38h		;character display mode
	MOV 	A,L
	OUT 	38h		;DC drawing parm low
	MOV 	A,H
	OUT 	38h		;DC drawing parm high
	MVI 	A,4Ah
	OUT 	39h		;mask register load
	MVI 	A,0FFh
	OUT 	38h		;mask = FFFF
	OUT 	38h
	MVI 	A,20h		;write data into display memory
	OUT 	39h		;word replace with pattern
	XRA 	A
	OUT 	38h		;word = 0000
	OUT 	38h
H03EA	NOP 	
	IN  	38h
	ANI 	06h		;FIFO state
	XRI 	04h
	JRNZ  	H03EA		;loop until FIFO parm buffer is empty
	MVI 	A,0Dh
	OUT 	39h		;enable the display
	PCIX			;jump to H013D  	
H03F9	OUT 	30h		;turn on FDD motor
	CALL	H04F7		;status = ready for command
	MVI 	A,03h
	OUT 	35h		;specify times/mode
	CALL	H0504		;ready for output
;
;step rate time = 8ms
;head unload time = 240ms
;
	MVI 	A,8Fh
	OUT 	35h
;
	CALL	H0504		;ready for output
;
;head load time = 18ms
;DMA mode
;
	MVI 	A,12h
	OUT 	35h
;
	LXI 	H,HFC00+5
	MVI 	A,01h
	MOV 	M,A		;1 = data bytes/sector?
	INX 	H
	MVI 	A,10h		;sectors/track
	MOV 	M,A
	INX 	H
	MVI 	A,0Eh		;gap length
	MOV 	M,A
	INX 	H
	MVI 	A,0FFh		;256 bytes/sector
	MOV 	M,A
	LXI 	H,0000h
	SHLD	HFC00+33
	MVI 	A,00h		;drive 0
	STA 	HFC00+1
	CALL	H053D		;recalibrate
	MVI 	A,27h
	STA 	HFC00+2		;track#
	CALL	H0531		;seek outer track 39
H0438	MVI 	A,00h		;drive 0
	STA 	HFC00+1
	CALL	H053D		;recalibrate
	LDA 	HFC00+20	;status
	ANA 	A
	JRNZ  	H0438		;loop if not successful
	LXI 	B,03E1h		;cursor position for message
	LXI 	H,H06C4		;blank out insert diskette message
	MOV 	E,M
	INX 	H
	LXIX  	H0455
	JMP 	H04AD
H0455	LXI 	H,HFC00+1
	MVI 	M,00h		;drive 0
	INX 	H
	MVI 	M,00h		;track 0
	INX 	H
	MVI 	M,00h		;head 0
	INX 	H
	MVI 	M,01h		;skew = 1
	MVI 	A,0Ch		;# of 256 byte pages to load
	STA 	HFC00+9		;so length of load = 0C00h
	LXI 	H,HF000
	SHLD	HFC00+10	;DMA load address = HF000
	LXI 	H,H0438
	SHLD	HFC00+33	;return address
	CALL	H057C
	JRZ   	H0438		;try again to read track 0
	JMP 	HF000		;go execute boot0
;
;on entry: B = status reg   C = DMA mode
;          HFC00+9     = # of 256 byte pages to load
;          HFC00+10,11 = load address
;
H047C	PUSH	PSW
	XRA 	A
	OUT 	4Dh		;clear temp reg
	MOV 	A,C
	OUT 	4Bh		;DMA mode
	LDA 	HFC00+10
	OUT 	40h		;FDD DMA CH0 base address (F000h) load address
	LDA 	HFC00+11
	OUT 	40h
	MVI 	A,0FFh
	OUT 	41h		;FDD DMA CH0 word address low
	LDA 	HFC00+9		;address high (C0h)
	DCR 	A
	OUT 	41h		;FDD DMA CH0 word address (0BFFh) length of load
	MOV 	A,B
	OUT 	48h		;DMA status register
	MVI 	A,0Eh
	OUT 	4Fh		;mask = 01001111
	POP 	PSW
	RET
;
; ??? not executed
;	
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	LXIX  	H04F2
	MOV 	B,H
	MOV 	C,L
	LXI 	H,0FD00h
H04AD	NOP 	
	IN  	38h
	ANI 	06h		;FIFO state
	XRI 	04h
	JRNZ  	H04AD		;loop until FIFO parm buffer is empty
H04B6	NOP 	
	MVI 	A,49h
	OUT 	39h		;specify cursor position
	MOV 	A,C		;BC = cursor position
	OUT 	38h
	MOV 	A,B
	OUT 	38h
	MVI 	A,4Ah
	OUT 	39h		;mask register load
	MVI 	A,0FFh
	OUT 	38h		;mask = FFFF
	MVI 	A,0FFh
	OUT 	38h
H04CD	NOP 	
	IN  	38h
	ANI 	06h		;FIFO state
	XRI 	04h
	JRNZ  	H04CD		;loop until FIFO parm buffer empty
	MVI 	A,20h		;write data into display memory
	OUT 	39h		;word replace with pattern
	MOV 	A,M
	OUT 	38h		;word 00 (M)
	MVI 	A,00h
	OUT 	38h
	INX 	B		;cursor position
	INX 	H		;next character in message
H04E3	NOP 	
	IN  	38h
	ANI 	06h		;FIFO state
	XRI 	04h
	JRNZ  	H04E3		;loop until FIFO parm buffer is empty
	DCR 	E		;character counter of message
	JNZ	H04B6
	PCIX
;
; not executed - see above
; 	
H04F2	POP 	H
	POP 	D
	POP 	B
	POP 	PSW
	RET
;
; loop until FDD data register ready for command
;
; port 34h = upd765 main status register
;
H04F7	IN  	34h
	ANI 	10h
	JRNZ  	H04F7		;loop until DDC ready
	IN  	34h
	ANI 	0Fh
	JRNZ  	H04F7		;loop until device ready
	RET
;
; loop until FDD data port is ready for an OUT instruction
; 	
H0504	IN  	34h
	BIT   	7,A
	JRZ   	H0504		;loop until data register is ready
	BIT   	6,A
	JRNZ  	H0504		;loop until direction is processor to data reg
	RET
;
; loop until FDD data port is ready for an IN instruction
; 	
H050F	IN  	34h
	BIT   	7,A
	JRZ   	H050F		;loop until data register is ready
	BIT   	6,A
	JRZ   	H050F		;loop until direction is data reg to processor
	RET
;
;return drive HFC00+1 ready status. NZ if ready.
;	
H051A	CALL	H04F7		;status = ready for command
	MVI 	A,04h
	OUT 	35h		;sense drive status
	CALL	H0504		;ready for output
	LDA 	HFC00+1		;drive#
	OUT 	35h
	CALL	H050F		;ready for input
	IN  	35h
	ANI 	20h		;ready bit
	RET
;
;execute FDD seek command
; 	
H0531	PUSH	PSW
	PUSH	B
	DI  	
	MVI 	A,0Fh
	STA 	HFC00
	MVI 	B,03h
	JR    	H0547
;
;execute FDD recalibrate command
;
H053D	PUSH	PSW
	PUSH	B
	DI  	
	MVI 	A,07h
	STA 	HFC00
	MVI 	B,02h
H0547	CALL	H0560
	EI  	
H054B	LDA 	HFC00+19
	BIT   	6,A
	JRNZ  	H054B		;loop until command completed
	LDA 	HFC00+12
	BIT   	6,A
	JRNZ  	H055A
	XRA 	A
H055A	STA 	HFC00+20	;=0 if successful
	POP 	B
	POP 	PSW
	RET
;
;execute FDD command from HFC00 buffer. B = # of command parms.
;
H0560	CALL	H051A		;drive ready?
	JRZ   	H0560		;loop until drive ready?
	CALL	H04F7		;status = ready for command
	PUSH	H
	LXI 	H,HFC00		;command parm buffer
H056C	CALL	H0504		;ready for output
	MOV 	A,M
	OUT 	35h
	INX 	H
	DJNZ  	H056C
	LXI 	H,HFC00+19
	SETB  	6,M		;flag as command ready for IRQ execution
	POP 	H
	RET
;
;read FDD into F000-FBFF
;	
H057C	DI  	
	PUSH	H
	PUSH	D
	PUSH	B
;
;DMA FDD CH0 single increment write non-auto
;
	MVI 	C,44h		;DMA mode
	MVI 	B,60h		;DMA status
	CALL	H047C		;set FDD DMA parms to load to F000-FBFF
	MVI 	C,46h		;read MFM data
	JR    	H0598
;
; ??? not executed
;
	DI  	
	PUSH	H
	PUSH	D
	PUSH	B
	MVI 	C,48h		;DMA FDD CH0 single increment READ non-auto
	MVI 	B,60h
	CALL	H047C
	MVI 	C,45h
H0598	MOV 	A,C
	STA 	HFC00
	MVI 	B,09h		;9 parm bytes
	CALL	H0560
	EI  	
H05A2	LDA 	HFC00+19
	BIT   	6,A
	JRNZ  	H05A2		;wait for command completion during IRQ
	LDA 	HFC00+12	;sector ID after execution
	ANI 	0C0h
	CPI 	40h		;nz if all 12 sectors read ok
	POP 	B
	POP 	D
	POP 	H
	RET
;
;keyboard IRQ handler
;	
H05B4	PUSH	PSW
	IN  	12h		;keyboard status
	STA 	HFC00+22
	BIT   	0,A
	JRZ   	H05CC		;character not available
	MVI 	A,01h
	OUT 	12h		;set control reg 1
	IN  	12h		;read status reg 1
	STA 	HFC00+23
	IN  	10h		;keyboard data
	STA 	HFC00+24
H05CC	LDA 	HFC00+22
	BIT   	2,A
	JRNZ  	H05DB		;taken if transmit buffer empty
	MVI 	A,28h
	OUT 	12h		;reset pending transmit IRQ
	XRA 	A
	STA 	HFC00+25
H05DB	MVI 	A,30h
	OUT 	12h		;enable error checking
	MVI 	A,38h
	OUT 	12h		;7201 channel A end of interrupt
	MVI 	A,20h
	OUT 	08h		;set 8259A end of interrupt
	POP 	PSW
	EI  	
	RETI
;
;FDD IRQ handler. execute command in HFC00 buffer.
; 	
H05EB	PUSH	H
	PUSH	B
	PUSH	PSW
	LDA 	HFC00
	ORA 	A
	JRZ   	H0641		;taken if reset command
	IN  	34h		;FDD status
	BIT   	5,A
	JRNZ  	H061C		;result not ready
	BIT   	4,A
	JRNZ  	H0628		;valid FDD command has been given
	MVI 	A,08h
	OUT 	35h		;sense interrupt status
	CALL	H050F		;ready for input
	IN  	35h
	STA 	HFC00+12	;status reg 0
	CALL	H050F
	IN  	35h
	STA 	HFC00+15	;present track#
	LDA 	HFC00+12	;status reg 0
	RLC 	
	JRC   	H0641		;command never started or got interrupted
	ANI 	40h
	JRNZ  	H063C		;abnormal termination of command
H061C	MVI 	A,20h
	OUT 	08h		;set 8259A end of interrupt
	POP 	PSW
	POP 	B
	POP 	B
	POP 	H
	LHLD	HFC00+33	;loop back to H0438 to retry
	PCHL
;
;read 7 byte results data into HFC00+12 to HFC00+18
;	
H0628	XRA 	A
	OUT 	4Dh
	CMA 	
	OUT 	4Fh
	MVI 	B,07h
	LXI 	H,HFC00+12
H0633	CALL	H050F
	IN  	35h
	MOV 	M,A
	INX 	H
	DJNZ  	H0633
H063C	LXI 	H,HFC00+19
	RES   	6,M
H0641	MVI 	A,20h
	OUT 	08h
	POP 	PSW
	POP 	B
	POP 	H
	EI  	
	RETI			;end of FDD IRQ handler
;
;unsupported IRQ
;  	
H064B	MVI 	A,00h		;IRQ0 handler
	OUT 	20h		;disable CMOS RAM
	OUT 	4Dh		;clear temp reg
	HLT 	
H0652	HLT 	
H0653	HLT 	
H0654	HLT 	
H0655	HLT 	
H0656	HLT 	
H0657	HLT 	
H0658	HLT 	
H0659	HLT 	
H065A	HLT 	
H065B	HLT 	
H065C	HLT 	
H065D	HLT 	

H065E	DB 0Fh
	DB 'INSERT DISKETTE'
H066E	DB 2Ah
	DB 'DIAGNOSTIC CODE  0001                 0.03'
H0699	DB 2Ah
	DB 'DIAGNOSTIC CODE  0002                 0.03'
H06C4	DB 0Fh
	DB '               '
H06D4	DB 00h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh
;
; 0780h = 8259 master IRQ table
; all unsupported except keyboard and FDD
;
	NOP 	
	JMP 	H064B		;IRQ0
	NOP 	
	JMP 	H0652		;IRQ1
	NOP 	
	JMP 	H0654		;IRQ2
	NOP 	
	JMP 	H0655		;IRQ3
	NOP 	
	JMP 	H05B4		;keyboard IRQ4
	NOP 	
	JMP 	H065B		;IRQ5
	NOP 	
	JMP 	H05EB		;FDD IRQ6
	NOP 	
	NOP 	
	NOP 	
	NOP
;
; 07A0h = 8259 slave IRQ table
; all unsupported
;	
	NOP 	
	JMP 	H065D
	NOP 	
	JMP 	H0656
	NOP 	
	JMP 	H065C
	NOP 	
	JMP 	H0657
	NOP 	
	JMP 	H0658
	NOP 	
	JMP 	H0653
	NOP 	
	JMP 	H0659
	NOP 	
	JMP 	H065A
;
;	init data for 7201 keyboard serial interface
;
H07C0	DB 18h	;channel reset
	DB 14h	;reset external status interrupt. set control reg 4
	DB 37h	;enable parity, even parity, async 1 stop bit
	DB 03h	;set control reg 3 (receiver control)
	DB 0E1h	;receiver enabled 8 bits/char, DCD enabled 
	DB 05h	;set control reg 5 (transmitter control)
	DB 0EAh	;transmitter enabled 8 bits/char, DTR active, no RTS
	DB 02h	;set control reg 2 (processor/bus interface control)
	DB 00h	;??? unlikely all parms 0 ???
	DB 01h	;set control reg 1 (interrupt control)
	DB 10h	;interrupt and issue DMA request on all received chars
;
	DB 0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	DB 0FFh,0FFh,02h,04h,02h,00h,31h,0A6h
	DB 44h,44h,44h,49h,31h,0A6h,49h,0BDh

	END
