        ORG     1800H          ;Retyped from scans fjkraan@electrickery.nl. 2021-09-15 while keeping original line numbers ; page 1
PIA0DA  EQU     80H
PIA0DB  EQU     81H
PIA0CA  EQU     82H
SCAN1   EQU     0624H
HEX7SG  EQU     0678H
        LD      HL,0
        LD      (SCOBF+2),HL
        LD      (SCOBF+4),HL
M1:     LD      A,10            ;Set base score
        LD      (SCORE),A       ;TO 10.
M2:     LD      IX,SCOBF
        LD      A,8FH           ;Set PIO's Port A to
        OUT     (PIA0CA),A       ;byte output and port
                                ;B to byte input mode.
        LD      A,0FFH          ;Port A outputs
                                ;11111111.
        OUT     (PIA0DA),A       ;to keep the LED off.
M3      LD      D,0FEH
        LD      C,D
        LD      B,D
M4      IN      A,(PIA0DB)       ;Check if a key
        CP      0FEH            ;is pressed? If the
        JR      M5              ;START key was not
        RLC     B               ;pressed, then
                                ;alter the
        JR      C,M4            ;value of the registers
                                ;B,C,D.
        RLC     C               ;If the START key was
        JR      C,M1            ;pressed, then execute
        RLC     D               ;M5.
        JR      M4
        ;*********************************************
M5      LD      A,B             ;AND B,C,D
        AND     C
        AND     D
        OUT     (PIA0DA),A       ;Store the results of
                                ;ANDed B,C,D to Port A
                                ;to illuminate 1 to 3
                                ;LED lamps.
        LD      E,0FEH
M6:
; The next three instructions are to check
; whether the pressed key is released?
        IN      A,(PIA0DB)
        CP      0FFH
        JR      NZ,M6
        LD      H,0FFH          ;A time delay
M7      LD      L,0FFH          ;to prevent from
M8      DEC     L               ;detecting undesirable
        JR      NZ,M8           ;key bounce.
        DEC     H
        JR      NZ,M7
        IN      A,(PIA0DB)       ;Detect if a key
M9      RLC     E               ;is presses? If not,
        CP      0FFH            ;alter the value
        JR      Z,M9            ;of E.
        CP      B               ;If the key pressed
        JR      NZ,M10          ;has the same           ; page 2
        LD      B,E             ;internal code as
                                ;the content of the
                                ;B register,
                                ;load E to B.
        JR      M12
M10     CP      C               ;If the internal code of
        JR      NZ,M11          ;the key pressed is the same
        LD      C,E             ;as the content of C,
                                ;load E to C.
        JR      M12
M11     CP      D               ;If the internal code of
        JR      NZ,M13          ;the key pressed is the same
        LD      D,E             ;as the content of C,
                                ;load E to D.
M12     LD      A,B             ;Output the ANDed value
        AND     C               ;of B,C,D to Port A
        AND     D               ;to illuminate 1 to 3 LED.
        OUT     (PIA0DA),A
M13     IN      A,(PIA0DA)       ;Check the illuminated
        LD      H,09            ;LED lamps connected to
        LD      L,0             ;Port A
M14     DEC     H
        JR      Z,M15
        RLC     A
        JR      C,M14
        INC     L
        JR      M14
M15     LD      A,L             ;If L = 1, only one
        CP      01              ;LED lamp was illuminated.
        JR      NZ,M16
        LD      IX,TAB5         ;Load the starting address
                                ;of TONE to IY.
        LD      H,20            ;Put the score to H.
        JR      M23
M16     CP      02              ;If L = 2, two LED
        JR      NZ,M17          ;lamps were illuminated.
        LD      IY,TAB2         ;Load the stating address
                                ;of TAB2 to IY.
        LD      H,95            ;Load score to H.
        JR      M23
M17     IN      A,(PIA0DA)       ;Check to see how many
        LD      L,08            ;LED lamps on Port A
M18     DEC     L               ;are illuminated?
        JR      Z,M19           ;If three adjecent LED
        RLC     A               ;lamps are illuminated,
        JR      C,M18           ;load 5 to H (which is
        RLC     A               ;the register used to put
        JR      C,M18           ;score.)
        LD      IY,TAB4         ;Load the starting address
                                ;of TAB4 to IY.
        LD      H,05
        JR      M23
M19     IN      A,(PIA0DA)       ;Check the illuminated
        LD      L,08            ;LED lamps on Port A.
M20     LD      E,03            ;If the three lighted
        DEC     L               ;LED lamps are of the 
        JR      Z,M22           ;same color,
M21     RLC     A                                            ;page 3
        JR      C,M20
        RLC     A
        JR      NC,M20
        DEC     E
        JR      NZ,M21
        LD      H,03            ;then load 3 to H,
        LD      IY,TAB3         ;and load the stating address
                                ;of TAB3 to IY.
        JR      M23
M22     LD      H,98            ;If none of the above happens,
                                ;load 98H (-2 in decimal)
                                ;to H.
        LD      IY,TAB1         ;and load TAB1 to IY.
M23     CALL    TONE            ;Generate a tone.
        LD      A,(SCORE)       ;Add accumulated score
        ADD     A,H             ;together.
        DAA
        CP      01              ;If total score < 1,
        JP      P,M24
        LD      IY,TAB7         ;load TAB7 to IY.
        CALL    TONE            ;After generating a tone,
        JP      M1              ;jump to M1 to replay
                                ;the game.
M24     CP      50              ;If the total score > 50,
        JP      M,M25
        LD      IY,TAB6         ;load TAB6 to IY.
        CALL    TONE            ;After generating a tone,
        JP      M1              ;jump to M1 to replay.
M25     LD      HL,SCOBF
        LD      (SCORE),A       ;Load score to SCORE.
        CALL    HEX7SG          ;Convert score to
                                ;display pattern.
        LD      H,0BBH
M26     CALL    SCAN1
        DEC     H               ;Press any key of the MPF-I,
        JR      NZ,M26
        JP      M3              ;then jump to M3.
SCORE   DEFS    2
SCOBF   DEFS    6
TAB1:   DEFW    0BB22H
        DEFW    0DD66H
        DEFW    0FF99H
        DEFB    0
TAB2:   DEFW    5566H
        DEFW    0AA99H
        DEFW    0DDCCH
        DEFW    0FF99H
        DEFB    0
TAB3:   DEFW    0AA11H
        DEFW    8822H
        DEFW    6633H
        DEFB    0
TAB4:   DEFW    0AA11H
        DEFW    8833H
        DEFW    0AA11H
        DEFW    8833H
        DEFB    0
TAB5:   DEFW    0FF77H                                  ; page 4
        DEFW    0EE66H
        DEFW    0DD55H
        DEFW    0CC44H
        DEFW    0BB33H
        DEFW    0AA22H
        DEFW    9911H
        DEFW    8811H
        DEFW    8888H
        DEFW    7799H
        DEFB    0
TAB6:   DEFW    0FF11H
        DEFW    0EE22H
        DEFW    0DD33H
        DEFW    0CC44H
        DEFW    0BB55H
        DEFW    0AA66H
        DEFW    9977H
        DEFB    0
TAB7:   DEFW    11FFH
        DEFW    22EEH
        DEFW    33DDH
        DEFW    44CCH
        DEFW    55BBH
        DEFW    66AAH
        DEFW    7799H
        DEFW    0AAFFH
        DEFB    0
TONE    EXX
M90     LD      A,(IX+0)
        LD      E,A
        CP      00H
        JR      Z,M200
        INC     IY
        LD      C,(IY+0)
        LD      A,0FFH
M100    OUT     (02),A
        LD      B,A
M150    NOP
        NOP
        NOP
        DJNZ    M150
        XOR     80H
        DEC     C
        JR      NZ,M100
        INC     IY
        JR      M90
M200    EXX
        RET
        
