;MPF-I AS TRAFFIC LIGHT CONTROLLER ;
; Retyped from scans fjkraan@electrickery.nl. 2021-09-16
; Added 2nd light; original is direction 1, new is direction 2

        ORG     2000H
PIODA   EQU     80H         ;DATA PORT OF PIO   CHANNEL A
PIOCA   EQU     82H         ;CONTROL PORT OF PIO  CHANNEL A
D1GRN   EQU     01H         ; Direction 1 bits
D1YLW   EQU     02H
D1RED   EQU     04H
D2GRN   EQU     10H         ; Direction 2 bits
D2YLW   EQU     20H
D2RED   EQU     40H

START:
        LD      A,0FH
        OUT     (PIOCA),A   ;PIO PORT A OUTPUT MODE
BEGIN:
        ; D1 green, D2 red
        LD      A,D1GRN + D2RED
        OUT     (PIODA),A   ;GREEN LED LIGHT D1
        CALL    DELAYG
        LD      B,4
FLASH1: ; D1 green blinking
        PUSH    BC
        LD      A,0 + D2RED
        OUT     (PIODA),A
        CALL    DELAYF
        LD      A,D1GRN + D2RED
        OUT     (PIODA),A
        CALL    DELAYF
        POP     BC
        DJNZ    FLASH1
        
        ; D1 yellow, D2 red
        LD      A,D1YLW + D2RED
        OUT     (PIODA),A       ;YELLOW LED LIGHT
        CALL    DELAYY          ;1.725 SEC
        
        ; D1 red, D2 red
        LD      A,D1RED + D2RED
        OUT     (PIODA),A
        CALL    DELAYR
        
        ; D1 red, D2 green
        LD      A,D1RED + D2GRN
        OUT     (PIODA),A   ;GREEN LED LIGHT D2
        CALL    DELAYG
        LD      B,4
FLASH2: ; D2 green blinking
        PUSH    BC
        LD      A,D1RED + 0
        OUT     (PIODA),A
        CALL    DELAYF
        LD      A,D1RED + D2GRN
        OUT     (PIODA),A
        CALL    DELAYF
        POP     BC
        DJNZ    FLASH2
        
        ; D1 red, D2 yellow
        LD      A,D1RED + D2YLW
        OUT     (PIODA),A       ;YELLOW LED LIGHT
        CALL    DELAYY          ;1.725 SEC
        
        ; D1 red, D2 red
        LD      A,D1RED + D2RED
        OUT     (PIODA),A
        CALL    DELAYR
        
        JP      BEGIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       DELAY 4 8 1.24 SEC = 5 SEC  SUBROUTINE
;       0.56 US * (16 + 4 + 4 + 10 ) * 65536 =1.25 SEC
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DELAYR:     ; red delay
        LD      D,4             ;  7T
DELX:
        LD      BC,0            ;  10T
DE0:
        CPI                     ;  16T
        NOP                     ;  4T
        NOP                     ;  4T
        JP      PE,DE0          ;  10T
        DEC     D
        JR      NZ,DELX
        RET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       DELAY 0.5 SEC SUBROUTINE
;       0.56 US * (16 + 4 + 4 + 11 + 12 ) * 19000 =0.5 SEC   
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   
DELAYF:     ; flash delay
        LD      BC,4A38H
DE1:
        CPI
        NOP
        NOP
        RET     PO
        JR      DE1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       DELAY 1.725 SEC SUBROUTINE
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DELAYG:     ; green delay
DELAYY:     ; yellow delay
        LD      BC,0
DE2:
        CPI
        NOP
        NOP
        RET     PO
        JR      DE2
