;*************************************************          ; page 1
;  FREQUENCY COUNTER : COUNT THE FREQUENCY OF THE*
;                    INPUT SIGNAL                * ; Retyped from scans fjkraan@electrickery.nl. 2021-09-14
;************************************************* ;  while keeping original line numbers
;
CTC0:   EQU     40H         ;CHANNEL 0 OF CTC
CTC1:   EQU     41h         ;CHANNEL 1 OF CTC
SCAN1:  EQU     0624H
DATADP: EQU     0671H       ;CHANGE DATA IN                        ;A_REG TO DISPLAY FORMAT
KEY_GO  EQU     16H         ; original text says 'DEY_GO'
;
; PROGRAM BEGIN HERE!
        ORG     2000H       ; missing from original text
START:
        LD      HL,TIMEOUT  ; HL --> COUNT BUFFER
        XOR     A           ; RESET A
        LD      B,0AH       ; CLEAR FREQ  &  TIMER             ; COUNTER BUFFER
CLEAR  LD      (HL),A
        INC     HL
        DJNZ    CLEAR
        ;
;SET CTC INITIAL CONDITION
;                                   CTC CH0 CLK/TRG0: pin 23 / MPF-I, P2-31
        LD      A,20H       ;SET INTERRUPT REGISTER     ;VALUE
        LD      I,A
        LD      A,11010101B ;SET CH COUNTER MODE,       ;POSITIVE TRIGGER
        OUT     (CTC0),A
        LD      A,100       ;SET THE VALUE OF           ;DOWN COUNTER
        OUT     (CTC0),A    
        LD      A,40H       ;SET INTERRUPT VECTOR
        OUT     (CTC0),A
        ;
        LD      A,10110101B ;SET CH1 TIMER CODE,        ;RANGE 256, POSITIVE    ;TRIGGER
        OUT     (CTC1),A
        LD      A,0E9H      ;SET TIME CONSTANT
        OUT     (CTC1),A
        IM      2
        EI
        JR      $
        ;
        DEFS    40H-($-START)
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CTC_INT:                    ;SET INTERRUPT SERVICE ROUTINE POINTER
        DEFW    FREQ_INT
        DEFW    TIME_INT                                    ; page 2
        ;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
FREQ_INT:
;FREQUENCY COUNTER INTERRUPT SERVICE ROUTINE
;INCREASE COUNTER AND CONVERT TO DECIMAL FORMAT
;
        EI                  ;WHEN CPU ENTER THIS INTERRUPT   ;SERVICE
                            ;ROUTINE, IT WILL DISABLE        ;ANOTHER INTERRUPT
                            ;SO "EI" CAN LET COUNT_INT       ;HAPPEN
        LD      HL,FREQCNT+1
        LD      B,2         ;SET FREQUENCY BUFFER            ;COUNTERR
ADDONE:
        EI
        LD      A,(HL)
        ADD     A,1         ;INCREASE COUNTE BY ONE
        DAA                 ;CHANGE TO DECIMAL FORMAT
        LD      (HL),A      ;RESTORE VALUE
        JR      NC,NOTOVER  ;NOT OVER 99
        INC     HL          ;OVER,MUST INCREASE HIGH        ;ORDER BUE ONE
        DJNZ    ADDONE
        LD      IX,OVER     ;FREQUENCY LARGER THEN          ;999999 DISPLAY '-OVER-'
        JR      DISPLAY
NOTOVER:
        RETI
        ;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TIME_INT:
;CH1 (TIMER MODE)  INTERRUPT SERVICE ROUTINE
;GH1: TRIGGERED BY 'MPF-1' CLOCK(1789772HZ)
;EVERY 256*233 HZ, THIS SERVICE ROUTINE WILL DO AGAIN
;UNTIL 30 TIMES (--1 SEC),PROGRAM HALT AND SIGNAL       ;FREQUENCY GET
        EI                  ;LET ANOTHER INTERRUPT      ;CAN HAPPEN ANYTIME
        IN      A,(CTC0)    ;GET CTC0  GOWN  COUNTER    ;RESIDUE VALUE
        SUB     100
        NEG
        LD      (FREQCNT),A ;SAVE THIS TO BUFFER
        ;
        LD      HL,TIMEOUT  ;INCREASE TIME COUNTER BY
        LD      A,(HL)
        INC     A
        LD      (HL),A      ;RESTORE VALUE
        CP      01EH        ;CHECK ONE SEC ?
        JR      NC,END      ;YES
        RETI
                                                            ; page 3
;***************************************************************************
END:
        DI
        LD      B,2         ;CHANGE LOWER BYTE      ;OF FREQUENCY COUNTER   ;TO DECIMAL FORMAT
        XOR     A
        LD      HL,FREQCNT
CHANGE: RRD
        ADC     A,0
        DAA
        DJNZ    CHANGE
        RRD
        ;
        LD      B,3
        LD      DE,FREQCNT  ;CHANGE FREQ TO DISPLAY ;PATTERN
        LD      HL,OUTBUF
CONVERT:
        LD      A,(DE)
        INC     DE
        CALL    DATADP+3
        DJNZ    CONVERT
        ;
        LD      IX,OUTBUF   ;DISPLAY DATA TO LED
DISPLAY:CALL    SCAN1
        JR      C,DISPLAY   ;NO KEY PRESSED,SCAN    ;AGAIN
        CP      KEY_GO      ;PRESSED 'GO' ?
        JR      NZ,DISPLAY  ;NO
        LD      HL,START    ;RETURN TO PROGRAM      ;STRTING ADDR. &    ;COUNT FREQUENCY AGAIN
        EX      (SP),HL
        RETI
        ;
        ;
TIMEOUT DEFS    1           ;TIMER COUNT BUFFER
FREQCNT DEFS    3           ;FREQUENCY COUNT BUFFER
OUTBUF  DEFS    6           ;DISPLAY BUFFER
OVER:
        DEFB    02H         ;'-'
        DEFB    03H         ;'R'
        DEFB    08FH        ;'E'
        DEFB    0B7H        ;'V'
        DEFB    0A3H        ;'O'
        DEFB    02H         ;'-'
