// hooaagUsbBox1

$fn = 32;

iWidth = 32.0;
iLength = 19.0;
iHeight = 13.0;
wall = 1.5;

width = iWidth + 2 * wall;
length = iLength + 2 * wall;
height = iHeight + 2 * wall;
camfer = 3.0;

reduce = cos(45) * camfer;
iReduce = reduce * 0.5;
dotRad = 0.1;

barrelJackHoleDiam = 5.0;
uUSBLength = 9.5;
uUSBHeight = 4.0;
uUSBHoleHeight =  wall + 9.0;
pcbSupportHeight = uUSBHoleHeight - wall - 1.6;

plateWidth = 14.0;
terminalDist = 16.5;
terminalHeight = wall + 6.0;
terminalExitHoleDiam = 10.0;

echo(reduce);

module mainBox() {
    difference() {
        hull() { // outside
            translate([reduce, reduce, 0]) baseSquare(length-reduce*2, width-reduce*2);
            translate([0,0,wall])   camferSquare(length, width, 2);
            translate([0,0,height]) camferSquare(length, width, 2);
        }
        hull() { // inside
            translate([wall, wall, wall]) {
                translate([iReduce, iReduce, 0]) baseSquare(iLength-iReduce*2, iWidth-iReduce*2);
                translate([0,0,wall]) camferSquare(iLength, iWidth, iReduce);
                translate([0,0,iHeight + 5]) camferSquare(iLength, iWidth, iReduce);
            }
        } 
        // top ridges for lid
        translate([width / 2, wall * 1.6, iHeight + 1.8]) ridge();
        translate([width / 2, length - wall * 1.6, iHeight + 1.8]) ridge();
        // USB
        translate([width - wall - 0.01, (length - uUSBLength) / 2, uUSBHoleHeight]) 
          cube([wall + 0.02, uUSBLength, uUSBHeight]);
        // barrelJackHole
        translate([-0.01, (length ) / 2, 4.5])
            rotate([0, 90, 0])
                cylinder(d = barrelJackHoleDiam, h = wall + 2);
    }
    // PCB supports
    translate([iWidth - wall, wall, wall]) cube([wall, iLength, pcbSupportHeight]);
    translate([iWidth - 20.0, 0, 0]) {
        difference() {
            translate([0, wall, wall]) cube([wall, iLength, pcbSupportHeight]);
            translate([wall / 2 - 0.01, iLength/2 + 1.5, pcbSupportHeight]) cube([wall + 0.2, 5, 5], true);
        }
    }
}

// testPCB
//translate([wall + 0.5, wall + 0.75, pcbSupportHeight]) color("green") cube([31.5, 17.5, 1.6]);


module ridge() {
    rotate([45, 0, 0]) cube([width - wall * 5, wall, wall], true);
}

module baseSquare(l, w, red = 0) {
    translate([red + dotRad, red + dotRad, dotRad]) sphere(r = dotRad);
    translate([w - (red + dotRad), red + dotRad, dotRad]) sphere(r = dotRad);
    translate([red + dotRad, l - (red + dotRad), dotRad]) sphere(r = dotRad);
    translate([w - (red + dotRad), l - (red + dotRad), dotRad]) sphere(r = dotRad);   
}
module camferSquare(l, w, red = 0) {
    translate([dotRad, red + dotRad, dotRad]) sphere(r = dotRad);
    translate([red + dotRad, dotRad, dotRad]) sphere(r = dotRad);
    translate([w - (dotRad), red + dotRad, dotRad]) sphere(r = dotRad);
    translate([w - (red + dotRad), dotRad, dotRad]) sphere(r = dotRad);
    translate([dotRad, l - (red + dotRad), dotRad]) sphere(r = dotRad);
    translate([red + dotRad, l - (dotRad), dotRad]) sphere(r = dotRad);
    translate([w - (dotRad), l - (red + dotRad), dotRad]) sphere(r = dotRad);   
    translate([w - (red + dotRad), l - (dotRad), dotRad]) sphere(r = dotRad);   
}
mainBox();
 