//DC37backPlatePowerPlug3
$fn = 32;

wall = 1.0;
plateThick = 2.0;
plateWidth = 72.0;
plateHeight = 18.0;
plateRounding = 1.0;
holeDist = 64.0;

difference() {
    dcHolePlate();
    translate([0, 0, -0.01]) {
        powerPlugHole(bhWall = 4.0);
        translate([-holeDist / 2, 0, 0]) cylinder(d = 3.0, h = wall * 3);
        translate([ holeDist / 2, 0, 0]) cylinder(d = 3.0, h = wall * 3);
    }
}

module dcHolePlate() {
    translate([0, 0, plateThick]) DCshell(wall);
    taperPlate();
}

module taperPlate() {
    plateWoffset = plateWidth/2 - plateRounding;
    plateHoffset = plateHeight/2 - plateRounding;
    hull() {
        translate([-plateWoffset, 0, 0]) {
            translate([0, -plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
            translate([0,  plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
        }
        translate([ plateWoffset, 0, 0]) {
            translate([0, -plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
            translate([0,  plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
        }
    }
}

module subDEHoles(wall) {
    $fn = 32;
    // side holes
    translate([-3.0, 11.0 / 2, 0]) 
        cylinder(d = 3.0, h = wall + 0.02);
    translate([63.5 + 3.0, 11.0 / 2, 0]) 
        cylinder(d = 3.0, h = wall + 0.02);
 }

module DCshell(wall) {
    $fn = 32;
    subDEcornerRad = 3.0;
    subDEWidth = 57.4;
    subDEHeight = 11.0;
    subDEWidthReduc = 2.0;
    subDEHoleDist = 63.5;
    subDEHoleXOffset = -3.0;
    caseWall = wall;
    translate([0, 0, 0]) {
    // sub-DE shaped hole
        hull() {
            translate([0, subDEHeight/2 - subDEcornerRad, 0]) {
                translate([-subDEWidth/2 + subDEcornerRad, 0, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([ subDEWidth/2 - subDEcornerRad, 0, 0])
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            }
            translate([0, -subDEHeight/2 + subDEcornerRad, 0]) {
                translate([-subDEWidth/2 + subDEcornerRad, 0, 0])
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([ subDEWidth/2 - subDEcornerRad, 0, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            }
        }
    }
}

module powerPlugHole(backHoleH = 11.7, backHoleW = 9.2, bhWall = 2.0, holeDist = 16.0) {
    offset = backHoleH - backHoleW;
    cubeHeight = backHoleW/2 + offset;
    cylinder(d = backHoleW, h = bhWall);
    translate([cubeHeight/2, 0, bhWall/2]) 
        cube([cubeHeight, backHoleW, bhWall], true);
    
    translate([holeDist - 7.0, 0, 0]) cylinder(d = 2.7, h = bhWall);
    translate([-(holeDist - 9.5), 0, 0]) cylinder(d = 2.7, h = bhWall);
}

//translate([0, 0, -1]) color("red") cube([57.4, 2, 2], true);